#!/bin/bash
#                           Digital Alarm Clock
#                Copyright (C) 2023 - Stefan Keller-Tuberg
#                       skt@keller-tuberg.homeip.net
#
# This file is part of the Digital Alarm Clock project.
#
# The Digital Alarm Clock project is free software: you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published by the
# Free Software Foundation, either version 3 of the License, or (at your option)
# any later version.
#
# The Digital Alarm Clock project is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# the Digital Alarm Clock project.  If not, see <http://www.gnu.org/licenses/>.
####################################################################################################################
THIS_SCRIPT="/cgi-bin/playlist.cgi"

# Load common functions and data
INCLUDE_COMMON="common.sh"

if test -f "${INCLUDE_COMMON}" ; then
  . ${INCLUDE_COMMON}
fi
####################################################################################################################
Read_HTML_Parameters
Process_Inputs
Emit_HTML_Headers noborder

echo ' <body>'
echo "  <div class='background'>"

if [[ "${skip_to_track}" =~ ${IsNumber} ]] ; then
  $EXE -j "${skip_to_track}" > /dev/null 2>&1
fi
####################################################################################################################
echo "   <form action='${THIS_SCRIPT}' method='get'>"

# Read ambient light, volume level and remaining playing time
CURRENT_READINGS=$($EXE -a)

if [[ -n "${CURRENT_READINGS}" ]] ; then
  CURRENT_DURATION=$(echo $CURRENT_READINGS | cut -d, -f3)
  CURRENT_BLUETOOTH=$(echo $CURRENT_READINGS | cut -d, -f4)

  # If the media player is OFF or we couldn't read a return value that's sensible, just get out of here
  if [[ "${CURRENT_DURATION}" =~ ${IsNumber} && ${CURRENT_DURATION} -lt 182 ]] || [[ -n "${CURRENT_BLUETOOTH}" && "${CURRENT_BLUETOOTH}" -gt 0 ]] ; then
    # Read the playlist into an array
    readarray -t PlayList < <( ${EXE} -c playlist )

    # Do we have any bluetooth clients connected?
    if [[ -n "${CURRENT_BLUETOOTH}" ]] && [[ "${CURRENT_BLUETOOTH}" -gt 0 ]] && [[ ${#PlayList[@]} -gt 0 ]] ; then
      echo "     <p><b>${CURRENT_BLUETOOTH} bluetooth clients connected</b></p>"
      echo "     <table class='striped'>"
      for ((i=0 ; i < ${#PlayList[@]} ; i++)) ; do
	FIRST_COL=${PlayList[$i]%%,*}
	[[ "${FIRST_COL}" != "0" ]] && continue
	MINUS_FIRST=${PlayList[$i]#*,}
	MIDDLE_COL=${MINUS_FIRST%,*}
	LAST_COL=${PlayList[$i]##*,}

	echo '      <tr>'
	echo "      <td><b>${MIDDLE_COL}</b></td>"
	echo "      <td><b>${LAST_COL}</b></td>"
	echo '      </tr>'
      done

      echo '     </table>'
    fi

    if [[ "${CURRENT_DURATION}" =~ ${IsNumber} ]] && [[ ${CURRENT_DURATION} -lt 182 ]] && [[ -n "${CURRENT_BLUETOOTH}" ]] && [[ "${CURRENT_BLUETOOTH}" -gt 0 ]] ; then
      echo '     <hr/>'
    fi

    if [[ "${CURRENT_DURATION}" =~ ${IsNumber} ]] && [[ ${CURRENT_DURATION} -lt 182 ]] ; then
      if [[ -n ${CURRENT_DURATION} ]] && [[ ${CURRENT_DURATION} -eq 181 ]] ; then
        echo "     <p><b>Nothing playing on clock media player</b></p>"
      else
        echo "     <p><b>Remaining media player playing time: ${CURRENT_DURATION} minutes</b></p>"
      fi

      if [[ ${#PlayList[@]} -gt 0 ]] ; then
        echo "     <table class='striped'>"

        # Display the playlist. It is in CSV format - display in a borderless table
        # There are three fields in the playlist. The middle field is enclosed in double quotes, so the
        # termination for the middle field is actually ", rather than double quote or comma on its own
        for ((i=0 ; i < ${#PlayList[@]} ; i++)) ; do
	  # We can't break the fields based on commas if there are commas embedded in the filename
	  # Assume that the first col and last col are deliminated by commas, and the middle col is
	  # delimited by ," and ",
	  FIRST_COL=${PlayList[$i]%%,*}
	  [[ "${FIRST_COL}" == "0" ]] && continue
	  MINUS_FIRST=${PlayList[$i]#*,}
	  MIDDLE_COL=${MINUS_FIRST%,*}
	  LAST_COL=${PlayList[$i]##*,}

	  # Remove leading and trailing double quotes from the middle string
	  MIDDLE_COL="${MIDDLE_COL#\"}"
	  MIDDLE_COL="${MIDDLE_COL%\"}"

	  echo '     <tr>'

	  if [[ -n "${LAST_COL}" ]] ; then
	    echo "      <td><b>${FIRST_COL}</b></td>"
	    echo "      <td><b>${MIDDLE_COL}</b></td>"
	    echo "      <td><b>${LAST_COL}</b></td>"
	  else
	    echo "      <td>${FIRST_COL}</td>"
	    echo "      <td><button type='submit' class='linkBlue' name='skip_to_track' value='${FIRST_COL}'>${MIDDLE_COL}</button></td>"
	    echo "      <td>${LAST_COL}</td>"
	  fi

	  echo '     </tr>'
	done

	echo '    </table>'
      else
	echo "     <p>The playlist finished or playing time completed.</p>"
      fi

    else
      echo "     <p>Nothing playing on clock media player</p>"
    fi
  fi
fi

echo '   </form>'
echo '  </div>'
echo ' </body>'
echo '</html>'
exit 0
