OPTION EXPLICIT ON
OPTION AUTORUN ON

CONST XC3746_DAT_PIN = 21
CONST XC3746_CLK_PIN = 22
CONST BIT_DELAY = 0.001
CONST XC3746_OFF = &H80
CONST XC3746_AUTOINC = &H40
CONST XC3746_SETCOLUMN = &HC0
CONST XC3746_SETDUTY = &H88
DIM XC3746_COLUMN AS INTEGER
DIM INTEGER NUMBER_BITMAP(43) =(62,65,62,0,66,127,64,0,113,73,70,0,73,73,54,0,30,16,127,0,79,73,49,0,60,74,49,0,97,25,7,0,119,73,119,0,70,73,62,0,0,0,0,0)

DIM INTEGER DIGITS(4)
DIM INTEGER COUNT

XC3746_INIT
XC3746_SETALL(0)
XC3746_SET_BRIGHTNESS(2)
PAUSE 1000
XC3746_SETALL(255)
PAUSE 1000
XC3746_SETALL(0)
XC3746_SEND_ARRAY(NUMBER_BITMAP(),0,16)

DO
	COUNT=TIMER\1000
	DIGITS(0)=(COUNT\1000) MOD 10	''calculate digits
	DIGITS(1)=(COUNT\100) MOD 10
	DIGITS(2)=(COUNT\10) MOD 10
	DIGITS(3)=(COUNT) MOD 10
	XC3746_COLUMN=0		''start new display
	XC3746_SEND_ARRAY(NUMBER_BITMAP(),DIGITS(0)*4,4)	''print out digits in order
	XC3746_SEND_ARRAY(NUMBER_BITMAP(),DIGITS(1)*4,4)
	XC3746_SEND_ARRAY(NUMBER_BITMAP(),DIGITS(2)*4,4)
	XC3746_SEND_ARRAY(NUMBER_BITMAP(),DIGITS(3)*4,4)
	PAUSE 100
LOOP


SUB XC3746_SEND_ARRAY(C() AS INTEGER, S AS INTEGER, N AS INTEGER)	''N bytes from C starting at S
	LOCAL INTEGER I
	XC3746_START	
	XC3746_BYTE(XC3746_SETCOLUMN OR (XC3746_COLUMN AND 15))	''column
	FOR I = 0 to N-1
		XC3746_BYTE(C(S+I))	''data
	NEXT I
	XC3746_STOP
	XC3746_COLUMN=(XC3746_COLUMN+N) AND 15
END SUB

SUB XC3746_SET_BRIGHTNESS(C AS INTEGER)	''from 0 to 7, also turns on if off
	XC3746_COMMAND(XC3746_SETDUTY OR (C AND 7))
END SUB

SUB XC3746_SEND_COLUMN(C AS INTEGER)
	XC3746_START	
	XC3746_BYTE(XC3746_SETCOLUMN OR (XC3746_COLUMN AND 15))	''column
	XC3746_BYTE(C)	''data
	XC3746_STOP
	XC3746_COLUMN=(XC3746_COLUMN+1) AND 15
END SUB

SUB XC3746_INIT
	SETPIN XC3746_DAT_PIN,DOUT
	SETPIN XC3746_CLK_PIN,DOUT
	XC3746_STOP	''ensure idle
	XC3746_COMMAND(XC3746_OFF)
	XC3746_COMMAND(XC3746_AUTOINC)
	XC3746_COLUMN=0
END SUB

SUB XC3746_SETALL(C AS INTEGER)	''typically used with 0 to clear
	LOCAL INTEGER I
	XC3746_START	
	XC3746_BYTE(XC3746_SETCOLUMN OR 0)	''column 0
	FOR I = 0 TO 15
		XC3746_BYTE(C)	''clear
	NEXT I
	XC3746_STOP
END SUB

SUB XC3746_COMMAND(C AS INTEGER)
	XC3746_START
	XC3746_BYTE(C)
	XC3746_STOP
END SUB

SUB XC3746_START
	'PRINT "START ";	''for debugging
	PIN(XC3746_CLK_PIN)=1
	PAUSE BIT_DELAY
	PIN(XC3746_DAT_PIN)=1
	PAUSE BIT_DELAY
	PIN(XC3746_DAT_PIN)=0
	PAUSE BIT_DELAY
END SUB

SUB XC3746_STOP
	'PRINT "STOP"		''for debugging
	PIN(XC3746_CLK_PIN)=0
	PAUSE BIT_DELAY
	PIN(XC3746_DAT_PIN)=0
	PAUSE BIT_DELAY
	PIN(XC3746_CLK_PIN)=1
	PAUSE BIT_DELAY
	PIN(XC3746_DAT_PIN)=1
	PAUSE BIT_DELAY
END SUB

SUB XC3746_BYTE(C AS INTEGER)
	'PRINT "DATA ";C;" ";	''for debugging
	PIN(XC3746_CLK_PIN)=0
	PAUSE BIT_DELAY
	IF (C AND 1) > 0 THEN PIN(XC3746_DAT_PIN)=1 ELSE PIN(XC3746_DAT_PIN)=0
	PAUSE BIT_DELAY
	PIN(XC3746_CLK_PIN)=1
	PAUSE BIT_DELAY
	PIN(XC3746_CLK_PIN)=0
	PAUSE BIT_DELAY
	IF (C AND 2) > 0 THEN PIN(XC3746_DAT_PIN)=1 ELSE PIN(XC3746_DAT_PIN)=0
	PAUSE BIT_DELAY
	PIN(XC3746_CLK_PIN)=1
	PAUSE BIT_DELAY
	PIN(XC3746_CLK_PIN)=0
	PAUSE BIT_DELAY
	IF (C AND 4) > 0 THEN PIN(XC3746_DAT_PIN)=1 ELSE PIN(XC3746_DAT_PIN)=0
	PAUSE BIT_DELAY
	PIN(XC3746_CLK_PIN)=1
	PAUSE BIT_DELAY
	PIN(XC3746_CLK_PIN)=0
	PAUSE BIT_DELAY
	IF (C AND 8) > 0 THEN PIN(XC3746_DAT_PIN)=1 ELSE PIN(XC3746_DAT_PIN)=0
	PAUSE BIT_DELAY
	PIN(XC3746_CLK_PIN)=1
	PAUSE BIT_DELAY
	PIN(XC3746_CLK_PIN)=0
	PAUSE BIT_DELAY
	IF (C AND 16) > 0 THEN PIN(XC3746_DAT_PIN)=1 ELSE PIN(XC3746_DAT_PIN)=0
	PAUSE BIT_DELAY
	PIN(XC3746_CLK_PIN)=1
	PAUSE BIT_DELAY
	PIN(XC3746_CLK_PIN)=0
	PAUSE BIT_DELAY
	IF (C AND 32) > 0 THEN PIN(XC3746_DAT_PIN)=1 ELSE PIN(XC3746_DAT_PIN)=0
	PAUSE BIT_DELAY
	PIN(XC3746_CLK_PIN)=1
	PAUSE BIT_DELAY
	PIN(XC3746_CLK_PIN)=0
	PAUSE BIT_DELAY
	IF (C AND 64) > 0 THEN PIN(XC3746_DAT_PIN)=1 ELSE PIN(XC3746_DAT_PIN)=0
	PAUSE BIT_DELAY
	PIN(XC3746_CLK_PIN)=1
	PAUSE BIT_DELAY
	PIN(XC3746_CLK_PIN)=0
	PAUSE BIT_DELAY
	IF (C AND 128) > 0 THEN PIN(XC3746_DAT_PIN)=1 ELSE PIN(XC3746_DAT_PIN)=0
	PAUSE BIT_DELAY
	PIN(XC3746_CLK_PIN)=1
	PAUSE BIT_DELAY
END SUB
