//protocol is like I2C, but uses the address space as commands, has no
//ack and has the bit order reversed, so can't share a bus.
//all examples use a push-pull bus, which looks to be faster.

//define our own pins:
#define XC3746_CLK 11
#define XC3746_DAT 10
#define XC3746_BIT_DELAY delayMicroseconds(1);
//#define XC3746_BIT_DELAY ;
//commands:
#define XC3746_AUTOINC 0x40
#define XC3746_SETCOLUMN 0xC0 //takes 4 bits in LSB
#define XC3746_SETDUTY 0x88   //takes 3 bits in LSB, also display on
#define XC3746_OFF 0x80 

unsigned char XC3746_column=0;
const unsigned char XC3746_font[][4]={
  {62,65,62,0},    //0
  {66,127,64,0},   //1
  {113,73,70,0},   //2
  {73,73,54,0},    //3
  {30,16,127,0},    //4
  {79,73,49,0},    //5
  {60,74,49,0},    //6
  {97,25,7,0},    //7
  {119,73,119,0},    //8
  {70,73,62,0},    //9
  {0,0,0,0} //space
};
const unsigned char XC3746_font2[][5]={
  {62,65,65,62,0},    //0
  {0,66,127,64,0},    //1
  {98,81,73,70,0},    //2
  {65,73,73,54,0},    //3
  {48,44,34,127,0},    //4
  {71,69,69,57,0},    //5
  {60,74,73,48,0},    //6
  {1,113,13,3,0},    //7
  {54,73,73,54,0},    //8
  {6,73,73,62,0},    //9
  {0,0,0,0,0} //space
};

unsigned char bitReverse(unsigned char c){
  unsigned char d=0;
  if(c&128){d=d|1;}
  if(c& 64){d=d|2;}
  if(c& 32){d=d|4;}
  if(c& 16){d=d|8;}
  if(c&  8){d=d|16;}
  if(c&  4){d=d|32;}
  if(c&  2){d=d|64;}
  if(c&  1){d=d|128;}
  return d;
}

void XC3746_start(void){  //also works as init
  pinMode(XC3746_CLK,OUTPUT);
  pinMode(XC3746_DAT,OUTPUT);
  digitalWrite(XC3746_CLK,LOW);
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_DAT,LOW);
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_DAT,HIGH);
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_CLK,HIGH);
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_DAT,LOW);
  XC3746_BIT_DELAY;
}

void XC3746_data(unsigned char c){
  digitalWrite(XC3746_CLK,LOW);
  XC3746_BIT_DELAY;  
  if(c&1){digitalWrite(XC3746_DAT,HIGH);}else{digitalWrite(XC3746_DAT,LOW);}
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_CLK,HIGH);
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_CLK,LOW);
  XC3746_BIT_DELAY;
  if(c&2){digitalWrite(XC3746_DAT,HIGH);}else{digitalWrite(XC3746_DAT,LOW);}
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_CLK,HIGH);
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_CLK,LOW);
  XC3746_BIT_DELAY;
  if(c&4){digitalWrite(XC3746_DAT,HIGH);}else{digitalWrite(XC3746_DAT,LOW);}
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_CLK,HIGH);
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_CLK,LOW);
  XC3746_BIT_DELAY;
  if(c&8){digitalWrite(XC3746_DAT,HIGH);}else{digitalWrite(XC3746_DAT,LOW);}
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_CLK,HIGH);
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_CLK,LOW);
  XC3746_BIT_DELAY;
  if(c&16){digitalWrite(XC3746_DAT,HIGH);}else{digitalWrite(XC3746_DAT,LOW);}
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_CLK,HIGH);
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_CLK,LOW);
  XC3746_BIT_DELAY;
  if(c&32){digitalWrite(XC3746_DAT,HIGH);}else{digitalWrite(XC3746_DAT,LOW);}
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_CLK,HIGH);
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_CLK,LOW);
  XC3746_BIT_DELAY;
  if(c&64){digitalWrite(XC3746_DAT,HIGH);}else{digitalWrite(XC3746_DAT,LOW);}
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_CLK,HIGH);
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_CLK,LOW);
  XC3746_BIT_DELAY;
  if(c&128){digitalWrite(XC3746_DAT,HIGH);}else{digitalWrite(XC3746_DAT,LOW);}
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_CLK,HIGH);
  XC3746_BIT_DELAY;
}

void XC3746_stop(void){
  digitalWrite(XC3746_CLK,LOW);
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_DAT,LOW);
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_CLK,HIGH);
  XC3746_BIT_DELAY;
  digitalWrite(XC3746_DAT,HIGH);
  XC3746_BIT_DELAY;
}

void XC3746_sendCommand(unsigned char c){
  XC3746_start();
  XC3746_data(c);
  XC3746_stop();
}

void XC3746_setDuty(unsigned char c){
  XC3746_sendCommand(XC3746_SETDUTY | (c&0x7));
}

void XC3746_sendColumn(unsigned char c){
  XC3746_start();
  XC3746_data(XC3746_SETCOLUMN | (XC3746_column&0xF));  //column=0
  XC3746_data(c);
  XC3746_stop();
  XC3746_column++;
}

void XC3746_sendArray(unsigned char* c){
  char i;
  XC3746_start();
  XC3746_data(XC3746_SETCOLUMN);  //column=0
  for(i=0;i<16;i++){
    XC3746_data(c[i]);
  }
  XC3746_stop();
  XC3746_column=0;
}

void XC3746_init(void){
  char i;
  XC3746_sendCommand(XC3746_OFF);       //blank
  XC3746_sendCommand(XC3746_AUTOINC);   //autoinc
  XC3746_start();
  XC3746_data(XC3746_SETCOLUMN);  //column=0
  for(i=0;i<16;i++){
    XC3746_data(0);               //clear RAM
  }
  XC3746_stop();
  XC3746_column=0;
  //just need to set duty to turn on
}

void XC3746_sendDigit(char c){
  char i;
  XC3746_start();
  XC3746_data(XC3746_SETCOLUMN | (XC3746_column&0xF));
  XC3746_data(XC3746_font[c][0]);
  XC3746_data(XC3746_font[c][1]);
  XC3746_data(XC3746_font[c][2]);
  XC3746_data(XC3746_font[c][3]);
  XC3746_stop();
  XC3746_column=XC3746_column+4;
}

void XC3746_sendDigitReverse(char c){
  char i;
  XC3746_start();
  XC3746_data(XC3746_SETCOLUMN | ((XC3746_column+13)&0xF));  //15 is leftmost
  XC3746_data(bitReverse(XC3746_font[c][3]));
  XC3746_data(bitReverse(XC3746_font[c][2]));
  XC3746_data(bitReverse(XC3746_font[c][1]));
  XC3746_data(bitReverse(XC3746_font[c][0]));
  XC3746_stop();
  XC3746_column=XC3746_column+12;
}

void XC3746_sendColumnReverse(unsigned char c){
  XC3746_start();
  XC3746_data(XC3746_SETCOLUMN | (XC3746_column&0xF));  //15 is leftmost
  XC3746_data(bitReverse(c));
  XC3746_stop();
  XC3746_column--;
}

void XC3746_sendDigitReverse2(char c){
  char i;
  XC3746_start();
  XC3746_data(XC3746_SETCOLUMN | ((XC3746_column+12)&0xF));  //15 is leftmost
  XC3746_data(bitReverse(XC3746_font2[c][4]));
  XC3746_data(bitReverse(XC3746_font2[c][3]));
  XC3746_data(bitReverse(XC3746_font2[c][2]));
  XC3746_data(bitReverse(XC3746_font2[c][1]));
  XC3746_data(bitReverse(XC3746_font2[c][0]));
  XC3746_stop();
  XC3746_column=XC3746_column+11;
}

void XC3746_sendArrayReverse(unsigned char* c){
  char i;
  XC3746_start();
  XC3746_data(XC3746_SETCOLUMN);  //column=0, draw backwards
  for(i=15;i>=0;i--){
    XC3746_data(bitReverse(c[i]));
  }
  XC3746_stop();
  XC3746_column=0;
}