LongPress=25                		  ' Set Delay for LongPress
Button = 7                  		  ' Button pin number
RotaryValue = 0             		  ' Rotary Common Pin Number
RotaryA = 2                 		  ' RotaryA Pin Number
RotaryB = 3                		      ' RotaryB Pin Number
SetPin RotaryB, Din         		  ' Set Pin to Digital In
SetPin RotaryA, INTH, RotaryInterrupt ' Set Pin To Interrupt
SetPin Button , Din                   ' Set Pin To Digital In
Dim RTCbuff(3)
GoSub ReadSettings            	      ' Read Brightness setting from EEProm

StartUp:          ' Meter Swoop
For C=0 To 1
  For I = 0 To 100
    PWM 1, 1000 ,I, I
    Pause 50
  Next I
Next C

SetTick 1000, ReadTime, 1 'Read Time once at 1 second

SetBrightness   ' Set Back Light Brightness

Start:          'Main Loop

SetMeters

Do While Minutes = Val(Mid$(Time$,4,2))
  If Pin(Button) = 0 Then GoSub GetButton
  If ButtonPress=2 Then GoSub SetTheTime
  If ButtonPress=1 Then GoSub LedBrightness
Loop

GoTo Start

Sub SetMeters     'Sub to set meter position
  Hours=Val(Left$(Time$,2))
  Minutes=Val(Mid$(Time$,4,2))
Print Time$

  HoursPWM=Hours*(100/23)
  MinutesPWM=Minutes*(100/59)

Print "Hours PWM %";HoursPWM
Print "Minutes PWM %";MinutesPWM

  PWM 1, 1000, HoursPWM, MinutesPWM
End Sub

Sub SetBrightness   ' Sub To Brightness
  PWM 2, 1000, (100-Brightness)
End Sub


GetButton:
  ' Constant LONGPRESS determines LongPress Time
  ' ButtonPress=0 - No Press
  ' ButtonPress=1 - Short Press
  ' ButtonPress=2 - Long Press

  ButtonPress=0
 Do While Pin(Button)=0
    If ButtonPress<255 Then ButtonPress=ButtonPress+1
    Pause 25 ' This is also our Debounce value
 Loop
  If ButtonPress>0 Then
    If ButtonPress=>LongPress Then
      ButtonPress=2
    Else
      ButtonPress=1
    EndIf
    EndIf
 Return

SetTheTime:
RotaryValue=Val(Left$(Time$,2))

Do While Pin(Button)=1
 Max=23
  If Hours <> RotaryValue Then
    Hours = RotaryValue
Print "Hours";Hours
Print "RotaryVaule";RotaryValue
Time$=Str$(Hours)+":"+Str$(Minutes)+":00"
   SetMeters
  EndIf
Loop

Do While Pin(Button)=0
  Pause 25 'Debounce
Loop

RotaryValue=Minutes

Do While Pin(Button)=1
 Max=59
  If Minutes <> RotaryValue Then
    Minutes = RotaryValue
Print "Minutes";Miniutes
Print "RotaryVaule";RotaryValue
Time$=Str$(Hours)+":"+Str$(Minutes)+":00"
    SetMeters
   EndIf
Loop

Date$="01-01-2014"

GoSub SetTime
ButtonPress=0
 Do While Pin(Button)=0 ' Ensure Button is released
 Loop
Return


LedBrightness:
Max=100
RotaryValue=Brightness
Do While Pin(Button)=1
  If Brightness <> RotaryValue Then
    Brightness=RotaryValue
Print "BrightNess ";Brightness
    SetBrightness
    EndIf
Loop
GoSub WriteSettings
ButtonPress=0
 Do While Pin(Button)=0 ' Ensure Button is released
 Loop
Return


Sub RotaryInterrupt
 If Pin(RotaryB) = 1 Then
    RotaryValue = RotaryValue + 1
  Else
    RotaryValue = RotaryValue - 1
  EndIf
 If RotaryValue <= 0 Then RotaryValue = 0
 If RotaryValue >= Max Then RotaryValue = Max
End Sub



ReadTime:
' I2C RTC based On DS1307 Secs,Mins,Hours,Day,Date,Month,Year,Control
i2caddr = &h68 ' DS1307 I2C address
I2C open 100,100 ' Enable I2C
I2C write I2caddr, 0, 1, 0
I2C Read i2caddr, 0, 3, RTCbuff(0)
Pause 20


BCDTEMP = RTCBuff(0)
BCDtoDec BCDTEMP
sec$ = Str$(decimal)

BCDTEMP = RTCBuff(1)
BCDtoDec BCDTEMP
min$ = Str$(decimal)

BCDTEMP = RTCBuff(2)
BCDtoDec BCDTEMP
hours$ = Str$(decimal)

t$ = hours$+":"+min$+":"+sec$
Time$ = T$
Print "Time has been set from the RTC to ";Time$

SetTick 3600000, ReadTime, 1 'Read Time once at 24 Hours

IReturn

'Convert to Decimal
Sub BCDtoDec (BCDTEMP)
Decimal = Fix(BCDTemp / 16) * 10
Decimal = Decimal + (BCDTEMP And &hF)
End Sub


SetTime:
' Get time from time$ and date$
tempdec = Val(Left$(Time$, 2))
BCDtoHex TempDec
hours = hex

tempdec = Val(Mid$(Time$, 4, 2))
BCDtoHex TempDec
minutes = hex

tempdec = Val(Right$(Time$, 2))
BCDtoHex TempDec
seconds = hex

rtcctrl = &h10
rtcwday= &h1

' Write Time to RTC
i2caddr = &h68 ' DS1307 I2C address
I2C Open 100,100 ' Enable I2C

I2C Write i2caddr, 0, 9, &h0, seconds, minutes, hours, 1, 1, 1, 14, &H10
I2C Close

Print "0=ok 1=nack 2=timeout"; MM.I2C
Print "RTC has been set to ";Time$
Return

' Convert to Hex
Sub BCDtoHex TempDec
hex = Fix(tempdec / 10) * 16
hex = hex Or ((tempdec / 10) - (Fix(tempdec / 10))) * 10
Return

ReadSettings:
i2caddr = &H50 ' 24c32 address
  I2C Open 100,100
   I2C Write i2caddr, 0,2,0,0  '24C32 Start Location
  Pause 20
   I2C Read i2caddr, 0,1,Brightness
 I2C Close
Return

WriteSettings:
i2caddr = &H50 ' 24c32 address
 I2C Open 100,100
  I2C Write i2caddr, 0,3,0,0,Brightness '24C32 Start Location
 I2C Close
Return