import urequests as requests
import json
ssid = "bera1"
password = "*************"
server_url = "m/v1/engines/davinci-codex/completions"

api_key = "****************************************"
prompt = "arduino code for blink "

def connect_to_wifi():
    import network
    wlan = network.WLAN(network.STA_IF)
    wlan.active(True)
    wlan.connect(ssid, password)
    while not wlan.isconnected():
        pass
    print("Connected to WiFi")

def make_api_request():
    url = "https://api.openai.com/v1/chat/completions"
    headers = {
        "Content-Type": "application/json",
        "Authorization": "Bearer "+ api_key
    }
    payload = {
        "model": "gpt-3.5-turbo", "temperature": 0.8,"max_tokens": 2000,
        "messages": [{"role": "user", "content": prompt}]
   
    }
    #response = requests.post(url, headers=headers, data=json.dumps(data))
    response = requests.post(url, json=payload, headers=headers)
    return response.json()
    # return response.json[content]   #()

def main():
    connect_to_wifi()
    response = make_api_request()
    response_json = response
    choices = response_json["choices"]
    assistant_reply = choices[0]["message"]["content"]
    print("Response:")
    print(assistant_reply)
    

if __name__ == "__main__":
    main()
