'14M2 Battery Lifesaver / Load Controller - 0723
'[1] the circuit monitors battery voltage and power cycles two loads at settable low and high voltage thresholds
'[2] the ciruit has an input from an external timer that power cycles loads at a user defined interval
'[3] the circuit has RB1 and RB2 inputs that allows the two loads to be individually power cycled
'[4] the circuit monitors a watchdog input and power cycles the loads  when there is no watchdog input in a timeout period
'[5] the circuit utilises the picaxe SLEEP mode and a isolatable ADC input resistive divider to conserve power
'[6] the circuit asserts a WARNING output signal ahead of load OFF event due to low battery

#picaxe 14M2
#no_data
#terminal 4800	'automatically open picaxe TERMINAL @ 4800 baud following download (for debug sertxd strings)

setfreq m4		'must be 4 MHZ for lowest power and various correct program timings

dirsC=%00000000	'all inputs
dirsB=%11011111	'b.5 adc input, rest as outputs

pullup %0001111100000000	'c.7....c.0,b.7....b.0

symbol DIVIDERpin = pinb.1	'resistive DIVIDER control pin
symbol WARNINGpin = pinb.2	'arduino OFF WARNING pin
symbol LOAD1pin	= pinb.3	'LOAD1 ON/OFF MOSFET control pin
symbol LOAD2pin	= pinb.4	'LOAD2 ON/OFF MOSFET control pin

symbol EXT_TIMERpin	= pinc.0	'external timer input pin
symbol WATCHDOGpin	= pinc.3	'watchdog input pin from arduino
symbol RB1pin 		= pinc.4	'LOAD1 reboot input
symbol RB2pin 		= pinc.2	'LOAD2 reboot input

symbol flags		=b0
symbol ADC_state		=bit0	'LOAD1 & LOAD2 status due to ADC conditions (0=OFF, 1=ON)
symbol flag_RB1		=bit1	'REBOOT1 do once flag
symbol flag_RB2		=bit2	'REBOOT2 do once flag
symbol flag_TMR		=bit3	'REBOOT EXT TIMER do once flag
symbol WDOG_enable	=bit4	'0=watchdog functionality diabled, 1=enabled

symbol ADC_value = w2		'readADC10 10bit value	'0=power OFF 1=power ON

symbol WDOG_counter = w3	'elapsed seconds (uses picaxe TIME function) 

symbol OUT_mask = b8		'LOAD1 & LOAD2 output pin control map

symbol TEMP_word=w12		'temporary word register
symbol TEMP_byte=b27		'temporary byte register

'------------------------------------------------------------------------------------------------------------
'CONFIG DATA

WDOG_enable=1			'0=watchdog disabled, 1=enabled

symbol sleep_interval = 20	'adc sampling rate (secs) with adc_state=0
symbol adc_interval = 5		'adc sampling rate (secs) with adc_state=1

symbol wdog_timeout = 28800	'8hrs = 28800 secs (note max value = 65535 = 18H:12M:15S)



symbol ADC_cutoff = 806		'11.9 volts >> ADC value = (11.9/15.10*1023) = 806
symbol ADC_cutin  = 881		'13.0 volts >> ADC value = (13.0/15.10*1023) = 881
					'adc 1023 = 15.10V (on test value) (using 27K/10K resistive divider, bench PSU and DVM)
					
symbol ADC_OFFdly		= 10000	'allows sufficient time for upstream devices to action anything prior to load isolation
						' eg. send a WARNING email
symbol LOAD1_OFFtime	= 5000	'time that LOAD1 is turned OFF
symbol LOAD2_OFFtime	= 5000	'time that LOAD2 is turned OFF
symbol TIMER_OFFtime	= 5000	'time that LOAD1 AND/OR LOAD2 is turned OFF
symbol WDOG_OFFtime	= 5000	'time that LOAD1 AND/OR LOAD2 is turned OFF

symbol RB1_mask		= %00000001	'LOAD1 and LOAD2 ON/OFF mask values
symbol RB2_mask		= %00000010
symbol TIMER_mask		= %00000011
symbol ADC_mask		= %00000011
symbol WDOG_mask		= %00000011
'----------------------------------------------------------------------------------------------------------

ADCCONFIG %011		'set FVR as ADC V+ref, 0V as ADC V-ref (FVR= internal Fixed Voltage Reference)

'----------
'INITIALISE
'----------					
	gosub getADC
	OUT_mask = %00000011
	if ADC_value > ADC_cutoff then :ADC_state=1 :gosub LOAD_ON else :ADC_state=0 :gosub LOAD_OFF :endif

	enableTIME	'enable picaxe 14M2 internal timer (used to control 'awake' adc sampling period
	
'------------
'MAIN PROGRAM
'------------

main:

if ADC_state=0 then :goto SLEEP_OP :endif	'jump to SLEEP operation

AWAKE_OP:

	if TIME>=adc_interval then :inc wdog_counter :gosub ADC_cntrl :TIME=0 :endif	'see picaxe enableTIME function

	if WDOG_enable=1 then :gosub WATCHDOG_cntrl :endif
	
	if RB1pin=0 then :gosub RB1_cntrl	else :flag_RB1 = 0 :endif
	if RB2pin=0 then :gosub RB2_cntrl	else :flag_RB2 = 0 :endif
	if EXT_TIMERpin=0 then :gosub EXT_TIMER_cntrl else :flag_TMR  = 0 :endif
		
	goto main	'loop back to main
	
SLEEP_OP:

	wdog_counter = 0
	time=0
	
	gosub picaxe_SNOOZE	'put 14M2 to SLEEP
	gosub ADC_cntrl
	
goto main


'======================
'----------------------
'SUBROUTINES START HERE
'----------------------
'======================

ADC_cntrl:

	gosub getADC	'get ADC value of the BATTERY voltage
	
	OUT_mask = ADC_mask

	if ADC_value <= ADC_cutoff AND ADC_state =1 then :sertxd ("ADC-OFF",10,13):gosub WARNING :gosub LOAD_OFF :ADC_state=0 :endif

	if ADC_value >= ADC_cutin  AND ADC_state =0 then :sertxd ("ADC-ON",10,13) :gosub LOAD_ON  :ADC_state =1 :endif

return

WATCHDOG_cntrl:

if WATCHDOGpin=0 then  :wdog_counter=0 :return :endif

	w12 = wdog_timeout / adc_interval
	if wdog_counter  < w12 then :return :endif

	sertxd ("REBOOT-WDOG",10,13)
	OUT_mask = WDOG_mask
	gosub LOAD_OFF
	pause WDOG_OFFtime
	gosub LOAD_ON
	wdog_counter=0
	
return

EXT_TIMER_cntrl:

	if flag_TMR = 1 then :return :endif	'do once
	
	flag_TMR = 1	'set do once flag (this flag only resets when the TIMER input pin normalises)
	
	OUT_mask = TIMER_mask
	sertxd ("REBOOT-EXT_TIMER",10,13)
	gosub LOAD_OFF
	pause TIMER_OFFtime
 	gosub LOAD_ON
	wdog_counter=0
		
return	

RB1_cntrl:

	if flag_RB1 = 1 then :return :endif	'do once
	
	flag_RB1 = 1

	sertxd ("REBOOT-RB1",10,13)
	OUT_mask= RB1_mask
	gosub LOAD_OFF
	pause LOAD1_OFFtime
	gosub LOAD_ON
	wdog_counter=0
	
return

RB2_cntrl:

	if flag_RB2 = 1 then :return :endif	'do once
	
	flag_RB2 = 1
		
	sertxd ("REBOOT-RB2",10,13)
	OUT_mask = RB2_mask
	gosub LOAD_OFF
	pause LOAD2_OFFtime
	gosub LOAD_ON
	wdog_counter=0

return

getADC:
	
	DIVIDERpin = 1	'enable voltage divider

		FVRSETUP FVR4096	'set ADC internal reference voltage (FVR) to 4.096V
		readadc10 b.5, ADC_value
		sertxd ("ADC= ",#ADC_value," wdog_count= ",#wdog_counter,10,13)
		
	if ADC_state=0 then :DIVIDERpin = 0	:endif	'disable voltage divider if adc state is OFF
	
return

WARNING:

	sertxd ("delay ",#ADC_OFFdly,10,13)
	WARNINGpin = 1 	'send signal to arduino indicating power off is imminent
	pause ADC_OFFdly	'enough time to allow arduino to send cutoff WARNING message
	WARNINGpin = 0	
	
return

LOAD_OFF:

	if OUT_mask = %00000011 then :LOAD1pin = 0 :LOAD2pin = 0 :sertxd ("OFF-LOAD1",10,13,"OFF-LOAD2",10,13) :endif
	if OUT_mask = %00000010 then :LOAD2pin = 0 :sertxd ("OFF-LOAD2",10,13) :endif
	if OUT_mask = %00000001 then :LOAD1pin = 0 :sertxd ("OFF-LOAD1",10,13) :endif
	
return

LOAD_ON:

	if OUT_mask = %00000011 then :LOAD1pin = 1 :LOAD2pin = 1 :sertxd ("ON-LOAD1",10,13,"ON-LOAD2",10,13) :endif
	if OUT_mask = %00000010 then :LOAD2pin = 1 :sertxd ("ON-LOAD2",10,13) :endif
	if OUT_mask = %00000001 then :LOAD1pin = 1 :sertxd ("ON-LOAD1",10,13) :endif
		
return

picaxe_SNOOZE:

	b27=sleep_interval/2	'one SLEEP interval approx = 2 secs
	disablebod			'disable picaxe blackout detector
	sleep b27			'enter SLEEP mode (~ = n x 2.3secs)
	enablebod			'enable picaxe blackout detector

return
