; measVbat.INC: useful macros and subroutines

;----------------------------------------------------------------------------
; activate internal fixed voltage reference FVR to 2.048V
;----------------------------------------------------------------------------
enableFVR2048
	movlw	b'10000010'		; <7>=1: FVR on, <10>=10: 2.048V reference  
	;iorwf FVRCON, F
	movwf FVRCON
;wait until reference stable
	btfss FVRCON, FVRRDY	; FVRRDY=1 => reference is ready
	goto $-1
	return

;----------------------------------------------------------------------------
meas8bit
	movwf	ADCON
	bsf		ADCON, ADON	; switch on ADC module

	DELAY101us_4MHz		; wait at least 32 us before a new conversion
		
	bsf		ADCON, GO_NOT_DONE	; initiate one A/D conversion
	btfsc	ADCON, GO_NOT_DONE	; A/D conversion complete ?
	goto	$-1					; no

	bcf		ADCON, ADON	; ADC off => to lower power consumption
	retlw	0

;=============================================
measVbat
	call	enableFVR2048

;meas FVR
	movlw	b'10011100'		; Fosc/4, internal 2.048V FVR, ADC off
	CALL	meas8bit
	movf	ADRES, W
	movwf	meas2048V

	SIregEQval8b	meas2048V, .0, cantDivideByZero

;Vbat = NUMVBAT / meas2048V => Vbat = 52275 / meas2048V
	movlw	HIGH NUMVBAT
	movwf	tmp2
	movlw	LOW NUMVBAT
	movwf	tmp1

;(tmp2,tmp1) / meas2048V => quotient in (tmp2,tmp1)
; ex: result (tmp2,tmp1) = 361 => 3.61V

	DIV16_8   tmp2, tmp1, meas2048V 
	MOVFF	tmp1, Vbat		; store (tmp2,tmp1) in Vbat:2
	MOVFF	tmp2, Vbat+1
	goto	ending

cantDivideByZero
	clrf	tmp1
	clrf	tmp2
ending
	bcf		FVRCON, FVREN	; disable FVR, to lower power consumption
	return
