; Delays4MHz.INC: delay routines useful at Fosc=4MHz.
;
;-----------------------------------------------------------------------------
; delay 1 second (Fosc = 4 MHz)
;-----------------------------------------------------------------------------
DELAY1S_4MHz	 macro
	clrf	cpt1
	call	DelayXms_4MHz	; Delai 256ms
	call	DelayXms_4MHz
	call	DelayXms_4MHz
	call	DelayXms_4MHz
	endm
;-----------------------------------------------------------------------------
; delay 250 s (Fosc = 4 MHz)
;-----------------------------------------------------------------------------
DELAY250us_4MHz	 macro
	MOVLW	.62			; 1s
	ADDLW	0FFh		; W--
	BTFSS	STATUS, Z	; bit Z=1 (i.e. W = 0 ?)
	GOTO	$-2			; no, then loop = 4 * 62 = 248 us
	NOP					; 1s
	endm
;-----------------------------------------------------------------------------
; delay 129 s (Fosc = 4 MHz)
;-----------------------------------------------------------------------------
DELAY129us_4MHz	 macro
	MOVLW	.32			; 1s
	ADDLW	0FFh		; W--
	BTFSS	STATUS, Z	; bit Z=1 (i.e. W = 0 ?)
	GOTO	$-2			; no, then loop = 4 * 32 = 128 us
	endm
;-----------------------------------------------------------------------------
; delay 101 s (Fosc = 4 MHz)
;-----------------------------------------------------------------------------
DELAY101us_4MHz	 macro
	MOVLW	.25			; 1s
	ADDLW	0FFh		; W--
	BTFSS	STATUS, Z	; bit Z=1 (i.e. W = 0 ?)
	GOTO	$-2			; no, then loop = 4 * 25 = 100 us
	endm

;/////////////////////////////////////////////////////////////////////////////

;-----------------------------------------------------------------------------
; Delay X ms, where X = 1,2,...,255 (and 256 ms, if X=0)
;-----------------------------------------------------------------------------
DelayXms_4MHz
	MOVWF	cpt1			; cpt1 = X

delay1ms_4MHz
	MOVLW	.250
	ADDLW	0FFh		; W--
	BTFSS	STATUS, Z	; bit Z=1 (i.e. W = 0 ?)
	GOTO	$-2			; no, then loop = 4 * 250 = 1000 us

	DECFSZ	cpt1, F
	GOTO	delay1ms_4MHz
	RETURN
