; MUL8x8bn.INC: (cpt1) mul8x8 (cpt2) => (tmp1,tmp2), see AN526
;
;------------------------------------------------------------------------------
; declare in the main file:
;------------------------------------------------------------------------------
;mul8x8
;	mulcnd:1	; cpt1		; 8-bit value for multiplicand
;	mulplr:1	; cpt2		; 8-bit value for multiplier
;	result:2	; tmp1,tmp2	; 16-bit value for result
;	count:1		; cpt3		; 8-bit value, loop counter
;------------------------------------------------------------------------------
;
MUL8_k8	macro		mul1, mul2
	MOVF	mul1, W
	MOVWF	cpt1		; multiplicande
	
	MOVLW	mul2
	MOVWF	cpt2		; multiplicateur

	call	mul8x8		; mul1 x mul2 => result (16-bit) in tmp1,tmp2
	endm

;------------------------------------------------------------------------------
mul8x8
	clrf	tmp1		; low byte
	clrf	tmp2	; high byte

	movlw	8		; initialize count
	movwf	cpt3
	movf	cpt1, w
	bcf	STATUS, C	; clear CARRY bit
loop8x8
	rrf	cpt2, f
	btfsc	STATUS, C
	addwf	tmp2, f
	rrf	tmp2, f
	rrf	tmp1, f
	decfsz	cpt3, f
	goto	loop8x8
	retlw	0
