#include <ESP8266WiFi.h>
#include <WiFiUdp.h>

//#define AFFICHAGE 1  //uncomment this line to enable all the Serial.print functions

#ifndef STASSID
#define STASSID "put here the name given to your router"        //<------- your SSID 
#define STAPSK "put here the password to access your router"    //<------- your PASSWD
#endif

//structure to store connection information
struct
{ uint32_t crc32 ;   
  uint8_t channel ;  
  uint8_t ap_mac[6] ;
  uint8_t padding ;  
} rtcData ;

const char *WLAN_SSID = STASSID ;
const char *WLAN_PASSWD = STAPSK ;

const int udpPort = 6010 ;
long SLEEPTIME = 50e6;  //<------- 50s, increase this, to keep battery life longer !
int iPaquet = 0 ;

WiFiUDP udp;

//-----------------------------------------------------------------------------
void afficher(auto str)
{
#ifdef AFFICHAGE
  Serial.print(str);
#endif
}
//-----------------------------------------------------------------------------
void afficherln(auto str)
{
#ifdef AFFICHAGE
  Serial.println(str);
#endif
}
//-----------------------------------------------------------------------------
void setup()
{
  Serial.begin(57600) ; Serial.setTimeout(18000) ;  // 18 seconds

  afficherln("") ; afficherln("WiFi waiting serial input") ;

  //we disable WiFi, coming from DeepSleep, as we do not need it right away
  WiFi.mode(WIFI_OFF) ; WiFi.forceSleepBegin() ; delay(1) ;
  iPaquet = 0;
}
//-----------------------------------------------------------------------------
void loop()
{
    // If data is available on the RX pin, read and send it to the Telnet clients
  if (Serial.available() > 0)
  {
    String paquet = Serial.readStringUntil('\n') + '\n' ;
    if (iPaquet <= 1) iPaquet++ ;  // iPaquet = 1, after receiving 1st CRLF: useless !
    if (iPaquet == 2)  // this 2nd paquet must be sent !
    {   //Try to read WiFi settings from RTC memory
      bool rtcValid = false;
      if (ESP.rtcUserMemoryRead(0, (uint32_t *)&rtcData, sizeof(rtcData)))
      { uint32_t crc = calculateCRC32(((uint8_t *)&rtcData) + 4, sizeof(rtcData) - 4);
        if (crc == rtcData.crc32) rtcValid = true;
      }

      WiFi.forceSleepWake() ; delay(1) ;  //Switch Radio back ON

      WiFi.persistent(false) ;

      WiFi.mode(WIFI_STA) ; //WiFi connection as STATION

      if (rtcValid)
      { WiFi.begin(WLAN_SSID, WLAN_PASSWD, rtcData.channel, rtcData.ap_mac, true) ;
      } else WiFi.begin(WLAN_SSID, WLAN_PASSWD) ;

      //------now restart connection
      int retries = 0, wifiStatus = WiFi.status() ;

      afficherln("") ; afficher("Trying QUICK connect:") ;
      while (wifiStatus != WL_CONNECTED)
      { retries++;
        if (retries % 10 == 0) afficher(".");
        if (retries == 100)
        {  //Quick connect failure, reset WiFi and try regular connect
          afficherln("") ; afficherln("QUICK connect FAILED.") ;
          WiFi.disconnect() ; delay(10) ;

          WiFi.forceSleepBegin() ; delay(10) ;
          WiFi.forceSleepWake() ;delay(10) ;

          afficher("Trying REGULAR connect:") ;
          WiFi.begin(WLAN_SSID, WLAN_PASSWD) ;
        }
        if (retries == 600)  //Abort if > 30s, then go back to deepsleep
        { WiFi.disconnect(true) ; delay(1) ;
          WiFi.mode(WIFI_OFF) ;

          afficherln("") ; afficherln("REGULAR connect FAILED.") ;
          afficherln("==== ENTER DEEP SLEEP FOR 50s ====") ;
          ESP.deepSleep(SLEEPTIME, WAKE_RF_DISABLED) ;
          return ;
        }
        delay(50) ;
        wifiStatus = WiFi.status() ;
      }

      afficherln("") ; afficherln("WiFi connected") ;
      afficher("IP address: ") ; afficherln(WiFi.localIP()) ;

      if (!rtcValid)  //Write current connection info back to RTC
      { rtcData.channel = WiFi.channel() ;
        memcpy(rtcData.ap_mac, WiFi.BSSID(), 6) ;  //Copy 6 bytes of BSSID (AP's MAC address)
        rtcData.crc32 = calculateCRC32(((uint8_t *)&rtcData) + 4, sizeof(rtcData) - 4) ;
        ESP.rtcUserMemoryWrite(0, (uint32_t *)&rtcData, sizeof(rtcData)) ;

        afficherln("rtcData written into RTC flash ROM.") ;
      }

      //Now send the data thru UDP
      udp.begin(udpPort) ;
      afficher("UDP broadcast on port ") ; afficherln(udpPort) ;

      //Send a UDP broadcast message
      udp.beginPacket("255.255.255.255", udpPort) ;  // Broadcast to ALL
      udp.print(paquet) ; 
      udp.endPacket() ; delay(1);

      WiFi.disconnect(true) ; delay(1) ;
      afficherln("going DeepSleep during 50s") ;
      // WAKE_RF_DISABLED to keep the WiFi radio disabled when we wake up
      ESP.deepSleep(SLEEPTIME, WAKE_RF_DISABLED) ;
    }
  }
}
//-----------------------------------------------------------------------------
// the CRC routine
uint32_t calculateCRC32(const uint8_t *data, size_t length)
{
  uint32_t crc = 0xffffffff;
  while (length--)
  { uint8_t c = *data++;
    for (uint32_t i = 0x80; i > 0; i >>= 1)
    { bool bit = crc & 0x80000000;
      if (c & i) bit = !bit;
      crc <<= 1;
      if (bit) crc ^= 0x04c11db7;
    }
  }
  return crc;
}
