; TX57600.INC: macro TRANSMIT and routines tx_rs232 + RX_rs232 @ 57600-8N1
;
;-----------------------------------------------------------------------------
; splash a message (in page 0 only) to PC
;-----------------------------------------------------------------------------
SPLASH232	macro   msg		; SPLASH msg thru RS232
	movlw  msg
	call   write_RS232
	endm

;------------------------------------------------------------------------
; transmit one digit to PC
;------------------------------------------------------------------------
TRANSMIT  macro  dgtDSx
	MOVF	dgtDSx, w
	ADDLW	.48			; translate to ASCII code
	CALL	tx_rs232	; emit 1 byte to PC/RS232
	endm
;------------------------------------------------------------------------
; transmit 1 blank character ' ' to PC
;------------------------------------------------------------------------
TRANSMIT1BLANK  macro
	MOVLW	' '
	CALL	tx_rs232
	endm
;------------------------------------------------------------------------
; transmit 1 dot character '.' to PC
;------------------------------------------------------------------------
TRANSMITDOT  macro
	MOVLW	'.'
	CALL	tx_rs232
	endm
;
;////////////////////////////////////////////////////////////////////////
;
;------------------------------------------------------------------------
; Carriadge Return, Line Feed
;------------------------------------------------------------------------
crlf
	MOVLW	.13			; <CR>
	CALL	tx_rs232
	MOVLW	.10			; <LF>
	CALL	tx_rs232
	RETURN
;------------------------------------------------------------------------
; to send 1 byte @ 57600 bauds (1bit=17.36us)
; on n'utilise pas le circuit MAX232 ... => low cost + low power
;------------------------------------------------------------------------
tx_rs232
	nop
	MOVWF	buffTX		; store w into buffTX

	BCF	TX232		; (with MAX232) TX = 0 (start bit)
	NOP
	NOP
 call rtn 
 call rtn 
 nop

	MOVLW	08h
	MOVWF	cpt1		; Init counter (nbr de bit)
tx1
	BTFSS	buffTX, 0	;Test if bit to emit = 1
	GOTO	tx2
	NOP
	BSF	TX232		;(with MAX232) no => emit bit = 1
    NOP
 call rtn 
 call rtn 
 nop

	RRF	buffTX, f	;next bit
	DECFSZ	cpt1, f		;Decrement counter cpt1 (nbr de bit)
	GOTO 	tx1
	GOTO	tx3
tx2
	BCF	TX232		;(with MAX232) no => emit bit = 0
	NOP
 call rtn 
 call rtn 
 nop

	RRF	buffTX, f	;next bit
	DECFSZ	cpt1, f		;Decrement counter (nbr de bit)
	GOTO 	tx1
	NOP
	NOP
tx3
	NOP
	NOP
	BSF	TX232		; (with MAX232) stop bit = 1 (idle, waiting next flow)
 call rtn 
 call rtn 
 nop

rtn	
	RETURN

;///////////////////////////////////////////////////////////////////////////
;-----------------------------------------------------------------------------
; pclsub used for indirect addressing 
;-----------------------------------------------------------------------------
pclsub:
	;;;;;;;;;;INCF	scratch, F	; advance table pointer
	MOVF	scratch, W	; move table pointer to W
	MOVWF	PCL			; jump to address pointed by PCLATH, W

;-----------------------------------------------------------------------------
; read a table (in page 0 only): 
; MOVLW lut, then CALL write_RS232 (to send a string to RS232)
;-----------------------------------------------------------------------------
write_RS232:
	MOVWF	scratch		; FSR = string address
	CALL	crlf		;<CR><LF>

GoWrite:
	CALL	pclsub		; advance pointer and read pointed byte
	ADDLW	0h			; if byte = ASCII zero, then Z = 1
	BTFSC	STATUS, Z	; skip if not
	RETURN				; current character is null: end of string
	CALL	tx_rs232

	INCF	scratch, F	; advance table pointer
	GOTO	GoWrite		; loop
