; measMCP9700.INC: useful macros and subroutines

;============================================================================
measTemp
	movlw	b'10000000'		; <7:5>=100:Fosc/4, <4:2>=000:AN0, ADC off
	CALL	meas8bit
	movf	ADRES, W
	movwf	measTempCN

;Vbat(16-bit) * measTempCN(8-bit) -> result (16-bit) in (tmp1, tmp2)
	SIregNUL	measTempCN, TempOutOfRangeLow
	A16x8	Vbat+1, Vbat, measTempCN

;(tmp2,tmp1) / value255 => quotient in (tmp2,tmp1)
; ex: result (tmp2,tmp1) = 76 => 26C + 50

	MOVLF	.255, value255
	DIV16_8   tmp2, tmp1, value255 

; here, limited to 0C .... +99C (precision = 1.5C)
	SIregLTval8b	tmp1, .50, TempOutOfRangeLow		; if T < 0C
	SIregGEval8b	tmp1, .150, TempOutOfRangeHigh		; if T >= 100C

	movlw	.50
	subwf	tmp1, f			; tmp1 <- tmp1 - 50

	clrf	tmp2
	call	SP_DIGBYTE	; 16bit (tmp1, tmp2) -> 3 dgts (hunds,tens,units)
	goto ending2

TempOutOfRangeLow
	;MOVLF	.20, tens		; Table[19] = symbol '-'
	MOVLF	.0, tens
	MOVLF	.0, units
	goto	ending2
	
TempOutOfRangeHigh
	;MOVLF	.16, tens		; display "UUC" means >= .100
	MOVLF	.9, tens
	MOVLF	.9, units

ending2
	return
