; DIV16.INC: (Dividend:2) div16 (Divisor:2) => (Quotient:2) and Dividend
;
;------------------------------------------------------------------------------
;
DIV16_8	  macro		dvdHI, dvdLO, dvs
	MOVF	dvdLO, W
	MOVWF	Dividend		;Dividend
	MOVF	dvdHI, W
	MOVWF	Dividend + 1	;Dividend + 1
	
	MOVF	dvs, W
	MOVWF	Divisor			;Divisor
	clrf	Divisor + 1		;Divisor + 1

	CALL	div16		;(Dividend:2) / (Divisor:2) => (Quotient:2,remainder)
	endm

;------------------------------------------------------------------------------
div16
	clrf	tmp1
	clrf	tmp2

	movlw	1		;  Initialize Counter
	movwf	cpt1
	clrf	cpt2

StartLoop			; Find How Large "Divisor" can be 
	btfsc	Divisor + 1, 7	; If at the "top", then do 
	goto	Loopdiv16	; the Division

	bcf	STATUS, C	; Shift Counter and Divisor Up
	rlf	cpt1, f
	rlf	cpt2, f
  
	rlf	Divisor, f
	rlf	Divisor + 1, f
	goto	StartLoop

Loopdiv16			; Now, Take Away "Divisor" from "Dividend"
	movf	Divisor, w	; If Dividend => Divisor then
	subwf	Dividend, w	; Take Away
	movwf	cpt3
	movlw	0
	btfss	STATUS, C
	movlw	1
	addwf	Divisor + 1, w
	subwf	Dividend + 1, w
	btfss	STATUS, C
	goto	Skipdiv16	; Divisor < Dividend

	movwf	Dividend + 1	; Save the New Dividend
	movf	cpt3, w
	movwf	Dividend

	movf	cpt1, w	; Add Counter to the Quotient
	addwf	tmp1, f
	movf	cpt2, w
	addwf	tmp2, f	; No Opportunity for Carry

Skipdiv16			; Shift Divisor/Counter Down
	bcf	STATUS, C
	rrf	Divisor + 1, f
	rrf	Divisor, f

	rrf	cpt2, f	; If Carry Set after Counter
	rrf	cpt1, f	; Shift, Finished

	btfss	STATUS, C	; If Carry NOT Set, then 
	goto	Loopdiv16	; Process next Bit
	RETLW	0
