; MUL16x8v2.INC : 16bit by 8bit unsigned multiply
;------------------------------------------------------------------------------
; macro : A (16-bit) * K (8-bit) -> result (16-bit) in (tmp1, tmp2) 
;example: (meas10bHI1, meas10bLO1) * 5 -> (tmp1, tmp2)
;	  N * 5 <=> N + N + N + N + N
;------------------------------------------------------------------------------
A16xK8	macro	Ahigh, Alow, K8bit
	LOCAL	mul1

	CLRF	tmp1			; low byte
	CLRF	tmp2			; high byte

	MOVLW	K8bit
	MOVWF	cpt1
mul1
	MOVF	Alow, w
	ADDWF	tmp1, f			; tmp1 += Alow
	BTFSC	STATUS, C		; result <= 255 ?
	INCF	tmp2, f			; no, then add CARRY to HIBYTE, (is tmp2)
	MOVF	Ahigh, w
	ADDWF	tmp2, f			; tmp2 += Ahigh
	DECFSZ	cpt1, f
	GOTO	mul1
	endm

;------------------------------------------------------------------------------
; macro : A (16-bit) * B (8-bit) -> result (16-bit) in (tmp1, tmp2) 
;example: (meas10bHI1, meas10bLO1) * measTempCN -> (tmp1, tmp2)
;	  N * 5 <=> N + N + N + N + N
;------------------------------------------------------------------------------
A16x8	macro	Ahigh, Alow, B8bit
	LOCAL	mul2

	CLRF	tmp1			; low byte
	CLRF	tmp2			; high byte

	movf	B8bit, w
	MOVWF	cpt1
mul2
	MOVF	Alow, w
	ADDWF	tmp1, f			; tmp1 += Alow
	BTFSC	STATUS, C		; result <= 255 ?
	INCF	tmp2, f			; no, then add CARRY to HIBYTE, (is tmp2)
	MOVF	Ahigh, w
	ADDWF	tmp2, f			; tmp2 += Ahigh
	DECFSZ	cpt1, f
	GOTO	mul2
	endm
