; KL141us8.ASM: = UltraSonic Water Tank Gauge
; meas.ambiant temperature with MCP9700 thru AN0 + Vbat + Distance
; In brief : RA2 output high, for 10s => Trigger the HC-SR04   
; then wait for echo, thru RA3 input, timeout 1s, then RA1/TX @57600 (8N1) 

	List P = 10F322
#include <p10f322.inc> 			
			
	Errorlevel -302		; avoid warning #302: Register in operand not in bank0 
						; Ensure that bank bits are correct.
;    __config _FOSC_INTOSC & _MCLRE_OFF & _LVP_OFF & _WDTE_OFF & _BOREN_OFF
    __config _FOSC_INTOSC & _MCLRE_OFF & _LVP_OFF & _WDTE_ON & _BOREN_OFF
;The Watchdog Timer is typically used to recover from unexpected events.
;(default=2s)
;--------------------------- define hardware -----------------------------
;internal 4 MHz

#define	 US_TRIG	LATA, 2		; pin RA2 for trigger
#define	 US_ECHO	PORTA, 3	; pin RA3 for echo
#define	 TX232		LATA, 1		; RS232 link to PC @ 57600-8N1

;--------------------------- define constants ----------------------------

;OPTION_REG: p.103
#define	 OPTIONVAL	b'11000110'	; pullup OFF, <5>=0:RA2 I/O, TMR0 prescale=1:128

;----------
REF2048V	EQU	.205 	  ; internal band gap 2.048V

NUMVBAT	  EQU	.52275	; = REF2048V * 255 = 52275

;----------------------------- define variables ------------------------------

	CBLOCK	0x40	; SRAM = [0x40...[ = 64 bytes (PIC10F320/322)
;delay
	cpt1, cpt2, cpt3 ; counters
;bin2dec
	thous, hunds, tens, units 	; thous, hunds, tens, units digits
;measure
	Vbat:2					; ex: Vbat = 365 => 3.65 [V]
	meas2048V				; 8-bit meas. for internal ref. 2048V
	measTempCN				; 8-bit meas. for internal temp. indicator
;div16
	Dividend:2		; 16-bit value for Dividend, and will store remainder
	Divisor:2		; 16-bit value for Divisor
;rs232
	scratch
	buffTX
;others
	tmp1, tmp2
	value255
	valTMR0
	ENDC
;21 bytes used

;-----------------------------------------------------------------------------
; macro to put a literal value (constant) into a register
;-----------------------------------------------------------------------------
MOVLF	macro	literal, file	; literal -> file
	movlw	literal
	movwf	file
	endm
;-----------------------------------------------------------------------------
; macro to put value of register file1 into register file2
;-----------------------------------------------------------------------------
MOVFF	macro	file1, file2	; file1 -> file2
	movf	file1, W
	movwf	file2
	endm

;/////////////////////////////////////////////////////////////////////////////
;	MAIN PROGRAM
;/////////////////////////////////////////////////////////////////////////////
	ORG		0x00			; reset vector
	GOTO	Main
;/////////////////////////////////////////////////////////////////////////////

;-----------------------------------------------------------------------------
;---------- tables to be read with macro SPLASH232 + sbr write_RS232 ---------
;-----------------------------------------------------------------------------
Msg1
	DT	"KL141: U.S. range meter (2cm-550cm) - 2023", 0h;42 car + 1
Msg2
	DT	"Tmp  Vbat  Dcm", 0h 							;14 car + 1 ; cumul=58

;-------------------------------------------------------------------------

#include "IF8B16B3.INC"
#include "Delays4MHz.INC"
#include "MUL8x8bn.INC"
#include "BIN8DGT3.INC"
#include "HC-SR04.INC"
#include "div16.INC"
#include "measVbat.INC"
#include "MUL16x8v2.INC"
#include "measMCP9700.INC"
#include "TX57600.INC"

;/////////////////////////////////////////////////////////////////////////////
Main
;init PORTA
	MOVLF	b'00001001', TRISA	;all RAx outputs, but RA0 input
	MOVLF	b'00000010', PORTA	;all RAx LOW, but RA1/TX idle high
	MOVLF	b'00000010', LATA	;all Data Latch RAx LOW, but RA1/TX idle high
	MOVLF	b'00000001', ANSELA	; use RA0 as AN0 analog input
	MOVLF	b'00000000', WPUA	; all pull-up individually disabled

;DS41585A.PDF(p.28/210): The HFINTOSC consists of a primary & secondary clock.
;The secondary clock starts first with rapid start-up time, but low accuracy.
;The primary clock follows with slower start-up time and higher accuracy. 

;set freq. to 4 MHz, then wait until sec. clock ready & pri. clock stable
	movlw	b'01010000'		; OSCCON<6:4>=101 => 4 MHz
	movwf	OSCCON
	btfss	OSCCON, HFIOFR	; HFIOFR=1 => secondary clock is ready
	goto	$-1
	btfss	OSCCON, HFIOFS	; HFIOFS=1 => primary clock is stable
	goto	$-1

;init OPTION_REG & INTCON
	movlw	OPTIONVAL		; <7>=1: pullup OFF, <5>=0: RA2 I/O, ...
	movwf	OPTION_REG		; ... TMR0 prescale (1:128) => tick = 128 s

	SPLASH232	Msg1		; SPLASH Msg1 thru RS232
	SPLASH232	Msg2		; SPLASH Msg2 thru RS232

;///////////////////////////// INFINITE LOOP /////////////////////////////////
;/////////////////////////////////////////////////////////////////////////////
loop
	CALL	crlf		; Carriadge Return, Line Feed

;======Temperature======
	call	measTemp
	MOVFF	tens, thous
	MOVFF	units, hunds
	MOVLF	.19, tens	; Table[19] = symbol '' (degre)
	MOVLF	.12, units	; Table[12] = symbol 'C'
	clrwdt
 TRANSMIT thous
 TRANSMIT hunds
 TRANSMIT1BLANK
 TRANSMIT1BLANK
 TRANSMIT1BLANK
	DELAY1S_4MHz		; pause 1s @ 4MHz	
	sleep				; sleep clears WDT (waiting 2s for WDT timeout)

;=======Battery========
	call	measVbat	; ends with (tmp2,tmp1) = Vbat ( ex. 365 = 3.65 [V] )
	call	SP_DIGBYTE	; 16bit (tmp1, tmp2) -> 3 dgts (hunds,tens,units)
	clrwdt
 ;TRANSMIT tens
 TRANSMIT hunds
 TRANSMITDOT
 ;TRANSMIT units
 TRANSMIT tens
 TRANSMIT1BLANK
 TRANSMIT1BLANK
 TRANSMIT1BLANK
	DELAY1S_4MHz		; pause 1s @ 4MHz	
	sleep				; sleep clears WDT (waiting 2s for WDT timeout)

;======Distance=======
	;if (Vbat < 350=0x015E) then display "UbLO" instead of U.S. distance
	SIregLTval16b	Vbat+1, 0x01, Vbat, 0x5E, VbatLOW, VbatOK
VbatLOW
	;MOVLF	.16, thous		; Table[16] = symbol 'U'
	;MOVLF	.11, hunds		; Table[11] = symbol 'b'
	;MOVLF	.22, tens		; Table[22] = symbol 'L'
	;MOVLF	.0, units		; Table[0] = symbol '0'
	goto	DispTM
VbatOK
	call	Trigger
	call	Echo
	call	calcDist
DispTM
;	call	TM_Wr4dgts
	clrwdt
 TRANSMIT hunds
 TRANSMIT tens
 TRANSMIT units
 TRANSMIT1BLANK
	DELAY1S_4MHz		; pause 1s @ 4MHz	
	sleep				; sleep clears WDT (waiting 2s for WDT timeout)
	
	goto	loop		; infinite loop (waiting for an interrupt)

;-----------------------------------------------------------------------------
	END
