; HC-SR04.INC: useful macros and subroutines

;-------------------------------------------------------------------------
Trigger
	bsf		US_TRIG
	goto	$+1		; delay 2 s
	goto	$+1		; delay 2 s
	goto	$+1		; delay 2 s
	goto	$+1		; delay 2 s
	goto	$+1		; delay 2 s
	goto	$+1		; delay 2 s
;even at 12s, LED light pulse is still visible !!! 
	bcf		US_TRIG
    RETLW 0

;-------------------------------------------------------------------------
Echo
	clrf	TMR0
	clrf	valTMR0
waitRisingEcho
	SIregGEval8b	TMR0, .250, timeout
	btfss	US_ECHO			; waiting start of U.S. echo
	goto	waitRisingEcho

	clrf	TMR0
waitFallingEcho
	SIregGEval8b	TMR0, .250, timeout
	btfsc	US_ECHO			; waiting end of U.S. echo
	goto	waitFallingEcho
	
	movf	TMR0, w
	movwf	valTMR0
    RETLW 0
timeout
	MOVLF	.255, valTMR0	; valTMR0 = 255 means timeout.
    RETLW 0
;-------------------------------------------------------------------------
;344m/s @ 20C => 0.344 mm/s => dist.= 0.344 * 256 = 88 mm 
;=> rangeMin = 44 mm per TMR0 tick=256s (if TMR0 prescale = 1:256). 
;=> rangeMin = 22 mm per TMR0 tick=128s (if TMR0 prescale = 1:128). 
;   rangeMax = (TMR0=250) * 2.2 = 550 cm
calcDist
;if (valTMR0) == .255 then outofRange
	SIregEQval8b	valTMR0, .255, outofRange

; valTMR0 * 2 => result:2 in (tmp2,tmp1)
	MUL8_k8   valTMR0, .2

doCalc
	call	SP_DIGBYTE	; 16bit (tmp1, tmp2) -> 3 dgts (hunds,tens,units)
    RETLW 0

outofRange
	;MOVLF	.21, thous	; disp. ' ' for out of range
	;movwf	hunds		; disp. ' ' for out of range
	;movwf	tens		; disp. ' ' for out of range
	;MOVLF	.14, units	; disp. 'E' for out of range
    RETLW 0
