'This program enables a Maximite to control an
'Arduino keypad LCD shield
'I/O 13 <-> D4;I/O 14 <-> D5;I/O 15 <-> D6;I/O 16 <-> D7
'I/O 18 <-> RS;I/O 19 <-> EN;I/O 17 <-> RST;I/O 20 <-> BL
'I/O 10 <-> A0
'This program uses subroutines to print text at any position
'on a 2x16 LCD screen
'use printlcd (line number [1 or 2]),(place on line [0 to 15]),(text to print)

initLCD       'initialise LCD & put into 4 bit mode
SetPin 20,9:SetPin 10,1
'set pins: pin 17 interrupt;pin 20 open collector;pin 10 analog
Pin(20) = 1           'turn on back light
PrintLCD 1,0, "MaxiMite control"
PrintLCD 2,0, "of LCD shield"
Pause 1000
newkey = 1     'newkey contains key press number
'1 = no key;2 = select;3 = left;4 = down;5 = up;6 = right;7 = interrupt

loop1:
       oldkey = newkey       'update oldkey
       v = Pin(10)           'read & decode ADC pin 10
       If v > 2.76 Then newkey = 1
       If v > 1.96 And v <= 2.76 Then newkey = 2
       If v > 1.35 And v <= 1.96 Then newkey = 3
       If v > .77 And v <= 1.35 Then newkey = 4
       If v > .23 And v <= .77 Then newkey = 5
       If v <= .23 Then newkey = 6
       If newkey = oldkey Then GoTo loop1     'no change so go back
       clearlcd       'clear previous message
       On newkey GoSub none,select,left,down,up,right 'branch appropriately
       Pause 1000     'pause to read result
GoTo loop1

none:
       Printlcd 2,0, "no key pressed"
Return

select:
       Printlcd 1,0, "select pressed"
Return

left:
       Printlcd 1,0, "left pressed"
Return

down:
       Printlcd 1,0, "down pressed"
Return

up:
       Printlcd 1,0, "up pressed"
Return

right:
       Printlcd 1,0, "right pressed"
Return

int1:
       clearlcd
       Printlcd 1,0, "interrupt"
       Pause 1000
       clearlcd
       Do While Pin(17) = 0	'wait for key release
       Loop
       initlcd: GoSub none
IReturn

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Initialise the LCD
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub InitLCD
       Local i
       For i = 13 To 19 : SetPin i, 8 : Next i ' set all as digital output
       SetPin 17,7,int1                       'reset pin 17
       LCD 3,0:Pause 5                       ' reset
       LCD 3,0:Pause 5                        ' reset
       LCD 3,0:Pause 5                       ' reset
       LCD 2,0:Pause 5                        ' 4 bit mode
       LCD 2,0:Pause 2:LCD 12,0:Pause 2        ' 4 bits, 2 lines
       LCD 0,0:Pause 2:LCD 12,0:Pause 2       ' display on, no cursor
       LCD 0,0:Pause 2:LCD 6,0:Pause 2        ' increment on write
       LCD 0,0:Pause 2:LCD 1,0:Pause 2       ' clear the display
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'this subroutine can be called to clear display
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub clearlcd
       lcd 0,0:Pause 2:lcd 1,0
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Display a line on the LCD
' argument #1 is the line to be used (1 or 2)
' argument #2 is the position on line to start display (0-15)
' argument #3 is text to display
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub PrintLCD (lin, place, text$ )
       Local i,c,position
       'first send the cursor position (in two nibbles)
       position = &h80 + (lin - 1)*64 + place 'calculate position
       LCD Int(position/16),0 : LCD position,0
       ' then send the text character by character (two nibbles per character)
       For i = 1 To Len(text$)
              c = Asc(Mid$(text$,i,1))
              LCD Int(c/16),1 : LCD c,1
       Next i
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Send the lower 4 nibble to the LCD
' argument #1 is the nibble to send
' argument #2 is 1 for data, 0 for command
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub LCD(data1,rs )
       Pin(18) = rs          'set RS for text(1) or command(0)
       Port(13,4) = data1     'put data on output pins
       Pin(19) = 1 :Pause 1: Pin(19) = 0      'read data into LCD
End Sub

                                