REM Alphanumeric display demonstration board program
REM Copyright 1993 Silicon Chip Publications
REM All rights reserved
REM Written by Darren Yates B.Sc.

DECLARE SUB Command ()
DECLARE SUB text ()
DECLARE SUB initial ()
DECLARE SUB character ()
DECLARE SUB display ()
DECLARE SUB clean ()
DECLARE SUB cursor ()
DECLARE SUB custom ()
DECLARE SUB cursormove ()
DECLARE SUB lcdclean ()

COLOR 15, 1
CLS

initial
display
Command

SUB character

'This subroutine generates a custom character which is stored in the CG RAM
'section of the LCD memory block. Each display takes 8 addresses. There are
'64 addresses in total, producing 8 custom characters.

DIM block(8, 5)

CLS

LOCATE 20, 1: PRINT STRING$(80, 205)
LOCATE 21, 1: PRINT "Move the cursor using arrow keys and press <ENTER> to turn on/off the point"
LOCATE 22, 50: PRINT "Press ESC to end editing"
LOCATE 8, 50: PRINT CHR$(197)
LOCATE 8, 51: PRINT STRING$(6, 196)
FOR d = 1 TO 8
  LOCATE 8 + d, 50: PRINT CHR$(179)
NEXT d

LOCATE 9, 49: PRINT "1"
LOCATE 10, 49: PRINT "2"
LOCATE 11, 49: PRINT "3"
LOCATE 12, 49: PRINT "4"
LOCATE 13, 49: PRINT "5"
LOCATE 14, 49: PRINT "6"
LOCATE 15, 49: PRINT "7"
LOCATE 16, 49: PRINT "8"
LOCATE 7, 51: PRINT "12345"

y = 9: x = 51
LOCATE y, x: PRINT CHR$(4)

WHILE a$ <> CHR$(27)

a$ = INKEY$

SELECT CASE a$

  CASE CHR$(0) + "H"
    IF y > 9 THEN
      LOCATE y, x
      IF block(y - 8, x - 50) = 0 THEN
        PRINT CHR$(255);
      ELSE
        PRINT CHR$(219);
      END IF
      y = y - 1
      LOCATE y, x: PRINT CHR$(4);
    END IF

  CASE CHR$(0) + "P"
   
    IF y < 16 THEN
      LOCATE y, x
      IF block(y - 8, x - 50) = 0 THEN
        PRINT CHR$(255);
      ELSE
        PRINT CHR$(219);
      END IF
      y = y + 1
      LOCATE y, x: PRINT CHR$(4);
    END IF

  CASE CHR$(0) + "M"
   
    IF x < 55 THEN
      LOCATE y, x
      IF block(y - 8, x - 50) = 0 THEN
        PRINT CHR$(255);
      ELSE
        PRINT CHR$(219);
      END IF
      x = x + 1
      LOCATE y, x: PRINT CHR$(4);
    END IF

  CASE CHR$(0) + "K"
   
    IF x > 51 THEN
      LOCATE y, x
      IF block(y - 8, x - 50) = 0 THEN
        PRINT CHR$(255);
      ELSE
        PRINT CHR$(219);
      END IF
      x = x - 1
      LOCATE y, x: PRINT CHR$(4);
    END IF

  CASE CHR$(13)
   
    IF block(y - 8, x - 50) = 1 THEN
      block(y - 8, x - 50) = 0
    ELSE
      block(y - 8, x - 50) = 1
    END IF

END SELECT

WEND

num$ = ""

'now program the LCD display with the code from array BLOCK

WHILE (VAL(num$) < 1 OR VAL(num$) > 8) AND num$ <> CHR$(27)
  LOCATE 19, 1: PRINT "Enter into Character RAM number (1 to 8, ESC to quit to menu):"; : num$ = INPUT$(1)
WEND

IF VAL(num$) <> 0 THEN

  OUT 888, 16
  FOR d = 1 TO 10: NEXT d
  OUT 890, 7
  FOR d = 1 TO 10: NEXT d
  OUT 890, 3

  FOR f = 1 TO 8
    total = 0
    FOR v = 1 TO 5
      IF block(f, v) = 1 THEN total = total + 2 ^ (5 - v)
    NEXT v

    value = 63 + (8 * (VAL(num$) - 1)) + f


    OUT 888, value
    FOR d = 1 TO 10: NEXT d
    OUT 890, 7
    FOR d = 1 TO 20: NEXT d
    OUT 890, 3


    OUT 888, total
    FOR d = 1 TO 10: NEXT d
    OUT 890, 6
    FOR d = 1 TO 20: NEXT d
    OUT 890, 2
 
  NEXT f
 
  OUT 888, 7
  FOR d = 1 TO 10: NEXT d
  OUT 890, 7
  FOR d = 1 TO 10: NEXT d
  OUT 890, 3

  END IF

CLS

END SUB

SUB clean

'cleans the bottom half of the screen

LOCATE 18, 1: PRINT STRING$(80, 205);
FOR d = 19 TO 23
LOCATE d, 1: PRINT STRING$(80, 32)
NEXT d

END SUB

SUB Command

CLS

'The subroutine operates the main command menu

WHILE q$ <> "q"

clean

LOCATE 5, 2: PRINT "COMMANDS"
LOCATE 7, 2: PRINT "(1) Scroll the display right"
LOCATE 8, 2: PRINT "(2) Scroll the display left"
LOCATE 9, 2: PRINT "(3) Enter in text"
LOCATE 10, 2: PRINT "(4) Create a character"
LOCATE 11, 2: PRINT "(5) Turn cursor off/on"
LOCATE 12, 2: PRINT "(6) Enter in custom character"
LOCATE 13, 2: PRINT "(7) Move cursor"
LOCATE 14, 2: PRINT "(8) Clear display and cursor home"
LOCATE 16, 2: PRINT "(q) quit"


LOCATE 16, 12: PRINT "Command:      "; : LOCATE 16, 21: INPUT "", q$

SELECT CASE q$

  CASE "1"
    v$ = ""
    LOCATE 19, 1: PRINT "Press <s> to stop and return to menu."
   
    WHILE v$ <> "s"
      OUT 888, 28
      OUT 890, 7
      FOR d = 1 TO 500: NEXT d
      OUT 890, 3
      v$ = INKEY$
    WEND
    LOCATE 19, 1: PRINT STRING$(37, 32)

  CASE "2"
    v$ = ""
    LOCATE 19, 1: PRINT "Press <s> to stop and return to menu."
   
    WHILE v$ <> "s"
      OUT 888, 24
      OUT 890, 7
      FOR d = 1 TO 500: NEXT d
      OUT 890, 3
      v$ = INKEY$
    WEND
    LOCATE 19, 1: PRINT STRING$(37, 32)

  CASE "3"
    CLS
    clean
    display
    text

  CASE "4"
    character

  CASE "5"
    cursor

  CASE "6"
    clean
    custom

  CASE "7"
    cursormove

  CASE "8"
    lcdclean

END SELECT

WEND

CLS

END SUB

SUB cursor

'turns the cursor on or off - works on a toggle arrangement

 STATIC a

 SELECT CASE a

 CASE 0
    OUT 888, 12
    OUT 890, 7
    FOR d = 1 TO 10: NEXT d
    OUT 890, 3
    a = 1

 CASE 1
    OUT 888, 15
    OUT 890, 7
    FOR d = 1 TO 10: NEXT d
    OUT 890, 3
    a = 0

END SELECT

END SUB

SUB cursormove

'moves the cursor right or left

WHILE num$ <> "q"

  clean
  LOCATE 19, 1: PRINT "Move cursor (l)eft, (r)ight or (q)quit: "; : num$ = INPUT$(1)

SELECT CASE num$

CASE "l"
  OUT 888, 16
  OUT 890, 7
  FOR d = 1 TO 10: NEXT d
  OUT 890, 3

CASE "r"
  OUT 888, 20
  OUT 890, 7
  FOR d = 1 TO 10: NEXT d
  OUT 890, 3

END SELECT

WEND

END SUB

SUB custom

'displays a custom generated character on the display

clean
WHILE (VAL(num$) < 1 OR VAL(num$) > 8) AND num$ <> "q"
LOCATE 19, 1: PRINT "Which custom character to display (1 to 8, q to quit): "; : INPUT "", num$
WEND

number = VAL(num$) - 1
OUT 888, number
OUT 890, 6
FOR d = 1 TO 10: NEXT d
OUT 890, 2

END SUB

SUB display

LOCATE 9, 50: PRINT CHR$(201);
LOCATE 9, 51: PRINT STRING$(16, 205); : PRINT CHR$(187);
LOCATE 10, 50: PRINT CHR$(186);
LOCATE 10, 67: PRINT CHR$(186);
LOCATE 11, 50: PRINT CHR$(186);
LOCATE 11, 67: PRINT CHR$(186);
LOCATE 12, 50: PRINT CHR$(200); : PRINT STRING$(16, 205); : PRINT CHR$(188)


END SUB

SUB initial

' this sets up the main screen

LOCATE 1, 20: PRINT STRING$(40, 205)
LOCATE 2, 20: PRINT "Alphanumeric Display Board Demo Software"
LOCATE 3, 20: PRINT "Copyright 1993 Silicon Chip Publications"
LOCATE 4, 20: PRINT STRING$(40, 205)
VIEW PRINT 5 TO 24

'OUT 888, 1                    ) if you want the display to
'OUT 890, 7                    ) automatically clean itself
'FOR d = 1 TO 10: NEXT d       ) on start up, remove this comment
'OUT 890, 3                    ) and the remarks before these four lines

OUT 888, 15
OUT 890, 7
FOR s = 1 TO 10: NEXT s 'this delay is required so that the display has
                        'enough time to settle before entering in the data
OUT 890, 3

OUT 888, 56
OUT 890, 7
FOR s = 1 TO 10: NEXT s
OUT 890, 3

END SUB

SUB lcdclean

OUT 888, 1
FOR d = 1 TO 10: NEXT d
OUT 890, 7
FOR d = 1 TO 10: NEXT d
OUT 890, 3

OUT 888, 2
FOR d = 1 TO 10: NEXT d
OUT 890, 7
FOR d = 1 TO 10: NEXT d
OUT 890, 3

END SUB

SUB text

LOCATE 18, 1: PRINT STRING$(80, 205);
LOCATE 19, 1: PRINT "** no commas and 16 characters only displayed * press 'x' at line 1 to quit **"
LOCATE 20, 1: PRINT STRING$(80, 205);

LOCATE 22, 1: PRINT STRING$(75, 32)

'OUT 888, 1
'FOR d = 1 TO 10: NEXT d
'OUT 890, 7
'FOR s = 1 TO 10: NEXT s
'OUT 890, 3
'
'OUT 888, 2
'FOR d = 1 TO 10: NEXT d
'OUT 890, 7
'FOR s = 1 TO 10: NEXT s
'OUT 890, 3

OUT 888, 6
FOR d = 1 TO 10: NEXT d
OUT 890, 7
FOR d = 1 TO 10: NEXT d
OUT 890, 3

'OUT 888, 128
'FOR d = 1 TO 10: NEXT d
'OUT 890, 7
'FOR d = 1 TO 10: NEXT d
'OUT 890, 3


LOCATE 22, 1: PRINT "Enter in data for line 1: "; : INPUT "", a$


linenumber = 10
position = 50

FOR d = 1 TO LEN(a$)
value = ASC(MID$(a$, d, 1))
OUT 888, value:
IF d < 17 THEN LOCATE linenumber, position + d: PRINT CHR$(value);
FOR s = 1 TO 10: NEXT s
OUT 890, 6
FOR s = 1 TO 10: NEXT s
OUT 890, 2
FOR g = 1 TO 500: NEXT g
NEXT d
LOCATE 23, 1: PRINT STRING$(74, 32)
LOCATE 23, 1: PRINT "Enter in data for line 2: "; : INPUT "", b$

OUT 888, 169
OUT 890, 7
FOR s = 1 TO 10: NEXT s
OUT 890, 3

linenumber = 11
position = 50

FOR d = 1 TO LEN(b$)
value = ASC(MID$(b$, d, 1))
FOR s = 1 TO 10: NEXT s
OUT 888, value
IF d < 17 THEN LOCATE linenumber, position + d: PRINT CHR$(value);
FOR s = 1 TO 10: NEXT s
OUT 890, 6
FOR s = 1 TO 10: NEXT s
OUT 890, 2
FOR g = 1 TO 500: NEXT g
NEXT d

END SUB

