/* Test program to drive motor1 on stepper motor card 1        */
/* Wave stepping using Turbo C's outportb command              */
/* The motor states address the lower 4 bits that go           */
/* to the printer port. To drive motor2, the motor states      */
/* need to be shifted left 4 places.                           */

/*
.NAME.	:	steps
.VER.		:	0
.DATE.	:	7 Jan 1994
*/


#include <stdio.h>
#include <ctype.h>

#define ON   25000                    /* ON time delay constant  */
#define OFF  5000                    /* OFF time delay constant */
#define PORTA 0x378                  /* port A on LPT1   LPT2=0x278  */
#define PORTC 0x37A                  /* port C on LPT1   LPT2=0x27A  */
#define NOSLCT 0x04                  /* all card enables high */
#define CARD  0x05                   /* for card1
                                            card2 = 0x06
                                            card3 = 0x00
					    card4 = 0x0C      */



main(void){
			/* actual program begins here  */

int steps,dir,x,d,error;         /* declare variables to be used */
unsigned char state;    /* state is a byte that hold motor state */

printf("\nStepper motor example driver program written in C\n\n");

steps=1;      /* initialise variable to be valid into the while loop */
state=0x01;                        /* initialise state to a known state */

while(steps){                 /* loops while steps is greater than 0 */
	do
	{
		printf("\nNumber of steps to move (zero ends program): ");
		error = scanf("%d",&steps);    /* get an int from the keyboard */
		if (!error) flushall(); 		 /* if the input was not an int,
													 flush the input buffer*/
	}
	while( !error || steps<0 );  /* if the input was not an int,
											  get another input */

   if(!steps) break;     /* break out of the while loop if steps is zero */

	do 		  			/* repeat this loop until valid input is given */
		{
			printf("\nDirection (0|clockwise 1|anticlockwise): ");
			error = scanf("%d",&dir);   /* get an int from the keyboard */
			if (!error) flushall();     /* if the input was not an int,
													 flush the input buffer*/
		}
	while ( (dir<0 || dir>1) || !error ); 	/* test for valid input,
															repeat if bad */

	printf("\n Number of steps to move: %d in direction: %d \n",steps,dir);

	for(x=0;x<steps;x++)          /* loop for number of steps to move  */
	{
		if(!dir)                   /* work out next phase for clockwise */
		{
			if(state==0x08) state=0x01; /*state==0x80 state=0x10; for motor2*/
			else state=state<<1;                /* shift bitwise left */
		}
		else                   /* work out next phase for anticlockwise */
		{
			if(state==0x01) state=0x08; /*state==0x10 state=0x80; for motor2*/
			else state=state>>1;               /* shift bitwise right */
		}

     printf("state:%x\n",state); /* print current state on the console */

     outportb(PORTC,NOSLCT);     /* makes the card enable initially high */
     outportb(PORTC,CARD);       /* sends card enable low */
     outportb(PORTA,state);      /* data to be loaded into latch */
     outportb(PORTC,NOSLCT);     /* loads latch with new phase data on
                                    rising edge of selected card enable*/

     for(d=0;d<ON;d++);          /* time delay loop for on time */
     outportb(PORTC,CARD);       /* sends card enable low */
     outportb(PORTA,0x00);       /* data to turn all phases off */
     outportb(PORTC,!CARD);      /* loads latch with new data */
     for(d=0;d<OFF;d++);         /* time delay loop for off time */
	}                             /* end of for loop */
  }                              /* end of while loop  */
}   /* end of function main */