/* ------------ steptest.c ------------ */
/*
.NAME.	:	steptest
.VER.		:	0
.DATE.	:	7 Jan 1994
*/

/*
 *  This program tests the STEPPER Motor Driver Card
 *  for correct operation.
 *  Jan 1994.
 */

#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <string.h>

#define DEBUG     /*for testing purposes  */

#define REV 		01              /* version of program */
#define LPT1		0x378           /* base address of LPT1 */
#define LPT2		0x278           /* base address of LPT2 */
#define SLCT_1		0x05            /* enable code for card 1 */
#define SLCT_2		0x06            /* enable code for card 2 */
#define SLCT_3		0x00            /* enable code for card 3 */
#define SLCT_4		0x0C            /* enable code for card 4 */
#define NO_SLCT	0x04            /* no card enabled */

/* -------function prototypes--------*/

int keyhit(void);
void wait(void);
void motor_test(int motor, unsigned char code, int address, int port);
void test(unsigned char code, int add, int printer_p);

/* -------returns true if a key is hit--------*/
int keyhit()
    {
	 if(kbhit()) return 0 ;
	getch() ;      /* eat the keystroke */
	return 1 ;
    }

/* -------waits in a loop until a key is hit--------*/
void wait()
	{
	printf("\nPress any key to continue...\r");
	do; while(!keyhit());
	printf("                            \n");
	}

/* -------tests the phases of a motor on the card--------*/
void motor_test(int motor, unsigned char code, int address, int port)
	{
	printf ("\n\nTESTING CARD at address %01d connected to LPT%01d.\n"
	,address,port);
	if(port == 1) port = LPT1;
			else port = LPT2;
	printf ("TEST for motor %01d.\n\n",motor);
	test(code, address, port);
	printf ("	Phase 1 is ON.\n	PIN 1 should be +12V\n	PIN 2 should be GND");
	wait();
	code<<=1;
	test(code, address, port);
	printf ("	Phase 2 is ON.\n	PIN 3 should be +12V\n	PIN 4 should be GND");
	wait();
   code<<=1;
	test(code, address, port);
	printf ("	Phase 3 is ON.\n	PIN 1 should be GND\n	PIN 2 should be +12V");
	wait();
   code<<=1;
	test(code, address, port);
	printf ("	Phase 4 is ON.\n	PIN 3 should be GND\n	PIN 4 should be +12V");
	wait();
	}

/* -------writes motor codes to the printer port--------*/
void test(unsigned char code, int add, int portA)
	{
	int portC ,select;

	portC = portA + 2;
	switch(add)
		{
		case 2:  select = SLCT_2;
			break;
		case 3:  select = SLCT_3;
			break;
		case 4:  select = SLCT_4;
			break;
		default:  select = SLCT_1;
		}

	outportb(portA, code);
	outportb(portC, select);
	outportb(portC, NO_SLCT);

	}

/* -------main program--------*/
void main(void)
	{
	int card_add, printer_port, error ;
	char redo;

	do
		{
		printf ("STEPPER MOTOR Card Testing program V %02d Marque Crozman 1994.\n",REV ) ;
		do
			{
			printf ("\n\n	Is the card connected to LPT1 or LPT2 (1/2) :");
			error = scanf("%d",&printer_port);
			if (!error) flushall(); 		 /* if the input was not an int,
														 flush the input buffer*/
			}
		while(printer_port<1 || printer_port>2 || !error);
													 /* tests for valid input */
		do
			{
			printf ("\n	Enter the address of the card to be tested, (1/2/3/4) :");
			error = scanf("%d",&card_add);
			if (!error) flushall(); 		 /* if the input was not an int,
														 flush the input buffer*/
			}
		while(card_add<1 || card_add>4 || !error);
													 /* tests for valid input */
		printf ("\nApply power now to the stepper motor card to be tested.");
		wait();

		motor_test(1, 0x01, card_add, printer_port);      /* tests motor 1 */
		motor_test(2, 0x10, card_add, printer_port);      /* tests motor 2 */
		do
			{
			printf ("\nDo you want to test another card (y/n) :");
			redo=getche();
			}
		while(redo!='y'&&redo!='n');              /* tests for valid input */
      printf("\n\n");
		}
	while(redo!='n');
	}



