REM test program to drive motor1 on stepper motor controller board

porta = &H378:     REM address of port A for LPT1    (LPT2= &H278)
portc = &H37A:     REM address of port C for LPT1    (LPT2= &H27A)
card = &H5:        REM card1=&H05  card2=&H06  card3=&H00 card4=&H0C
ontime = 30:       REM  specifies phase on time
offtime = 5:     REM  specifies delay between steps
steps = 1:         REM initialise variable to be valid into the while loop
state = 1:         REM initialise state to a known state
PRINT
PRINT "Stepper motor example driver program written in QBASIC"
PRINT
WHILE (steps > 0)
PRINT "number of steps to move (zero ends program):";
INPUT steps
IF (steps = 0) THEN END
DO
        PRINT "direction (0|clockwise 1|anticlockwise):";
        INPUT dir
LOOP WHILE (dir < 0 OR dir > 1):  REM unsure valid input otherwise repeat
PRINT "steps: ", steps, "direction: ", dir
FOR x = 1 TO steps:           
     IF (dir < 1) THEN
       IF (state = 8) THEN state = 1 ELSE state = state * 2
     ELSE
       IF (state = 1) THEN state = 8 ELSE state = state / 2
     END IF

PRINT "state ", state
OUT portc, 4:               REM make all card enables initially high
OUT porta, state:           REM write the data to the latch
OUT portc, card:            REM make selected card enable go low
                            REM card2=6, card3=0, card4=12
OUT portc, 0:               REM load the data into the latch
FOR d = 1 TO ontime: NEXT:  REM on time delay

OUT porta, 0:               REM turn the phases off data
OUT portc, card:            REM make selected card enable go low
OUT portc, 4:               REM load the new data into the latch
                            REM on the rising edge of the enable line
FOR d = 1 TO offtime: NEXT: REM off time delay
NEXT x:                     REM end of for loop

WEND:                       REM end of while loop
END:                        REM end of program r











