'Printer driver or the PRINTER STATUS INDICATOR project
'COPYRIGHT 1993 DARREN YATES B.Sc.
'All rights reserved.
'This program may not be copied with prior consent of author or publisher


DECLARE SUB errorcheck (tests, errcode)
DECLARE SUB fastprint (prog2%(), printfile$, a$, k%, byte)
DECLARE SUB lcddisplay (line1$, line2$)

ON ERROR GOTO errorhandler

DIM prog2%(20) 'array for machine code program
DIM semi(20)  'array for sub-directory levels
extension = 0
drive = 0
discbyte = 0
bytes2:       'machine code for print routine

DATA &h55             : 'push BP
DATA &hb4,&h05        : 'mov AH,05
DATA &hb2,&h00        : 'mov DL,00
DATA &hcd,&h21        : 'INT 21H
DATA &h5d             : 'pop BP
DATA &hca,&h00,&h00   : 'ret 0 (do a far return back to QuickBASIC)

RESTORE bytes2

q = VARPTR(prog2%(1))             'find address for start of prog array
DEF SEG = VARSEG(prog2%(1))       'find segment for array
FOR d = 0 TO 10                   ' feed program into array
READ we                            '
POKE (q + d), we                  '
NEXT d                            '

c$ = COMMAND$      'get filename and path from program input

IF INSTR(c$, "/F") > 0 THEN fastp = 1
IF INSTR(c$, "/?") > 0 THEN GOTO help
IF c$ = "" THEN GOTO help

SCREEN 9: CLS
LOCATE 1, 1: PRINT "PRINTER STATUS INDICATOR DRIVER"
LOCATE 2, 1: PRINT "(C) Copyright 1993 Silicon Chip"
LOCATE 3, 1:  PRINT " Written by DARREN YATES B.Sc."
LOCATE 1, 40: PRINT "All rights reserved."
LOCATE 2, 40: PRINT "This program may not be copied without"
LOCATE 3, 40: PRINT "prior consent of the author or publisher."

VIEW SCREEN (5, 50)-(634, 334), 0, 4  'set up active window



'find the path for the file specified

FOR d = 1 TO LEN(c$)
   B$ = MID$(c$, d, 1)
   IF B$ = "\" THEN drive = 1
   IF B$ = "\" THEN backslash = backslash + 1: semi(backslash) = d
   IF B$ = "/" THEN slash = d - 1
NEXT d
IF slash = 0 THEN slash = LEN(c$)

printfile$ = LEFT$(c$, slash)

'find the correct drive

IF drive = 1 THEN
   WHILE B$ <> ":" AND e <> LEN(c$)
      e = e + 1
      B$ = MID$(c$, e, 1)
      drive$ = drive$ + B$
   WEND
END IF

'change drive to DRIVE$

IF drive = 1 THEN SHELL drive$ + ":"

'find the beginning of path information with out the drive letter in front

WHILE B$ <> "\" AND pt <> LEN(c$)
   pt = pt + 1
   B$ = MID$(c$, pt, 1)
WEND

' get path info and store in variable PATH$

IF backslash > 0 THEN
   FOR d = pt TO semi(backslash) - 1
      h = h + 1
      path$ = path$ + MID$(c$, d, 1)
   NEXT d
END IF

'change directory to PATH$

IF backslash > 0 THEN SHELL "cd" + path$

'get the filename with and without extension
'filename+extension stored in FILENAME$
'filename only stored in FILE$

FOR d = semi(backslash) + 1 TO slash
  
   filename$ = filename$ + MID$(c$, d, 1)
   IF MID$(c$, d, 1) = "." THEN extension = 1
      
   
   IF extension = 0 AND LEN(file$) < 8 THEN file$ = file$ + MID$(c$, d, 1)
   IF extension = 1 THEN ext$ = ext$ + MID$(c$, d, 1)

NEXT d

d = LEN(file$)
IF d < 8 THEN file$ = file$ + STRING$(8 - d, 32)

IF LEN(ext$) > 0 THEN ext$ = MID$(ext$, 2, LEN(ext$) - 1)

'dump directory listing into file DRIVE$:\PATH$\dirfile

SHELL "dir > dirfile"

OPEN "dirfile" FOR INPUT AS #1
   WHILE NOT EOF(1)
      LINE INPUT #1, s$
      v = v + 1
      IF v > 5 THEN
         discfile$ = LEFT$(s$, 8)
         discext$ = MID$(s$, 10, 3): IF discext$ = "   " THEN discext$ = ""
         discbyte$ = MID$(s$, 14, 9)
         discdate$ = MID$(s$, 24, 8)
         disctime$ = MID$(s$, 34, 6)
         IF file$ = discfile$ AND ext$ = discext$ THEN
            LOCATE 5, 3: PRINT "File to be sent: "; filename$
            LOCATE 6, 3: PRINT "Size of file   : "; VAL(discbyte$); "bytes"
            discbyte = VAL(discbyte$)
            LOCATE 7, 3: PRINT "Date of file   : "; discdate$
            LOCATE 8, 3: PRINT "Time of making : "; disctime$
         END IF
      END IF
   WEND
CLOSE #1


IF fastp = 1 THEN
   LOCATE 7, 45:
   PRINT "FastPrint mode selected."
END IF

VIEW SCREEN (5, 160)-(634, 334), 0, 4  'set up active window
LOCATE 13, 3: PRINT "Press [c] to start printing"
LOCATE 14, 3: PRINT "      [q] to quit"
ans$ = INPUT$(1)
IF ans$ = "q" OR ans$ = "Q" THEN END
CLS

CALL lcddisplay("Sending file:", filename$)


'sending the file to the printer..................

OUT &H37A, (INP(&H37A) OR 8)

IF fastp = 0 THEN
   VIEW SCREEN (380, 50)-(634, 158), 0, 4
   LOCATE 8, 55: PRINT STRING$(20, 176)
   LOCATE 8, 55: PRINT CHR$(219);
   LINE (426, 94)-(597, 115), 3, B
   LOCATE 6, 58: PRINT "Printing..."
END IF

LOCATE 10, 3: PRINT "Sending file "; printfile$; " to printer on LPT1:"
LOCATE 23, 3: PRINT "Press [q] to abort. . ."

IF fastp = 1 THEN CALL fastprint(prog2%(), printfile$, a$, k%, byte)
IF fastp = 1 THEN GOTO endprint

OPEN printfile$ FOR INPUT AS #1

LOCATE 11, 3: PRINT "Bytes sent:";

p = VARPTR(prog2%(1))
DEF SEG = VARSEG(prog2%(1))


WHILE NOT EOF(1)

bcd$ = INKEY$: IF bcd$ = "q" OR bcd$ = "Q" THEN GOTO endprint

IF fastp = 0 THEN
   tests = 0: errcode = 1
   WHILE tests = 0 OR errcode = 1
      CALL errorcheck(tests, errcode)
   WEND
END IF

a$ = INPUT$(1, #1)
POKE p + 4, ASC(a$)
CALL absolute(VARPTR(prog2%(1)))
byte = byte + 1
hundred% = hundred% + 1

IF hundred% = 100 THEN
   hundred% = 0
   LOCATE 11, 15
   PRINT USING "#####.#"; byte / 1000;
   PRINT "k"
END IF

IF fastp = 0 THEN
   newbyte = INT((byte / discbyte) * 19)
   IF old < newbyte THEN
      LOCATE 8, (55 + newbyte):
      PRINT CHR$(219);
      old = newbyte
   END IF
END IF

WEND

endprint:
CLOSE #1

LOCATE 15, 3: PRINT "File "; printfile$; " sent to printer on LPT1"
LOCATE 16, 3: PRINT "Total bytes sent:"; byte
LOCATE 23, 3: PRINT "Press a key to return to DOS prompt"
z$ = INPUT$(1)
END
errorhandler:
   SOUND 300, 5: SOUND 200, 5
   LOCATE 17, 3: PRINT "PRINTING TERMINATED. PRINTER ERROR HAS OCCURRED."
   LOCATE 18, 3: PRINT "CHECK YOUR PRINTER, COMPUTER, and PRINTER CABLE."
   CALL lcddisplay("** PRINTER ERROR **", "Check equipment!")
   END

help:
  
   PRINT : PRINT "PRINTER INDICATOR STATUS DRIVER (c)opyright 1993"
   PRINT "Silicon Chip Publications Pty Ltd. Written by DARREN YATES B.Sc."
   PRINT : PRINT "Command line format:"
   PRINT "PRINTER [drive:]/[path]/filename[.ext][/f][/?]"
   PRINT : PRINT "Switches:"
   PRINT "  /f - fast printing - only minimal check done to speed up printing"
   PRINT "  /? - info page - this help screen."
   PRINT : PRINT "Example:"
   PRINT "      PRINTER C:\WINDOWS\TEXT.DAT/F"
   END

SUB errorcheck (tests, errcode)

errcode = 0

testport% = INP(&H379)
busy% = testport% AND 128
outofpaper% = testport% AND 32
selected% = testport% AND 16
inputerror% = testport% AND 8

IF outofpaper% <> 32 AND selected% <> 0 AND inputerror% <> 0 THEN GOTO noerror
   
IF (outofpaper% = 32) OR (selected% = 0) OR (inputerror% = 0) THEN
   errcode = 1
   VIEW SCREEN (5, 160)-(634, 334), 0, 4  'set up active window
END IF

IF outofpaper% = 32 THEN
   LOCATE 13, 3: PRINT "OUT OF PAPER: Check the paper supply and printer for problems."
   LOCATE 14, 3: PRINT "Make sure the printer cable is connected to your PC correctly."
   CALL lcddisplay("*PRINT STOPPED*", "Out of paper")
END IF

IF inputerror% = 0 THEN
   LOCATE 16, 3: PRINT "OUTPUT ERROR: Check that the printer is ON LINE. The ERROR flag"
   LOCATE 17, 3: PRINT "has been set, indicating that it cannot accept the file."
   CALL lcddisplay("*PRINT STOPPED*", "On line error")
END IF

IF selected% = 0 THEN
   LOCATE 19, 3: PRINT "PRINTER SELECT: Check that the printer is ON. The BUSY flag"
   LOCATE 20, 3: PRINT "has been set, indicating that it cannot accept the file."
   CALL lcddisplay("*PRINT STOPPED*", "Is printer ON?")
END IF

IF errcode = 1 THEN
   SOUND 300, 6
   LOCATE 22, 3: PRINT "Press [c] to continue file transfer to printer"
   LOCATE 23, 3: PRINT "      [q] to quit."
   a$ = INPUT$(1)
   IF a$ = "q" OR a$ = "Q" THEN END
   CLS
END IF
noerror:
   IF outofpaper% <> 32 AND selected% <> 0 AND inputerror% <> 0 THEN errcode = 0
tests = 1

END SUB

SUB fastprint (prog2%(), printfile$, a$, k%, byte)

ON ERROR GOTO errorhandler


OPEN printfile$ FOR INPUT AS #1

LOCATE 11, 3: PRINT "Bytes sent:";

p = VARPTR(prog2%(1))
DEF SEG = VARSEG(prog2%(1))

WHILE NOT EOF(1)

a$ = INPUT$(1, #1)
POKE p + 4, ASC(a$)
CALL absolute(VARPTR(prog2%(1)))
byte = byte + 1
k% = k% + 1

IF k% = 1000 THEN
   k% = 0
   LOCATE 11, 15
   PRINT INT(byte / 1000);
   PRINT "k"
END IF

WEND

END SUB

SUB lcddisplay (line1$, line2$)

OUT 888, 1
FOR d = 1 TO 20: NEXT d
OUT 890, 6 AND 7
FOR d = 1 TO 20: NEXT d
OUT 890, 2 AND 7
FOR d = 1 TO 20: NEXT d
OUT 888, 15
FOR d = 1 TO 20: NEXT d
OUT 890, 6 AND 7
FOR d = 1 TO 20: NEXT d
OUT 890, 2 AND 7
FOR d = 1 TO 20: NEXT d
OUT 888, 56
FOR d = 1 TO 20: NEXT d
OUT 890, 6 AND 7
FOR d = 1 TO 20: NEXT d
OUT 890, 2 AND 7



OUT 888, 6
FOR d = 1 TO 50: NEXT d
OUT 890, 6 AND 7
FOR d = 1 TO 50: NEXT d
OUT 890, 2 AND 7

FOR f = 1 TO LEN(line1$)
value = ASC(MID$(line1$, f, 1))
OUT 888, value
FOR d = 1 TO 10: NEXT d
OUT 890, 4 AND 7
FOR d = 1 TO 10: NEXT d
OUT 890, 0 AND 7
FOR d = 1 TO 10: NEXT d
NEXT f

OUT 888, 169
FOR d = 1 TO 10: NEXT d
OUT 890, 6 AND 7
FOR d = 1 TO 10: NEXT d
OUT 890, 2 AND 7

FOR f = 1 TO LEN(line2$)
value = ASC(MID$(line2$, f, 1))
OUT 888, value
FOR d = 1 TO 10: NEXT d
OUT 890, 4 AND 7
FOR d = 1 TO 10: NEXT d
OUT 890, 0 AND 7
FOR d = 1 TO 10: NEXT d
NEXT f


END SUB

