'Copyright 1993 Darren Yates B.Sc.
'Low-Frequency ADC using games port

'This software requires a constant current source
'connected up to pin 3 of the games port. Power
'can be taken from the port itself.


SCREEN 12
offset = 0
xscale = 16
yscale = 1

LINE (0, 0)-(639, 479), 15, B
VIEW SCREEN (3, 3)-(636, 252), , 15
DIM a%(640)


WHILE a$ <> "q"


a$ = INKEY$

IF a$ = "u" THEN xscale = xscale * 2
IF a$ = "d" THEN xscale = xscale / 2
IF a$ = "i" THEN offset = offset + 25
IF a$ = "j" THEN offset = offset - 25
IF a$ = "b" THEN yscale = yscale * 2
IF a$ = "c" THEN yscale = yscale / 2

LOCATE 18, 2: PRINT "sampling....."
LOCATE 20, 2: PRINT " Press [u] to increase horizontal scale (XSCALE)"
LOCATE 21, 2: PRINT " Press [d] to decrease XSCALE"
'LOCATE 22, 2: PRINT " Press [i] to increase offset by 25"
'LOCATE 23, 2: PRINT " Press [j] to decrease offset by 25"
LOCATE 24, 2: PRINT " Press [b] to increase vertical scale (YSCALE)"
LOCATE 25, 2: PRINT " Press [c] to decrease YSCALE"
LOCATE 26, 2: PRINT " Press [q] to quit"

FOR d = 1 TO 640 / xscale
a%(d) = STICK(0)
NEXT d

total = 0
FOR d = 1 TO 640 / xscale
total = total + a%(d) * yscale
NEXT d
average = total / (640 / xscale)
offset = average - 128


CLS
FOR d = 10 TO 640 STEP 40
FOR e = 10 TO 255 STEP 40
PSET (d, e)
NEXT e
NEXT d

LINE (0, 182 + offset)-(640, 182 + offset), 15
PSET (0, (a%(1) * yscale) - offset)
TIME$ = "00:00:00"
FOR d = 2 TO 640 / xscale
LINE -(d * xscale, (a%(INT(d)) * yscale) - offset), 15
NEXT d
LOCATE 17, 2: PRINT "xscale ="; xscale, : PRINT "offset ="; offset, : PRINT "yscale ="; yscale

WEND

