' Games card finder program
' Copyright 1993 Silicon Chip Publications
' Written by Darren Yates B.Sc.
' This program prints a message indicating whether or not
' a games card is installed.
' It uses a machine-language program stored in an array
' to get the information from the operating system.
DEFINT A-Z
DIM Asmprog(1 TO 7)

' The machine-language program stored as data to read into
' the array.
AsmBytes:
DATA &H55              : 'PUSH BP        Save base pointer.
DATA &H8B, &HEC        : 'MOV  BP,SP     Get our own.
DATA &HCD, &H11        : 'INT  11H       Make the ROM-BIOS call.
DATA &H8B, &H5E, &H06  : 'MOV  BX,[BP+6] Get argument address.
DATA &H89, &H07        : 'MOV  [BX],AX   Save list in argument.
DATA &H5D              : 'POP  BP        Restore base pointer.
DATA &HCA, &H02, &H00  : 'RET  2         Pop argument off stack
                         '               and make far return.
' Get the starting offset of the array.
start = VARPTR(Asmprog(1))
' Poke the machine-language program into the array.
DEF SEG = VARSEG(Asmprog(1))' Change the segment.
RESTORE AsmBytes
FOR index = 0 TO 13
   READ byte
   POKE (start + index), byte
NEXT index

' Execute the program. The program expects a single integer argument.

CALL ABSOLUTE(status%, VARPTR(Asmprog(1)))
DEF SEG   ' Restore the segment.
' status% now contains bit-encoded equipment list returned by DOS.
' Mask off all but the games card bit (bit 12).
game = status% AND &H1000
' Print the appropriate message.
IF game = 4096 THEN
  PRINT "Games Card present."
ELSE
  PRINT "No Games Card."
END IF
END

