'Joystick button finder
'Copyright 1993 SILICON CHIP
'Written by DARREN YATES B.Sc.
' This program uses the BIOS interrup 15, service 84 to obtain
' the status of the four fire buttons without using the BASIC
' commands.
DEFINT A-Z
DIM ASMPROG(1 TO 10)
DIM button(1 TO 4)
'The machine-code program is stored in the array ASMPROG and read
'and read into the array.
ASMBYTES:
DATA &h55               : 'PUSH BP        save base pointer
DATA &h8b,&hec          : 'MOV BP,SP      get our own
DATA &hb4,&h84          : 'MOV AH,84H     set service number
DATA &hba,&h00,&h00     : 'MOV DX,0000    select button input data only
DATA &hcd,&h15          : 'INT 15H        make ROM-BIOS call
DATA &h8b,&h5e,&h06     : 'MOV BX,[BP+6]  get argument address
DATA &h88,&h07          : 'MOV [BX],AL    save list in argument
DATA &h5d               : 'POP BP         pop argument off stack
DATA &hca,&h02,&h00     : 'RET 2          and make far return to BASIC

'get the starting offset of the array
start = VARPTR(ASMPROG(1))
'poke machine code program into the array ASMPROG
DEF SEG = VARSEG(ASMPROG(1))
RESTORE ASMBYTES
FOR index = 0 TO 18
   READ byte
   POKE (start + index), byte
NEXT index
'run the machine-code program
start = VARPTR(ASMPROG(1))
CALL absolute(button, start)
DEF SEG
'variable BUTTON now contains info on the joystick buttons
button(1) = button AND &H80
button(2) = button AND &H40
button(3) = button AND &H20
button(4) = button AND &H10
PRINT STRING$(18, 205)
'this section selects the correct bit for each button
' bit 7 = button 1; bit 6 = button 2; bit 5 = button 3; bit 4 = button 4
' if that bit is 0 then button is pressed
FOR number = 1 TO 4
IF button(number) = 2 ^ (8 - number) THEN
   PRINT "button "; number; " is open"
   ELSE
   PRINT "button "; number; " is pressed"
END IF
NEXT number

