REM Binary Clock for PCs
REM Written By DARREN YATES B.Sc. - requires VGA screen & card
REM From a program devised on the Atart ST by ERIC HUGHES
DIM SHARED B(200), c(200)
DECLARE SUB DISPLAY (B, c, A$)
SCREEN 12, 1
LINE (0, 0)-(639, 479), 2, B
LOCATE 2, 28: PRINT " SILICON CHIP Binary Clock"
LOCATE 10, 38: PRINT "HOURS"
LOCATE 22, 15: PRINT "MINUTES"
LOCATE 22, 60: PRINT "SECONDS"
BIN$ = "32  16   8    4   2    1"
LOCATE 28, 7: PRINT BIN$
LOCATE 16, 29: PRINT BIN$
LOCATE 28, 51: PRINT BIN$
SCREEN 12, 1
CIRCLE (20, 20), 15, 15
GET (4, 4)-(36, 36), B
PAINT (19, 20), 4, 15
GET (4, 4)-(36, 36), c
PUT (4, 4), c
WHILE QUIT$ <> "Q" AND QUIT$ <> "q"
   FOR G = 1 TO 3
   H$(G) = ""
   NEXT G
   A$ = TIME$
   IF A$ <> OLDA$ THEN CALL DISPLAY(B, c, A$)
   OLDA$ = A$
   QUIT$ = INKEY$
WEND

SUB DISPLAY (B, c, A$)
DIM D(3), H$(3)
hour$ = MID$(A$, 1, 2)
minute$ = MID$(A$, 4, 2)
second$ = MID$(A$, 7, 2)
hour = VAL(hour$)
minute = VAL(minute$)
second = VAL(second$)
D(1) = hour
D(2) = minute
D(3) = second
LOCATE 7, 39: PRINT D(1)
LOCATE 20, 17: PRINT D(2)
LOCATE 20, 62: PRINT D(3)
FOR v = 1 TO 3
   WHILE D(v) <> 0
      f = D(v)
      D(v) = INT(f / 2)
      r = f - (2 * D(v))
      IF r = 0 THEN H$(v) = "0" + H$(v)
      IF r = 1 THEN H$(v) = "1" + H$(v)
   WEND
   IF LEN(H$(v)) < 6 THEN
   FOR G = 1 TO 6 - LEN(H$(v))
      H$(v) = "0" + H$(v)
   NEXT G
   END IF
NEXT v
FOR w = 1 TO LEN(H$(1))
   bit$ = MID$(H$(1), (LEN(H$(1)) - (w - 1)), 1)
   IF bit$ = "1" THEN PUT (425 - (w * 35), 190), c, PSET
   IF bit$ = "0" THEN PUT (425 - (w * 35), 190), B, PSET
NEXT w
FOR w = 1 TO LEN(H$(2))
   bit$ = MID$(H$(2), (LEN(H$(2)) - (w - 1)), 1)
   IF bit$ = "1" THEN PUT (250 - (w * 35), 380), c, PSET
   IF bit$ = "0" THEN PUT (250 - (w * 35), 380), B, PSET
NEXT w
FOR w = 1 TO LEN(H$(3))
   bit$ = MID$(H$(3), (LEN(H$(3)) - (w - 1)), 1)
   IF bit$ = "1" THEN PUT (600 - (w * 35), 380), c, PSET
   IF bit$ = "0" THEN PUT (600 - (w * 35), 380), B, PSET
NEXT w
END SUB

