'Battery voltage data recorder using the Games port input
'Copyright 1993 Silicon Chip Publications Pty Ltd
'Written by Darren Yates B.Sc.

'The Games card port can accept voltage from 6V down to 3.4V
'By using voltage divider, the port can be made to span wider
'voltage ranges.

'Using a 2.2k# and 4.7k# resistor, the voltage range is from 9.1V
'down to 5.1V which is suitable for monitoring 7.2V Nicd racing packs.

DECLARE SUB voltagerange (voltage$, sampletime$)
DECLARE SUB monitor (sampletime$)
DECLARE SUB options (voltage$, sampletime$)
DECLARE SUB savefile (dat(), voltage$, sampletime$)
DECLARE SUB loadfile (dat(), voltage$, sampletime$, text$, olddate$, oldtime$)
DECLARE SUB displayfile (dat(), voltage$, sampletime$, text$, olddate$, oldtime$)

DIM SHARED dat(500)

SCREEN 9
COLOR 14, 1
LOCATE 2, 2: PRINT "Battery Voltage Monitor V1.1"
LOCATE 3, 2: PRINT "Copyright 1993,1994 SILICON CHIP PUBLICATIONS"
LOCATE 4, 2: PRINT "Written by Darren Yates B.Sc."
LINE (0, 65)-(639, 65)
LINE (0, 0)-(639, 349), , B


CALL options(voltage$, sampletime$)

SUB displayfile (dat(), voltage$, sampletime$, text$, olddate$, oldtime$)

x = 0

CLS
CALL voltagerange(voltage$, sampletime$)
VIEW
COLOR 14
LINE (400, 0)-(400, 65)
COLOR 11
LOCATE 2, 55: PRINT "Date: "; olddate$
LOCATE 3, 55: PRINT "Time: "; oldtime$

VIEW SCREEN (100, 95)-(600, 290), , 14
PSET (1, 1): x = 100
LOCATE 6, 20: PRINT text$
FOR samp.points = 1 TO 500

   IF dat(samp.points) <> 0 THEN
  
      a = dat(samp.points)
      x = x + 1: IF x > 600 THEN x = 100: CLS : PSET (40, a)
      IF a > 100 THEN LINE -(x, a)
      IF a < 100 THEN LINE -(x, 258 + 20)
   END IF

NEXT samp.points

VIEW

LOCATE 25, 4: PRINT " Press <ENTER> to continue. . . ";

an$ = INPUT$(1)
COLOR 14
LINE (0, 0)-(639, 359), , B
END SUB

SUB loadfile (dat(), voltage$, sampletime$, text$, olddate$, oldtime$)

VIEW SCREEN (1, 70)-(638, 348)
CLS 1

LOCATE 12, 2: PRINT "This is the filename of the data ou wish to see. Don't bother with"
LOCATE 13, 2: PRINT "an extension as all Battery Voltage Monitor files are given .BVM"
LOCATE 14, 2: PRINT "as the extension. Maximum filename length: 8 legal characters"

LOCATE 8, 2: PRINT "Enter in [drive:][\directory\]filename: "; : INPUT "", name$

OPEN name$ + ".BVM" FOR INPUT AS #1

INPUT #1, olddate$
INPUT #1, oldtime$
INPUT #1, voltage$
INPUT #1, sampletime$
INPUT #1, text$

FOR x = 1 TO 500
INPUT #1, dat(x)
NEXT x

CLOSE #1

END SUB

SUB monitor (sampletime$)

oldtime$ = TIME$: x = 100: an$ = ""
sampletime = VAL(sampletime$)
LOCATE 25, 4: PRINT " Press a key to return to menu. . . ";
totalseconds = sampletime * 500

VIEW SCREEN (100, 95)-(600, 290), , 14

COLOR 11
PSET (20, 0)

samples = 0
WHILE samples <> 500 AND an$ <> CHR$(13) AND NEWSAMPLE < 230
  
timeloop:
   oldtime = INT(TIMER * 10) / 10
   WHILE oldtime + .5 > (INT(TIMER * 10) / 10)
   WEND
   seconds = seconds + .5
   an$ = INKEY$: IF an$ <> "" THEN GOTO nextstep
   IF seconds < sampletime THEN GOTO timeloop
 
nextstep:
   seconds = 0

   a = STICK(0)
   NEWSAMPLE = a
   dat = a - 90

   IF dat < 33 THEN newdat = dat * 1.5
   IF dat >= 33 AND dat < 62 THEN newdat = ((dat - 33) * 2.3) + (32 * 1.5)
   IF dat >= 68 THEN newdat = ((dat - 68) * 1.05) + (32 * 1.5) + (29 * 2.3)

   a = newdat + 108
   
   samples = samples + 1

   x = x + 1: IF x >= 600 THEN x = 100: CLS : PSET (40, a)
   IF a > 100 THEN LINE -(x, a)
   IF a < 100 THEN LINE -(x, 258 + 20)
   dat(samples) = a
   
WEND
COLOR 14
VIEW SCREEN (0, 0)-(639, 349)
LINE (0, 0)-(639, 349), , B
END SUB

SUB options (voltage$, sampletime$)
DIM x$(6)

menu:
LOCATE 2, 55: PRINT STRING$(20, 32)
LOCATE 3, 55: PRINT STRING$(20, 32)

LINE (0, 0)-(639, 349), , B

VIEW SCREEN (1, 70)-(638, 348)
CLS
selected = 0
x$(1) = "Set voltage level"
x$(2) = "Set measurement time"
x$(3) = "Take battery measurement"
x$(4) = "Save current readings to file"
x$(5) = "Load and display measurement file"
x$(6) = "Quit"

FOR c = 1 TO 6
LOCATE 5 + c, 4: PRINT c; ")  "; x$(c)
NEXT c
 WHILE selected < 1 OR selected > 6
 LOCATE 13, 2: PRINT "Select option:";
 INPUT " ", selected
 WEND

SELECT CASE selected

CASE 1
   CLS
   LOCATE 12, 3: PRINT "This is the battery's rated voltage. For a 7.2V racing pack, you"
   LOCATE 13, 3: PRINT "type in '7.2'<ENTER>. The battery voltage must be 4.8V or greater"
   LOCATE 14, 3: PRINT "and you will have to readjust the values of the voltage divider."
   LOCATE 16, 3: PRINT "Press <ENTER> to return to main menu."

   LOCATE 8, 3: INPUT "Enter in the rated battery voltage: ", voltage$
   IF v$ = "" THEN GOTO menu

CASE 2
   CLS
   LOCATE 12, 3: PRINT "This should be the time span between measurements.Make sure that"
   LOCATE 13, 3: PRINT "you enter in your time in SECONDS. The Battery Voltage Monitor will "
   LOCATE 14, 3: PRINT "take 500 reading equally spaced for that time. For example, if you enter"
   LOCATE 15, 3: PRINT "3 seconds, you will get one reading taken every 3 seconds."
   LOCATE 16, 3: PRINT "Minimum time is 0.5 second."

   LOCATE 18, 3: PRINT "Press <ENTER> to return to main menu."

   LOCATE 8, 3: INPUT "Enter in the measurement time: ", sampletime$
   IF t$ = "" THEN GOTO menu


CASE 3
   CLS : SCREEN 9
   CALL voltagerange(voltage$, sampletime$)
   monitor (sampletime$)

CASE 4
   CALL savefile(dat(), voltage$, sampletime$)

CASE 5
   CALL loadfile(dat(), voltage$, sampletime$, text$, olddate$, oldtime$)
   CALL displayfile(dat(), voltage$, sampletime$, text$, olddate$, oldtime$)

CASE 6
   END
END SELECT

GOTO menu

END SUB

SUB savefile (dat(), voltage$, sampletime$)

VIEW SCREEN (1, 70)-(638, 348)
CLS 1

LOCATE 12, 2: PRINT "This is the filename of the currently stored data. Don't bother with"
LOCATE 13, 2: PRINT "an extension as all Battery Voltage Monitor files are given .BVM"
LOCATE 14, 2: PRINT "as the extension. Maximum filename length: 8 legal characters"

LOCATE 8, 2: PRINT "Enter in [drive:][\directory\]filename: "; : INPUT "", name$

LOCATE 12, 2: PRINT "This is the text you wish to display with the graph. You may enter in"
LOCATE 13, 2: PRINT "anything you like so long as you don't exceed 40 characters.         "
LOCATE 14, 2: PRINT STRING$(70, 32)

LOCATE 8, 2: PRINT STRING$(76, 32)
LOCATE 8, 2: PRINT "Enter text :"; : INPUT "", text$


OPEN name$ + ".BVM" FOR OUTPUT AS #1

PRINT #1, DATE$
PRINT #1, TIME$
PRINT #1, voltage$
PRINT #1, sampletime$
PRINT #1, text$

FOR x = 1 TO 500
PRINT #1, dat(x)
NEXT x

CLOSE #1

END SUB

SUB voltagerange (voltage$, sampletime$)

COLOR 15
VIEW SCREEN (1, 70)-(638, 348)

CLS 1
volts = VAL(voltage$)
timespan = (VAL(sampletime$) * 500) / 60

upper = volts + (volts * .19)
lower = volts - (volts * .19)
midupper = volts + (volts * .095)
midlower = volts - (volts * .095)

upper$ = MID$(STR$(upper), 2, 4)
midupper$ = MID$(STR$(midupper), 2, 4)
lower$ = MID$(STR$(lower), 2, 4)
midlower$ = MID$(STR$(midlower), 2, 4)
volts$ = MID$(STR$(volts), 2, 4)

LOCATE 14, 6: PRINT volts$
LOCATE 20, 6: PRINT lower$
LOCATE 9, 6: PRINT upper$
LOCATE 7, 6: PRINT "VOLTS"
LOCATE 17, 6: PRINT midlower$
LOCATE 11, 6: PRINT midupper$

COLOR 7

LINE (93, 119)-(599, 119)
LINE (93, 186)-(599, 186)
LINE (93, 275)-(599, 275)
LINE (93, 146)-(599, 146)
LINE (93, 228)-(599, 228)

FOR B = 1 TO 10
COLOR 7
LINE (100 + (B * 50), 95)-(100 + (B * 50), 298)
COLOR 15
LOCATE 23, 12 + (B * 6): PRINT INT(10 * ((timespan / 10) * B)) / 10;
NEXT B

LOCATE 24, 38: PRINT "MINUTES";
END SUB

