'this program charges NiMH or NiCd 12V drill battery packs
'It detects a temp rise of 3 units in 5 minutes
'This can be changed by altering "temprise = 3" to some other value
'No charging if temp <0 or > 45
'Timeout of 10 hours used if temp end point not detected
symbol temprise = 3
symbol temp = 1
symbol charge = 2
symbol battery = 4
symbol temperature = w6
symbol batteryvoltage = b5
symbol inittemp = b4
symbol oldtemp = b3

main:
	low charge:high 0	'turn off charger:turn on indicator
	gosub tempread		'chech presence of temp probe
	if temperature > 300 then main 'temp probe missing
	'everything in order so proceed to charge

batterycharge:
	gosub tempread		'read initial temperature
	inittemp = temperature	'store initial values
	oldtemp = temperature
	gosub batterycheck
	if batteryvoltage > 180 then main	'battery not connected
	time = 0			'start timer
	high charge			'turn charger on	

chargeloop:
	gosub tempread		'get latest temp to check if bat removed
	readadc battery,batteryvoltage	'get latest voltage
	if batteryvoltage > 180 or temperature > 300 then main	'disconnected
	if temperature < 59 or temperature > 151 then stopcharge
		'no charging if temp < 0C or > 45C
	w5 = time//300		'check conditions every 5 minutes
	if w5 = 0 then
		gosub tempread	'get latest temp
		if temperature > oldtemp then
			let b0 = temperature - oldtemp	'get temp change
		else	b0 = 0
		endif
		if b0 >= temprise then stopcharge	'apply test
		oldtemp = temperature		'update oldtemp
	endif	
	if time > 36000 then stopcharge	'check 10 hr time limit
goto chargeloop	'keep charging

stopcharge:	
	low charge			'turn off charging
loop1:
	high 0:pause 500			'flash indicator for end of charge
	gosub tempread
	if temperature > 300 then main'check for battery removal
	low 0:pause 500
goto loop1

batterycheck: 			'read battery voltage in ADC terms
	high charge			'turn on charger temporarily
	pause 2000			'wait for voltages to stabilize
	readadc battery,batteryvoltage	'read value
	low charge			'turn off charger
return

tempread:				'read temperature in "reduced" adc format
	readadc10 temp,temperature	'read 16 bit ADC value from lm335
	temperature = temperature - 500'reduce value to fit into 8 bit variable
return
