/***

   FRS 14.5.2020 -
   Added function "refreshDisplay()". Needed when using 128x64 OLED and U8G2 library

   FRS 29.4.2020 -
   Display functions moved to Display file.

   FRS 27.4.2020 -
   Added display  functions to turn display off "sleepMode()" and back on "activeMode()".

   FRS 02.4.2020 -
   Notes: Addition of function to enable / disable start-up display message using P1 button.

   FRS 19.2.2020 -
   Notes: Tested requirement for lcd.clear() within program loops, inclusion will cause some noticable flicker. As space characters are used,
   this re-writes to the LCD and therefore clears the previous values, allowing for the ability not to use the lcd.clear(0) function.
   The lcd.clear() function is used where necessary.
*/

/* Function to turn display back on

*/
void activeMode() {
  //u8g2.setPowerSave(0); // Use with SSD1306 / SH1106
  mydisp.screenOnOff(1);  // Use with digole Display
  //oled.displayOn();   // Use with Newhaven Display
  btnLEDs(45, 25);   // P1 button LED = 45, Manual button LED = 25 (Idle Mode)
  idleLedState = true;
  grinderIdle = millis();
}

void sleepMode() {
  /*
    if (millis() >= grinderIdle + (IdleTime * 1000)) {
      if (millis() < screenSaverTimer * 60000) {
        idleLED();
      }
    }
  */
  if (millis() >= grinderIdle + screenSaverTimer * 60000) {
    idleLedState = false;
    //u8g2.setPowerSave(1);    // Use with SSD1306 / SH1106
    mydisp.screenOnOff(0); // Use with digole Display
    //oled.displayOff();  // Use with Newhaven Display
    sleepLED();
  }
}

/* Function added 14.5.2020
   Used to return OLED display to previous state
   after exisitng from Firmware & configuration screens.
   May not be required for other displays.
*/
void refreshDisplay() {

  if (displayState == 0) {
    presetOneDisplay();
  }

  if (displayState == 1) {
    presetTwoDisplay();
  }
  //u8g2.sendBuffer();
}

void presetFunctions() {

  // Sets display state to Preset 2
  //if ((ps2State == 1) && (selectState == 0)) {
  if ((timerState == 2) && (selectState == 0)) {
    displayState = 1;
  }
  // Sets display state to Preset 1
  //else if ((ps1State == 1) && (selectState == 0)) {
  else if ((timerState == 1) && (selectState == 0)) {
    displayState = 0;
  }
  // Displays Preset 1 information on LCD when P1 button pressed
  if ((displayState == 0) && (lastDisplayState == 1)) {
    presetOneDisplay();
    // Prevents display repeat.
    lastDisplayState = 0;

    /** FRS 18.3.2020 ** Added Encoder
       Sets up encoder position with preset value in EEPROM
    */
    myEnc.write(EEPROM.read(0)* encoderScaler );
  }
  // Displays Preset 2 information on LCD when P2 button pressed
  else if ((displayState == 1) && (lastDisplayState == 0)) {
    presetTwoDisplay();
    // Prevents display repeat.
    lastDisplayState = 1;

    /** FRS 18.3.2020 ** Added Encoder
        Sets up encoder position with preset value in EEPROM
    */
    myEnc.write(EEPROM.read(1)* encoderScaler );
  }

  /*---------------------- Preset 1 Time Programming -----------------------*/
  while ((displayState == 0) && (selectState == 1)) {

    statusLED(0); // LED off
    btnLEDs(55, 5); // P1 button LED = 55, Manual button LED = 5 
    // Read value from encoder ** FRS 18.3.2020 **
    grinderProg = readEncoderPos();
    presetOneSelect();
    lastDisplayState = 1;
    buttonCheck();
    presetOneVal = grinderProg;

    // Limits value to between 0.1 sec and 25.5 sec
    presetOneVal = constrain(presetOneVal, 1, 255);
    oldSelectState = 1;
  }

  /*---------------------- Preset 2 Time Programming -----------------------*/
  while ((displayState == 1) && (selectState == 1)) {

    statusLED(0); // LED off
    // Read value from encoder ** FRS 18.3.2020 **
    btnLEDs(55, 5); // P1 button LED = 55, Manual button LED = 5
    grinderProg = readEncoderPos();
    presetTwoSelect();
    lastDisplayState = 0;
    buttonCheck();
    presetTwoVal = grinderProg;

    // Limits value to between 0.1 sec and 25.5 sec
    presetTwoVal = constrain(presetTwoVal, 1, 255);
    oldSelectState = 1;
  }

  // Set states to 0 & writes Preset values to EEPROM
  if ((displayState == 0) && (selectState == 0) && (oldSelectState == 1)) {
    btnLEDs(45, 25);   // P1 button LED = 45, Manual button LED = 25 (Idle Mode)
    oldSelectState = 0;
    spitPresetOne();
  }
  else if ((displayState == 1) && (selectState == 0) && (oldSelectState == 1)) {
    btnLEDs(45, 25);   // P1 button LED = 45, Manual button LED = 25 (Idle Mode)
    oldSelectState = 0;
    spitPresetTwo();
  }


  /*---------------------- ACTIVE BUTTON FUNCTIONS---------------------*/

  while ((displayState == 0) && (timerState == 3)) {

    // Uncomment when using 16x2 character Display
    /*
      while (x < 1) {
      for (x = 0; x < 1; x++) {
        //print1602_T1L1();
      }
      }
    */
    oldTime = newTime;

    // Convert EEPROM form into msec value
    ps1Time = (runTime1 * 100);
    //ps1Time = (presetOneVal * 100);
    ps1TimeLength = (oldTime + ps1Time);
    countDown = (ps1TimeLength - millis());
    sec = countDown / 1000;
    msec = (countDown % 1000) / 100; // (FRS 17.5.2020: /10 for 2 DP rolling)

    //print1602_L2();   // Displays line 2 output on 16x2 LCD
    //mydisp.flushScreen(0); // Turns off Instant Refresh (Digole Display)
    drawRunTimer("Dose 1 Grinding");  // Displays output on 128x64 OLED

    if (millis() < ps1TimeLength) {
      // Activate Motor (Turns on SSR Pin)
      digitalWrite(ssr1, HIGH);
      statusLED(1); // LED full brightness.

    } else {

      // Deactivate Motor (Turns off SSR Pin)
      digitalWrite(ssr1, LOW);
      //mydisp.flushScreen(1); // For Digole Display
      presetOneDisplay();
      btnLEDs(45, 25);   // P1 button LED = 45, Manual button LED = 25 (Idle Mode)
      timerState = 1;
      x = 0;

      grinderIdle = millis(); // Start Idle Timer
    }
  }

  while ((displayState == 1) && (timerState == 3)) {

    // Uncomment when using 16x2 character Display
    /*
      while (x < 1) {
      for (x = 0; x < 1; x++) {
        print1602_T2L1();
      }
      }
    */
    oldTime = newTime;

    // Convert EEPROM form into msec value
    ps2Time = (runTime2 * 100);
    //prog2Time = (presetTwoVal * 100);
    ps2TimeLength = (oldTime + ps2Time);
    countDown = (ps2TimeLength - millis());
    sec = countDown / 1000;
    msec = (countDown % 1000) / 100; // (FRS 17.5.2020: /10 for 2 DP rolling)

    //print1602_L2();   // Displays line 2 output on 16x2 LCD
    //mydisp.flushScreen(0); // Turns off Instant Refresh (Digole Display)
    drawRunTimer("Dose 2 Grinding");  // Displays output on 128x64 OLED

    if (millis() < ps2TimeLength) {
      // Activate Motor (Turns on SSR Pin)
      digitalWrite(ssr1, HIGH);
      statusLED(1); // LED full brightness.

    } else {

      // Deactivate Motor (Turns off SSR Pin)
      digitalWrite(ssr1, LOW);
      //mydisp.flushScreen(1); // For Digole Display
      presetTwoDisplay();
      btnLEDs(45, 25);   // P1 button LED = 45, Manual button LED = 25 (Idle Mode)
      timerState = 2;
      x = 0;

      grinderIdle = millis(); // Start Idle Timer
    }
  }

  /* ---- Manual Grinding Mode ----
     Feature added FRS 14.3.2020;
     Display text when in manual mode.
  */

  while (timerState == 4) {
    digitalWrite(ssr1, HIGH);
    mydisp.clearScreen(); // Clear Digole Display
    drawManualMode();
    flashLED(3, 100);
    delay(100);
    buttonCheck();

    if (timerState == 0) {
      digitalWrite(ssr1, LOW);
      // FRS 19.2.2019 - Added to clear display after Manual State
      // lcd.clear();
      //presetOneDisplay();
      mydisp.clearScreen(); // Clear Digole Display
      refreshDisplay();

      grinderIdle = millis(); // Start Idle Timer
    }
  }
}

/* -- Firmware Display Function -- */
void firmwareDisplay() {

  mydisp.clearScreen(); // Clear Digole Display
  drawFirmware();
  btnLEDs(0, 0); // P1 button LED = 0, Manual button LED = 0 (Review Firmware)
  delay(8000);
  //selectState = 0;
  mydisp.clearScreen(); // Clear Digole Display
  refreshDisplay();
  btnLEDs(45, 25);   // P1 button LED = 45, Manual button LED = 25 (Idle Mode)
}


/*--------------Function to read preset values from EEPROM (needs only be done once during startup) ------------------*/

void sniffPresets() {
  presetOneVal = EEPROM.read(0);
  presetTwoVal = EEPROM.read(1);
  startMsg = EEPROM.read(2);

  // Sets up Initial value of encoder to presetOneVal on power-up ** Added FRS 18.3.2020 **
  long initEncVal = myEnc.read() / encoderScaler;
  if (initEncVal != presetOneVal) {
    myEnc.write(presetOneVal * encoderScaler);
  }
  /* Loads preset time at start ** Added FRS 19.3.2020 **
     15.4.2020 setup prior to display initialisation,
     (and subsequently set to 0 once display initialised.
  */
  grinderRunTime1 = presetOneVal;
  grinderRunTime2 = presetTwoVal;

}


/*-------------- EEPROM Functions - Saves Preset Values to EEPROM -----------*/

void spitPresetOne() {
  EEPROM.write(0, presetOneVal);
  flashLED(3, 50);
}

void spitPresetTwo() {
  EEPROM.write(1, presetTwoVal);
  flashLED(3, 50);
}

void SaveStartMsgState() {
  EEPROM.write(2, startMsg);
  flashLED(3, 50);
}



/*---- Function to print information to serial port ----*/

void printInfo() {
  Serial.println(F("*******************************"));
  Serial.println(F("* Coffee Grinder Timer Module *"));
  Serial.println(F("*******************************"));
  Serial.println(F("Written By: Flavio Spedalieri"));
  Serial.println(F("Nightlase Technologies, Sydney NSW Australia"));
  Serial.println(F("Email: fspedalieri@nightlase.com.au"));
  Serial.print(F("Firmware Version: "));
  Serial.println(fwVersion);
  Serial.print(F("Date: "));
  Serial.println(fwDate);
  Serial.print(F("Build Code: "));
  Serial.println(bc);
}
