/**
   FRS 11.5.2020 -
   Consolidation of timer states into single "timerState" variable.

   FRS 29.4.2020 -
   Implementation of screen saver mode. "grinderIdle = millis()" used as time keeper to turn off display after preset time using
   "screenSaverTimer" variable. "u8g2.setPowerSave(0)" function used to turn display back on and timer is reset.
   Display is restored when grinder activated.

   FRS 09.4.2020 -
   Single button configuration possible by modification of commented lines.
*/

/*--------------check button positions and write values pertaining to their states ------------------*/

void buttonCheck() {

  // Reads the pin state and assigns to button values

  /*-- ** FRS 19.3.2020 ** Variable Name change for program buttons --*/
  ps1Btn = digitalRead(preset1);
  ps2Btn = digitalRead(preset2);
  encBtn = digitalRead(select);
  activeBtn = digitalRead(active);
  manualBtn = digitalRead(manual);

  encBtnCheck();
  configBtnCheck();         // FRS 02.04.2020 - New feature to add user configurable functions.

  // Runs preset 2 when button 2 is pressed.
  //if ((ps2Btn == LOW) && (ps1Btn == HIGH) && (encBtn == HIGH)) {          // Uncomment for two button configuration.
  if ((ps1Btn == LOW) && (ps1BtnLastState == 1) && (encBtn == HIGH)) {    // Uncomment for single button configuration.
    activeMode(); // Wake up from sleep mode when P2 Activated.
    timerState = 2; // Set timer state to Preset 2
    //ps2State = 1; //** Depreciated 11.5.2020 **
    //ps1State = 0; //** Depreciated 11.5.2020 **
    flashLED(2, 100);

    // Runs preset 1 when button 1 is pressed.
  } else
    //if ((ps2Btn == HIGH) && (ps1Btn == LOW) && (encBtn == HIGH)) {         // Uncomment for two button configuration.
    if ((ps1Btn == LOW) && (ps1BtnLastState == 0) && (encBtn == HIGH)) {   // Uncomment for single button configuration.
      activeMode(); // Wake up from sleep mode when P1 Activated.
      timerState = 1; // Set timer state to Preset 1
      //ps2State = 0; //** Depreciated 11.5.2020 **
      //ps1State = 1; //** Depreciated 11.5.2020 **
      flashLED(1, 100);

      // Activates grinder timer mode.
    } else if ((activeBtn == LOW) && (manualBtn == HIGH)) {
      activeMode(); // Wake up from sleep mode when RUN Button pushed.
      timerState = 3; // Set timer state to RUN
      //manualState = 0; //** Depreciated 11.5.2020 **

      // Activated Manual Grinding mode.
    } else if ((activeBtn == HIGH) && (manualBtn == LOW)) {
      activeMode(); // Wake up from sleep mode when MANUAL Button pushed.
      timerState = 4; // Set timer state to MANUAL
      //activeState = 0; //** Depreciated 11.5.2020 **
      //manualState = 1; //** Depreciated 11.5.2020 **

    } else {
      timerState = 0; // Set timer state to IDLE

      //** Depreciated 11.5.2020 **
      //ps1State = 0;
      //ps2State = 0;
      //activeState = 0;
      //manualState = 0;
    }

}

/* ------------ Encoder Button Function --------------
    - Revised V2.74 FRS 07.05.2020 -
   Short press to enter / exit offset mode.
   Long press to display firware version & Build code.
*/

void encBtnCheck() {

  int r = 0;      // 0:not  1:short  2:long

  if (encBtnState == 0 ) {
    if (!encBtn) { // Not True, Button is being pushed
      encBtnTimer = millis();
      encBtnState = 1;
    }
  } else if (encBtnState == 1) {
    if ((millis() - encBtnTimer) > debounce) {
      if ((millis() - encBtnTimer) < encBtnLongPress) {
        if (encBtn == HIGH) {
          encBtnLastState = !encBtnLastState;
          //Enters or exits preset program mode
          selectState = !selectState;
          encBtnState = 3;
          activeMode(); //Wake up from sleep mode when encoder button pushed.
          grinderRunTime1 = 0;
          grinderRunTime2 = 0;
          r = 1;
        }
      } else {
        encBtnState = 2;
        flashLED(10, 50);
        firmwareDisplay();
        flashLED(1, 50);
        r = 2;
      }
    }
  } else if (encBtnState == 2) {
    if (encBtn == HIGH) {
      encBtnTimer = millis();
      encBtnState = 3;
    }
  } else if (encBtnState == 3) {
    if ((millis() - encBtnTimer) > 200) {
      encBtnState = 0;
    }
  }
  return r;
}


/* ------- Button Function to enter configuration mode ------
   Feature added FRS 02.04.2020
   To enable or disable start-up display message, long press
   P1 button. Configuration will automatically be set and saved.
*/

void configBtnCheck() {

  int  r = 0;      // 0:not  1:short  2:long

  if (ps1BtnState == 0 ) {
    if (!ps1Btn) { // Not True, Button is being pushed
      ps1BtnTimer = millis();
      ps1BtnState = 1;
    }

    if (offsetState == 1 && displayState == 0) { // Allows exit from offset state
      ps1BtnLastState = 0;
      exitOffset();
    }

    if (offsetState == 1 && displayState == 1) { // Allows exit from offset state
      ps1BtnLastState = 1;
      exitOffset();
    }

  } else if (ps1BtnState == 1) {
    if ((millis() - ps1BtnTimer) > debounce) {
      if ((millis() - ps1BtnTimer) < ps1BtnLongPress) {
        if (ps1Btn == HIGH) {
          ps1BtnLastState = !ps1BtnLastState;
          ps1BtnState = 3;
          r = 1;
        }
      } else {
        statusLED(0); // LED off
        ps1BtnState = 2;
        startMsgState = !startMsgState;
        startMsg = startMsgState;
        mydisp.clearScreen(); // Clear Digole Display
        setStartMsg();
        r = 2;
      }
    }
  } else if (ps1BtnState == 2) {
    if (ps1Btn == HIGH) {
      ps1BtnTimer = millis();
      ps1BtnState = 3;

    }
  } else if (ps1BtnState == 3) {
    if ((millis() - ps1BtnTimer) > 200) {
      ps1BtnState = 0;
    }
  }
  return r;
}

/**
    FRS 20.3.2020 - Added exit function for offsets.
    To exit offset and return to preset without saving, press the current program button.
*/
void exitOffset() {

  if ((offsetState == 1) && (displayState == 0) && (ps1Btn == LOW)) {
    myEnc.write(presetOneVal * encoderScaler);
    offsetState = 0;
    runTime1 = presetOneVal;
  }

  if ((offsetState == 1) && (displayState == 1) && (ps1Btn == LOW)) { //  For two button; ps2Btn == LOW, For single button; Ps1Btn == LOW
    myEnc.write(presetTwoVal * encoderScaler);
    offsetState = 0;
    runTime2 = presetTwoVal;
  }
}
