/*
   21.5.2020 - Addition of LED control for Program 1 & Manual Buttons.

   LED fade & blink functions.
   New feature added 3.4.2020

   Flavio Spedalieri
*/

void initLED() {
  led.fade(minLight, fadeTime);  // Run Button LED
  ledW.fade(minLight, fadeTime); // White LED (P1 Button)
  ledR.fade(minLight, fadeTime); // Red LED (Manual Button)
}

void idleLED() {

  if (idleLedState) {
    // LED no longer fading, switch direction
    if (!led.is_fading()) {
      // Fade down
      if (direction == dirUp) {
        led.fade(10, fadeTime);
        direction = dirDn;
      }
      // Fade up
      else {
        led.fade(minLight, fadeTime);
        direction = dirUp;
      }
    }
  }
}

/*
  // "Breathing LED" function without use of library.
  void idleLED1() {
  unsigned long fadeTimer = millis();
  int val = 128 + 127 * cos(2 * PI / fadeTime * fadeTimer);
  analogWrite(led2, val);
  }
*/


/* ** FRS Added 21.5.2020
   btnLEDs(25, 20);   // P1 button LED = 25, Manual button LED = 20 (Run Mode)
   btnLEDs(45, 25);   // P1 button LED = 45, Manual button LED = 25 (Idle Mode)
   btnLEDs(6, 5);   // P1 button LED = 6, Manual button LED = 5 (Sleep Mode)
*/

void btnLEDs(long L2B, long L3B) {

  analogWrite(led2, L2B);    //
  analogWrite(led3, L3B);
}

void statusLED(int ledState) {

  if (ledState == 1) {
    analogWrite(led1, 255);
    btnLEDs(25, 20);   // P1 button LED = 25, Manual button LED = 20 (Run Mode)

  } else if (ledState == 0) {
    analogWrite(led1, 0);

  } else if (ledState == 3) {
    idleLED();
  }
}

// Sleep LED - Heartbeat Flashing.
void sleepLED() {

  static int OffTime = 2000; // Update time in ms
  static int OnTime = 25;    // Update time in ms
  static double lastUpdateTime;

  if (millis() >= (lastUpdateTime + OffTime + OnTime)) {
    analogWrite(led1, 0);
    btnLEDs(0, 0);   // Turns off button LEDs (Sleep Mode)
    lastUpdateTime = millis();
  } else if (millis() >= (lastUpdateTime + OffTime)) {
    analogWrite(led1, 25);
  }
}

// LED flasher function. fl = No of flashes, rt = rate.
void flashLED(int fl, int rt) {

  for (int i = 0; i < fl; i++) {
    analogWrite(led1, 0);
    delay(rt);
    analogWrite(led1, 255);
    delay(rt);
    analogWrite(led1, 0);
  }
}
