/**
   Program Initialisation Functions
*/

void Init() {

  /*------------------- Display Start Functions ------------------ */

  /* Uncomment for 16x2 LCD Display */
  //lcd.begin(16, 2);       // Specifies the dimensions of the LCD to be used.
  //lcd.setBacklight(1);    // Turns on backlight 0 is off, however value of 0-255 on supported LCDs.
  //lcd.clear();

  /* Uncomment for 128x64 OLED display */
  u8g2.setBusClock(600000); // Bus Clock Speed override; For I2C; 400000 ~ 800000  For SPI; 80000000
  u8g2.begin();
  u8g2.setContrast(255);

  /* Uncomment for 16x2 OLED Newhaven display */
  //Wire.begin(); // initialize i2c
  //oled.begin(); // initialize the oled

  /* Uncomment for Newhaven NHD-0216AW-IB3 16x2 OLED */
  //mydisp.begin();
  //mydisp.clearScreen();


  /* --------- Start-up Screen ------------
     Feature added FRS 14.3.2020 *
  */

  if (startMsg = EEPROM.read(2)) {
    if (startMsg == 1) {

      // lcdTextLogo(); // LCD Text Logo
      // Uncomment for digole Display
      drawLogo();       // Graphic Logo

      // OLED Display - Added FRS 22.4.2020
      
      // Uncomment for u8g2 / SSD1306 / SH1106 OLED
      u8g2.firstPage();
      do {
        //drawTextLogo(); // Text Logo
        drawLogo();       // Graphic Logo
      } while ( u8g2.nextPage() );

      delay(4000);       // Display Boot Message for set time 1000 = 1.0 sec
      //lcd.clear();
      //mydisp.clearScreen(); // Uncomment when using digole Display
    }
  }
  
  // Initialise LED Fades
  led = LEDFader(led1);   
  ledW = LEDFader(led2);  
  ledR = LEDFader(led3);
  initLED();

  // Read saved values from EEPROM
  sniffPresets();

  // Display Preset 1 as default
  presetOneDisplay();

  /* 15.5.2020 FRS:  Resets grinderRuntime variables to 0 after display
     is initialised.
  */
  grinderRunTime1 = 0;
  grinderRunTime2 = 0;

  // Prints build details to serial monitor.
  printInfo();
}
