/**
    Encoder Control Routine
    Written by Flavio Spedalieri
    Date: 18/3/2020
    Project: Coffee Grinder Timer
*/

/*---------- Main Encoder Routine ----------------- */
long readEncoderPos() {
  static int oldPreset = EEPROM.read(0);
  unsigned long newPreset = myEnc.read() / encoderScaler;

  if (newPreset != oldPreset) {
    oldPreset = newPreset;
  }
  return oldPreset;
}


/* ------------ ** FRS 19.3.2020 ** --------------- */
/**
   Added functionality: Ability to adjust time on-the-fly in normal mode (preset offset).
   When encoder is turned to reduce time, <OFFSET is displayed to indicate shorter time than preset.
   When encoder is turned to increase time, OFFSET> is displayed to indicate longer time than preset.
   When encoder is returned to time equal to preset, PRESET is displayed.
   Pressing the encoder button will enter programming mode and store the offset value as new preset.
   Press the program button to exit offset (Added 20.3.2020, FRS)
*/

void timerOffset() {

  // Exit without saving
  exitOffset();

  /* ---------- Encoder Routine for Offset / Preset 1 --------------------------------*/

  if ((displayState == 0) && (selectState == 0) && (timerState == 0)) {

    runTime1Display = runTime1Display;
    unsigned long ps_offset1 = myEnc.read() / encoderScaler;

    if (ps_offset1 != grinderRunTime1) {
      grinderRunTime1 = ps_offset1;
      activeMode(); // Wake up from sleep mode when encoder is operated.
      //x = 0;

      // Limit the encoder value to 0.1 sec to 25.5 sec
      runTime1 = constrain(grinderRunTime1, 1, 255);

      // Display status based on encoder position.
      if (ps_offset1 < presetOneVal) {
        offsetState = 1;
        //runTime1Display = encDsp1602[0];  // Uncomment when using 16x2 character Display
        runTime1Display = encDspOLED[0];    // Uncomment when using 128x64 OLED Display
      }

      if (ps_offset1 == presetOneVal) {
        offsetState = 0;
        //runTime1Display = encDsp1602[1];  // Uncomment when using 16x2 character Display
        runTime1Display = encDspOLED[1];    // Uncomment when using 128x64 OLED Display;
      }

      if (ps_offset1 > presetOneVal) {
        offsetState = 1;
        //runTime1Display = encDsp1602[2];  // Uncomment when using 16x2 character Display
        runTime1Display = encDspOLED[2];    // Uncomment when using 128x64 OLED Display
      }
      /* 14.5.2020 - FRS
         Updates display once.
         15.5.2020 - FRS
         Appears as this not required, revised method for "grinderRunTime2"
         variable setup in "setup()" loop
      */
      //while (x < 1) {
      //for (x = 0; x < 1; x++) {
      presetOneDisplay();
      //}
      //}
    }
  }

  /* ---------- Encoder Routine for Offset / Preset 2 --------------------------------*/

  if ((displayState == 1) && (selectState == 0) && (timerState == 0)) {

    String disp2 = runTime2Display;
    unsigned long ps_offset2 = myEnc.read() / encoderScaler;

    if (ps_offset2 != grinderRunTime2) {
      grinderRunTime2 = ps_offset2;
      activeMode(); // Wake up from sleep mode when encoder is operated.
      //x = 0;

      // Limit the encoder value to 0.1 sec to 25.5 sec
      runTime2 = constrain(grinderRunTime2, 1, 255);

      // Display status based on encoder position.
      if (ps_offset2 < presetTwoVal) {
        offsetState = 1;
        //runTime2Display = encDsp1602[3];  // Uncomment when using 16x2 character Display
        runTime2Display = encDspOLED[3];    // Uncomment when using 128x64 OLED Display
      }

      if (ps_offset2 == presetTwoVal) {
        offsetState = 0;
        //runTime2Display = encDsp1602[4];  // Uncomment when using 16x2 character Display
        runTime2Display = encDspOLED[4];    // Uncomment when using 128x64 OLED Display
      }

      if (ps_offset2 > presetTwoVal) {
        offsetState = 1;
        //runTime2Display = encDsp1602[5];  // Uncomment when using 16x2 character Display
        runTime2Display = encDspOLED[5];    // Uncomment when using 128x64 OLED Display
      }
      /* 14.5.2020 - FRS
         Updates display once.
         15.5.2020 - FRS
         Appears as this not required, revised method for "grinderRunTime2"
         variable setup in "setup()" loop
      */
      //while (x < 1) {
      //for (x = 0; x < 1; x++) {
      presetTwoDisplay();
      //}
      //}
    }
  }

} // End timerOffset()
