//--- THIS TOOL ONLY FOR DIGOLE SERIAL COLOR OLED MODULE!

/* Design welcome screen and Micro Commands for Digole Serial Color OLED/LCD modules
  This module use different way to show welcome screen, other than previouse module which only display bitmap,
  this module can use any internal commands designed for it when display welcome screen. The size of welcome
  screen still only have 1920 bytes, we used this technical to do this, the data structure of welcome screen is:
  first 2 bytes are the rest of data in welcome screen, as integer, 1st is low byte, 2nd is high byte
  the rest of data are welcome screen commands, so the total size of welcome screen is: size in bytes of commands+2
  We have some tools to help you design welcome screen and Micro Commands set, the steps are:
  1) design characters which you want to display, you can send the color, font size, display position
  2) if you want to draw circle, rectangle, pie, lines, please add the correspond commands
  3) if you want to display picture, please use our picture to C data tool to convert your picture data:
     www.digole.com/tools/PicturetoC_Hex_converter.php
  4) add corresponds display picture command and add picture data follow by the commands, there are 3 commands for this module:
     "DIM", "EDIM1", "EDIM3", for more detail of these commands, please refer to program manual
  5) put all commands and data together, then use www.digole.com/tools/Convert_C_Format_String_to_Array.php tool to convert the
     data to array, WHY? because Arduino can't accept long string variable, but accept long array
  6) put the converted array data in wel[] variable, then run this program, this program will display your welcome screen first,
     then downloading it to the Flash memory in module, SUGGESTION: just download finished welcome screen, so, on testing period,
     please comment all downloading routing.
   After you downloaded the welcome screen or micro commands set, you don't need to do it in the program of production, it will save
   lot of memory space in the production's software.

   SAMPLE: digole's welcome screen commands set:
    "CLSF\x78 SC\xf1 ETP\x22\x29 TTWelcome\x00 SF\x0a SC\x13 TRT TRT ETP\x08\x3fTTDigole Digital Solutions\x00SC\x1f SF\x01 TRT
  TTYou will find it's so easy to use and fun:\x00SC\xE0TTwww.Digole.com\rEDIM1\x00\x10\x1e\x1e....(logo data)", which converted to array bellow
*/
#define Ver 33  //if firmware version is V2.9 and early, use welOld[] format, if V3.0~3.2 use welNew, if V3.3 and newer, use wel33
#define _Digole_Serial_UART_  //To tell compiler compile the special communication only, 
//all available are:_Digole_Serial_UART_, _Digole_Serial_I2C_ and _Digole_Serial_SPI_
#define _DOWNLOAD_WELCOME_ //force to download welcome screen to module
#define _MONO_
//#define _NO_WELCOME_ //if you want to erase the welcome screen data, use this
//#define _DOWNLOAD_MICRO_COMMANDS_;

#include <DigoleSerial.h>
//--------UART setup
#if defined(_Digole_Serial_UART_)
DigoleSerialDisp mydisp(&Serial, 9600); //UART:Arduino UNO: Pin 1(TX)on arduino to RX on module
#endif
//--------I2C setup
#if defined(_Digole_Serial_I2C_)
#include <Wire.h>
DigoleSerialDisp mydisp(&Wire, '\x27'); //I2C:Arduino UNO: SDA (data line) is on analog input pin 4, and SCL (clock line) is on analog input pin 5 on UNO and Duemilanove
#endif
//--------SPI setup
#if defined(_Digole_Serial_SPI_)
DigoleSerialDisp mydisp(8, 9, 10); //SPI:Pin 8: data, 9:clock, 10: SS, you can assign 255 to SS, and hard ground SS pin on module
#endif
//for old version of firmware <V2.9
const unsigned char welOld[] PROGMEM = {
  40, 4,
  67, 76, 13, 10, 69, 68, 73, 77, 49, 0, 16, 30, 30, 0, 0, 0, 0, 0, 0, 0, 0, 217, 180, 181, 0, 0, 0, 74, 2, 75, 75, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218,
  181, 217, 181, 181, 0, 0, 74, 38, 2, 1, 1, 41, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 254, 254, 177, 145, 0, 0, 74, 2, 111, 147, 73, 5, 1, 1, 110, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 181, 217, 181, 145, 0, 0, 74, 38, 0, 0, 0, 0, 78, 37, 1, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183, 146, 0, 0, 145, 145, 104, 0, 0, 0, 74, 38, 0, 0,
  0, 0, 0, 0, 74, 1, 37, 183, 0, 0, 0, 0, 0, 0, 0, 183, 73, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 110, 37, 37, 0, 0, 0, 0, 0, 0, 0, 74, 1, 110, 0, 0,
  0, 0, 0, 0, 0, 0, 74, 74, 0, 0, 0, 0, 0, 0, 0, 0, 110, 1, 37, 0, 0, 0, 0, 0, 110, 1, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 1, 110,
  0, 0, 0, 0, 37, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 37, 0, 0, 0, 110, 37, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 70, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 110, 1, 110, 0, 0, 74, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 69, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 37, 0, 111, 37, 74, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 74, 69, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 1, 0, 42, 6, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 146,
  1, 74, 38, 2, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 37, 37, 6, 6, 151, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 5, 6, 39, 2, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 1, 38, 38, 38, 115, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 1, 37, 75, 1, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147,
  37, 37, 111, 1, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 1, 0, 0, 37, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 37, 0, 0, 110, 37, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 37, 110, 0, 0, 0, 1, 37, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69, 0, 0, 0, 0, 0, 110, 1, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 33, 110,
  0, 0, 0, 0, 0, 69, 0, 110, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 142, 33, 73, 0, 0, 0, 0, 0, 0, 0, 37, 0, 146, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0,
  0, 0, 0, 0, 0, 146, 32, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 0, 110, 0, 0, 0, 0, 0, 0, 74, 70, 0, 0, 0, 117, 81, 154, 0, 0, 73, 179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 0,
  69, 74, 0, 0, 0, 0, 70, 38, 0, 0, 149, 153, 121, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 142, 37, 37, 37, 73, 146, 147, 74, 74, 0, 0, 149, 121, 121, 48, 4, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 37, 1, 33, 1, 70, 37, 0, 0, 117, 85, 84, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 74, 38, 1, 74, 0, 0,
  4, 12, 12, 117, 0, 0, 0, 0, 0, 0, 0, 0, 13, 10, 83, 70, 120, 32, 83, 67, 241, 32, 69, 84, 80, 34, 41, 32, 84, 84, 87, 101, 108, 99, 111, 109, 101, 13, 32, 83, 70, 10, 32, 83, 67, 19, 32, 84, 82, 84,
  32, 84, 82, 84, 32, 69, 84, 80, 8, 63, 84, 84, 68, 105, 103, 111, 108, 101, 32, 68, 105, 103, 105, 116, 97, 108, 32, 83, 111, 108, 117, 116, 105, 111, 110, 115, 13, 83, 67, 31, 32, 83, 70, 1, 32, 84, 82, 84, 84, 84,
  89, 111, 117, 32, 119, 105, 108, 108, 32, 102, 105, 110, 100, 32, 105, 116, 39, 115, 32, 115, 111, 32, 101, 97, 115, 121, 32, 116, 111, 32, 117, 115, 101, 32, 97, 110, 100, 32, 102, 117, 110, 58, 13, 83, 67, 224, 84, 84, 119, 119,
  119, 46, 68, 105, 103, 111, 108, 101, 46, 99, 111, 109, 13
};
//for new version of firmware V2.9 and later, the first 2 bytes which indicate the length of data is MSB the LSB now
const unsigned char welNew[] PROGMEM = {
  4, 40,
  67, 76, 13, 10, 69, 68, 73, 77, 49, 0, 16, 30, 30, 0, 0, 0, 0, 0, 0, 0, 0, 217, 180, 181, 0, 0, 0, 74, 2, 75, 75, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218,
  181, 217, 181, 181, 0, 0, 74, 38, 2, 1, 1, 41, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 254, 254, 177, 145, 0, 0, 74, 2, 111, 147, 73, 5, 1, 1, 110, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 181, 217, 181, 145, 0, 0, 74, 38, 0, 0, 0, 0, 78, 37, 1, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183, 146, 0, 0, 145, 145, 104, 0, 0, 0, 74, 38, 0, 0,
  0, 0, 0, 0, 74, 1, 37, 183, 0, 0, 0, 0, 0, 0, 0, 183, 73, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 110, 37, 37, 0, 0, 0, 0, 0, 0, 0, 74, 1, 110, 0, 0,
  0, 0, 0, 0, 0, 0, 74, 74, 0, 0, 0, 0, 0, 0, 0, 0, 110, 1, 37, 0, 0, 0, 0, 0, 110, 1, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 1, 110,
  0, 0, 0, 0, 37, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 37, 0, 0, 0, 110, 37, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 70, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 110, 1, 110, 0, 0, 74, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 69, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 37, 0, 111, 37, 74, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 74, 69, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 1, 0, 42, 6, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 146,
  1, 74, 38, 2, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 37, 37, 6, 6, 151, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 5, 6, 39, 2, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 1, 38, 38, 38, 115, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 1, 37, 75, 1, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147,
  37, 37, 111, 1, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 1, 0, 0, 37, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 37, 0, 0, 110, 37, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 37, 110, 0, 0, 0, 1, 37, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69, 0, 0, 0, 0, 0, 110, 1, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 33, 110,
  0, 0, 0, 0, 0, 69, 0, 110, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 142, 33, 73, 0, 0, 0, 0, 0, 0, 0, 37, 0, 146, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0,
  0, 0, 0, 0, 0, 146, 32, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 0, 110, 0, 0, 0, 0, 0, 0, 74, 70, 0, 0, 0, 117, 81, 154, 0, 0, 73, 179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 0,
  69, 74, 0, 0, 0, 0, 70, 38, 0, 0, 149, 153, 121, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 142, 37, 37, 37, 73, 146, 147, 74, 74, 0, 0, 149, 121, 121, 48, 4, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 37, 1, 33, 1, 70, 37, 0, 0, 117, 85, 84, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 74, 38, 1, 74, 0, 0,
  4, 12, 12, 117, 0, 0, 0, 0, 0, 0, 0, 0, 13, 10, 83, 70, 120, 32, 83, 67, 241, 32, 69, 84, 80, 34, 41, 32, 84, 84, 87, 101, 108, 99, 111, 109, 101, 0, 32, 83, 70, 10, 32, 83, 67, 19, 32, 84, 82, 84,
  32, 84, 82, 84, 32, 69, 84, 80, 8, 63, 84, 84, 68, 105, 103, 111, 108, 101, 32, 68, 105, 103, 105, 116, 97, 108, 32, 83, 111, 108, 117, 116, 105, 111, 110, 115, 0, 83, 67, 31, 32, 83, 70, 1, 32, 84, 82, 84, 84, 84,
  89, 111, 117, 32, 119, 105, 108, 108, 32, 102, 105, 110, 100, 32, 105, 116, 39, 115, 32, 115, 111, 32, 101, 97, 115, 121, 32, 116, 111, 32, 117, 115, 101, 32, 97, 110, 100, 32, 102, 117, 110, 58, 0, 83, 67, 224, 84, 84, 119, 119,
  119, 46, 68, 105, 103, 111, 108, 101, 46, 99, 111, 109, 0
};
const unsigned char wel33[] PROGMEM = {
         67, 76, 71, 80, 0, 16, 69, 68, 73, 77, 49, 30, 30, 0, 0, 0, 0, 0, 0, 0, 0, 217, 180, 181, 0, 0, 0, 74, 2, 75, 75, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218,
        181, 217, 181, 181, 0, 0, 74, 38, 2, 1, 1, 41, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 254, 254, 177, 145, 0, 0, 74, 2, 111, 147, 73, 5, 1, 1, 110, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 181, 217, 181, 145, 0, 0, 74, 38, 0, 0, 0, 0, 78, 37, 1, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183, 146, 0, 0, 145, 145, 104, 0, 0, 0, 74, 38, 0, 0,
        0, 0, 0, 0, 74, 1, 37, 183, 0, 0, 0, 0, 0, 0, 0, 183, 73, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 110, 37, 37, 0, 0, 0, 0, 0, 0, 0, 74, 1, 110, 0, 0,
        0, 0, 0, 0, 0, 0, 74, 74, 0, 0, 0, 0, 0, 0, 0, 0, 110, 1, 37, 0, 0, 0, 0, 0, 110, 1, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 1, 110,
        0, 0, 0, 0, 37, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 37, 0, 0, 0, 110, 37, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 70, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 110, 1, 110, 0, 0, 74, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 69, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 37, 0, 111, 37, 74, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 74, 69, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 1, 0, 42, 6, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 146,
        1, 74, 38, 2, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 37, 37, 6, 6, 151, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 5, 6, 39, 2, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 1, 38, 38, 38, 115, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 1, 37, 75, 1, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147,
        37, 37, 111, 1, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 1, 0, 0, 37, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 37, 0, 0, 110, 37, 110, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 37, 110, 0, 0, 0, 1, 37, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69, 0, 0, 0, 0, 0, 110, 1, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 33, 110,
        0, 0, 0, 0, 0, 69, 0, 110, 0, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0, 0, 0, 0, 0, 0, 0, 142, 33, 73, 0, 0, 0, 0, 0, 0, 0, 37, 0, 146, 0, 0, 0, 0, 0, 0, 0, 74, 38, 0, 0,
        0, 0, 0, 0, 0, 146, 32, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 0, 110, 0, 0, 0, 0, 0, 0, 74, 70, 0, 0, 0, 117, 81, 154, 0, 0, 73, 179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 0,
        69, 74, 0, 0, 0, 0, 70, 38, 0, 0, 149, 153, 121, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 142, 37, 37, 37, 73, 146, 147, 74, 74, 0, 0, 149, 121, 121, 48, 4, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 37, 1, 33, 1, 70, 37, 0, 0, 117, 85, 84, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 74, 38, 1, 74, 0, 0,
        4, 12, 12, 117, 0, 0, 0, 0, 0, 0, 0, 0, 13, 10, 83, 70, 120, 32, 83, 67, 241, 32, 69, 84, 80, 34, 41, 32, 84, 84, 87, 101, 108, 99, 111, 109, 101, 0, 32, 83, 70, 10, 32, 83, 67, 19, 32, 84, 82, 84,
        32, 84, 82, 84, 32, 69, 84, 80, 8, 63, 84, 84, 68, 105, 103, 111, 108, 101, 32, 68, 105, 103, 105, 116, 97, 108, 32, 83, 111, 108, 117, 116, 105, 111, 110, 115, 0, 83, 67, 31, 32, 83, 70, 1, 32, 84, 82, 84, 84, 84,
        89, 111, 117, 32, 119, 105, 108, 108, 32, 102, 105, 110, 100, 32, 105, 116, 39, 115, 32, 115, 111, 32, 101, 97, 115, 121, 32, 116, 111, 32, 117, 115, 101, 32, 97, 110, 100, 32, 102, 117, 110, 58, 0, 83, 67, 224, 84, 84, 119, 119,
        119, 46, 68, 105, 103, 111, 108, 101, 46, 99, 111, 109, 0, 255
};
const unsigned char wel33_mono[] PROGMEM = {
         'C', 'L', //clear screen
         'G', 'P', 0, 0,  //set display position at 0,0
         'D', 'I', 'M', 128, 64,  //draw a 128x64 mono image, following is 128x64 standard image data, can be used on any Digole serial modules
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,15,28,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,15,28,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,55,28,127,248,0,0,0,0,0,0
,0,0,0,0,0,1,251,56,255,254,0,0,0,0,0,0
,0,0,0,0,0,3,251,240,255,249,128,0,0,0,0,0
,0,0,0,0,0,7,131,224,31,239,192,0,0,0,0,0
,0,0,0,0,0,15,97,206,0,103,224,0,0,0,0,0
,0,0,0,0,0,31,113,204,196,63,224,0,0,0,0,0
,0,0,0,0,0,31,121,137,206,3,240,0,0,0,0,0
,0,0,0,0,0,24,121,143,142,113,240,0,0,0,0,0
,0,0,0,0,0,27,57,223,28,241,240,0,0,0,0,0
,0,0,0,0,0,27,57,254,29,243,240,0,0,0,0,0
,0,0,0,0,0,25,185,249,159,227,48,0,0,0,0,0
,0,0,0,0,0,28,249,251,159,143,48,0,0,0,0,0
,0,0,0,0,0,31,121,254,60,31,240,0,0,0,0,0
,0,0,0,0,0,31,191,248,48,249,240,0,0,0,0,0
,0,0,0,0,0,31,191,224,243,224,112,0,0,0,0,0
,0,0,0,0,0,31,223,193,227,222,48,0,0,0,0,0
,0,0,0,0,0,31,223,227,226,62,48,0,0,0,0,0
,0,0,0,0,0,31,231,243,193,252,112,0,0,0,0,0
,0,0,0,0,0,31,241,255,135,240,240,0,0,0,0,0
,0,0,0,0,0,31,48,254,23,128,48,0,0,0,0,0
,0,0,0,0,0,31,238,126,55,1,16,0,0,0,0,0
,0,0,0,0,0,31,238,62,55,15,128,0,0,0,0,0
,0,0,0,0,0,31,247,62,47,255,128,0,0,0,0,0
,0,0,0,0,0,31,251,254,31,254,16,0,0,0,0,0
,0,0,0,0,0,28,252,254,63,240,112,0,0,0,0,0
,0,0,0,0,0,24,254,127,254,1,224,0,0,0,0,0
,0,0,0,0,0,15,255,191,248,63,224,0,0,0,0,0
,0,0,0,0,0,7,255,191,241,255,192,0,0,0,0,0
,0,0,0,0,0,3,255,127,243,255,128,0,0,0,0,0
,0,0,0,0,0,1,255,127,227,254,0,0,0,0,0,0
,0,0,0,0,0,0,62,127,135,240,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,126,3,231,224,31,0,248,7,240,62,248,249,240,7,192
,3,255,135,255,240,255,195,252,31,248,255,249,255,248,63,240
,15,255,199,255,241,255,231,252,127,249,255,249,255,252,127,248
,31,135,231,225,243,241,231,132,126,3,241,241,248,124,252,120
,31,3,231,193,243,227,231,192,252,3,224,241,240,124,248,248
,31,3,231,193,243,255,231,240,248,7,225,241,240,125,255,248
,31,3,231,193,247,255,195,252,248,7,225,243,240,125,255,240
,31,3,239,193,243,252,0,252,248,7,225,243,240,125,255,0
,31,135,207,193,243,224,32,124,252,19,225,243,240,248,248,8
,15,255,143,195,225,255,231,252,127,243,255,243,255,248,127,248
,7,255,15,131,224,255,231,248,63,241,255,243,255,240,63,248
,1,252,14,3,128,63,135,224,15,224,124,195,231,192,15,224
,0,0,0,0,0,0,0,0,0,0,0,3,224,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,3,224,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,3,224,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,7,224,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
'S','C',1,  //set color white
'T', 'P', 0, 0,  //set text position at 0,0
        255,255 //255 is indicate of ending this command set
};
const unsigned char Nowelcom[] PROGMEM = {0, 0, 255};



void setup() {
  mydisp.begin();
  mydisp.displayConfig(1);
//  while(1);
  mydisp.clearScreen(); //CLear screen
  mydisp.setColor(1);
#if (Ver<33)
  for (int j = 2; j < sizeof(welNew); j++) {
    mydisp.write(pgm_read_byte_near(welNew + j));
  }
  mydisp.write(0);
  mydisp.write(0);
  delay(2000);
#endif
  //--- start downloading welcome screen to module, comment when testing
#if defined(_DOWNLOAD_WELCOME_)
#if defined(_NO_WELCOME_)
  mydisp.downloadStartScreen(sizeof(Nowelcom), Nowelcom);
#else
#if (Ver<30)
  mydisp.dowmloadStartScreen(sizeof(welOld), welOld);
#elif (Ver>29)&&(Ver<33)
  mydisp.downloadStartScreen(sizeof(welNew), welNew);
#else
#ifdef _MONO_
  mydisp.downloadStartScreen(sizeof(wel33_mono), wel33_mono);
#else
  mydisp.downloadStartScreen(sizeof(wel33), wel33);
  #endif
#endif
#endif
#endif
#if defined(_DOWNLOAD_MICRO_COMMANDS_)
  //--- start downloading welcome screen to module, comment when testing
  //  mydisp.uploadStartScreen(sizeof(wel),wel);
  //end downloading
#endif
//  mydisp.setColor(1);
  mydisp.displayStartScreen(1);
  mydisp.print("Done");
}
void loop() {
}


