/********************************************************
   FRS 17.5.2020 - 
    Implementation for Digole DS12864OLED-2W OLED.
    Addition of Clock Icon.
    Consolidation of "drawRunTimer()" function.

   ------------ Digole Display Fonts ----------------
   
   The display has 7 pre-installed fonts on display MCU.
   0    (default): u8g_font_unifont
   6:   u8g_font_4x6
   10:  u8g_font_6x10
   18:  u8g_font_9x18B
   51:  u8g_font_osr18
   120: u8g_font_gdr20
   123: u8g_font_osr35n

   The display also has 4 user allocations

   200: u8g_font_timR18
   201: u8g_font_ncenR12
   202: u8g_font_ncenR10
   203: u8g_font_helvR08
   ---------------------------------------------------

   FRS 29.4.2020 -
    Implemented screen power save mode for OLED Display.
    
**********************************************************/

/* Enable function for character displays
 
  void lcdTextLogo() {
  
  lcd.setBacklight(1);
  lcd.setCursor(3, 0);
  lcd.print(F("COMPAK  K6"));
  lcd.setCursor(1, 1);
  lcd.print(F("COFFEE GRINDER"));

  // For use with Newhaven Display
  //oled.cursorMove(1, 4);
  //oled.print(F("COMPAK  K6"));
  //oled.cursorMove(2, 2);
  //oled.print(F("COFFEE GRINDER"));
  }
*/

// Uncomment when using u8g2 / SSD1306 / SH1106
void drawTextLogo() {
  u8g2.setFont(u8g2_font_ncenR10_tr);
  u8g2.setCursor(15, 20);
  u8g2.print(F("COMPAK  K6"));
  u8g2.setCursor(5, 50);
  u8g2.print(F("CAFE GRINDER"));
}



void clockIcon() {

  // Render clock dial icon
  
  // Uncommend for SSD1306 / SH1106 Display
  u8g2.drawCircle(10, 40, 10, U8G2_DRAW_ALL); // (x,Y,Radus, U8G2_DRAW_ALL)
  u8g2.drawCircle(10, 40, 9, U8G2_DRAW_ALL);
  u8g2.drawCircle(10, 40, 1, U8G2_DRAW_ALL);
  //clock hands
  u8g2.drawLine(10, 42, 10, 33); // (x1,y1),(x2,y2)
  u8g2.drawLine(10, 40, 14, 44);

  // Uncomment for Digole Display
  /*
  mydisp.drawCircle(10, 40, 10, 0); // (x,Y,Radus,fill(1) no fill(0))
  mydisp.drawCircle(10, 40, 9, 0);
  mydisp.drawCircle(10, 40, 1, 0);
  //clock hands
  mydisp.drawLine(10, 42, 10, 33); // (x1,y1),(x2,y2)
  mydisp.drawLine(10, 40, 14, 44);
  */
}

void drawLogo(void) {

  // Uncomment for u8g2 / SSD1306/ SH1106 OLED
  u8g2.drawXBMP(32, 3, romeo_logo_width, romeo_logo_height, romeo_bits);

  // Uncomment for digole Display
  //mydisp.drawBitmap(32, 3, romeo_logo_width, romeo_logo_height, romeo_bits);
}

/* // uncommend when using 16x2 LCD / OLED
  String runTime1Display = "DOSE:  PRESET  1";
  String runTime1Display = "DOSE:  PRESET  2";
*/

// uncomment when using 128x64 OLED
// Note: Additional spaces at end as "clear padding" for Digole Display.
String runTime1Display = "Dose:  Preset  1  ";  // Additional 2 space at end for Digole Display
String runTime2Display = "Dose:  Preset  2   "; // Additional 3 space at end for Digole Display

/* Array for 16x2 display. */
//String encDsp1602[6] = {"DOSE: <OFFSET  1", runTime1Display, "DOSE:  OFFSET> 1", "DOSE: <OFFSET  2", runTime2Display, "DOSE:  OFFSET> 2"};

/* Array for 128x64 OLED */
String encDspOLED[6] = {"Dose: < Offset  1", runTime1Display, "Dose:  Offset > 1", "Dose: < Offset  2", runTime2Display, "Dose:  Offset > 2"};

/*------------- Display Dose Preset 1 Time on Screen ---------------------------*/
void presetOneDisplay() {
  /*
    lcd.setCursor(0, 0);                     // ** FRS 19.2.2020 - Set by encoder.
    lcd.print(runTime1Display);
    lcd.setCursor(0, 1);
    lcd.print(F("TIME:  "));
    lcd.print(grinderRunTime1 / 10.0);       // ** FRS 19.2.2020 - Set by encoder.
    lcd.print(F(" Sec "));

    // For use with Newhaven Display
    //oled.cursorMove(1, 1);                     // ** FRS 19.2.2020 - Set by encoder.
    //oled.print(runTime1Display);
    //oled.cursorMove(2, 1);
    //oled.print(F("TIME:  "));
    //oled.print(grinderRunTime1 / 10.0);       // ** FRS 19.2.2020 - Set by encoder.
    //oled.print(F(" Sec "));
  */
  u8g2.firstPage();
  do {
    u8g2.setFont(u8g2_font_ncenR12_tr);
    u8g2.setCursor(0, 12);
    u8g2.print(runTime1Display);
    u8g2.drawLine(0, 20, 128, 20); // start{x, y}, finish{x, y}
    clockIcon();
    u8g2.setCursor(30, 50);
    u8g2.setFont(u8g2_font_timR18_tr);
    u8g2.print(grinderRunTime1 / 10.0);       // ** FRS 19.2.2020 - Set by encoder.
    u8g2.print(F(" Sec "));
    u8g2.drawLine(0, 62, 128, 62); // start{x, y}, finish{x, y}
  } while ( u8g2.nextPage() );
/*
   Uncomment when using Digole Display
  delay(82);
  mydisp.setFont(201);
  mydisp.setTextPosAbs(0, 12);
  mydisp.print(runTime1Display);
  mydisp.drawLine(0, 20, 128, 20); // start{x, y}, finish{x, y}
  clockIcon(); // Clock Graphic
  mydisp.setTextPosAbs(30, 50);
  mydisp.setFont(200);
  mydisp.print(grinderRunTime1 / 10.0);       // ** FRS 19.2.2020 - Set by encoder.
  
  // Required for Digole Display: Adds or remove proceeding space and clear the end character. 
  if (grinderRunTime1 / 10.0 <= 9.99) {
    mydisp.print(F(" Sec  "));
  }
  if (grinderRunTime1 / 10.0 > 9.99) {
    mydisp.print(F(" Sec "));
  }
    mydisp.drawLine(0, 62, 128, 62); // start{x, y}, finish{x, y}
  
 */ 
}

/*------------- Display Dose 1 Time Program on Screen ---------------------------*/
void presetOneSelect() {
  /*
    lcd.setCursor(0, 0);
    lcd.print(F("PROG <> PRESET 1"));
    lcd.setCursor(0, 1);
    lcd.print(F("TIME:  "));
    lcd.print(presetOneVal / 10.0);
    lcd.print(F(" Sec "));

    // For use with Newhaven Display
    //oled.cursorMove(1, 1);
    //oled.print(F("PROG <> PRESET 1"));
    //oled.cursorMove(2, 1);
    //oled.print(F("TIME:  "));
    //oled.print(presetOneVal / 10.0);
    //oled.print(F(" Sec "));
  */

  // Uncomment when using u8g2 / SSD1306 / SH1106
  u8g2.firstPage();
  do {
    u8g2.setFont(u8g2_font_ncenR12_tr);
    u8g2.setCursor(0, 12);
    u8g2.print(F("Prog <> Preset 1"));
    u8g2.drawLine(0, 20, 128, 20); // start{x, y}, finish{x, y}
    u8g2.setFont(u8g2_font_open_iconic_app_2x_t);
    clockIcon();
    u8g2.setCursor(30, 50);
    u8g2.setFont(u8g2_font_timR18_tr);
    u8g2.print(presetOneVal / 10.0);
    u8g2.print(F(" Sec "));
    u8g2.drawLine(0, 62, 128, 62); // start{x, y}, finish{x, y}
  } while ( u8g2.nextPage() );

  /*
  // Uncomment when using Digole Display
  delay(82); // !! Important: Refresh delay (82ms) for Digole Display. 
  mydisp.setFont(201);
  mydisp.setTextPosAbs(0, 12);
  mydisp.print(F("Prog <> Preset 1"));
  mydisp.drawLine(0, 20, 128, 20); // start{x, y}, finish{x, y}
  clockIcon();
  mydisp.setTextPosAbs(30, 50);
  mydisp.setFont(200);
  mydisp.print(presetOneVal / 10.0);
  
  //Required for Digole Display: Adds or remove proceeding space and clear the end character.
  if (presetOneVal / 10.0 <= 9.99) {
    mydisp.print(F(" Sec  "));
  }
  if (presetOneVal / 10.0 > 9.99) {
    mydisp.print(F(" Sec "));
  }
  */
}

/*------------- Display Dose Preset 2 Time on Screen ---------------------------*/
void presetTwoDisplay() {
  /*
    lcd.setCursor(0, 0);
    lcd.print(runTime2Display); // ** FRS 19.2.2020 - Set by encoder.
    lcd.setCursor(0, 1);
    lcd.print(F("TIME:  "));
    lcd.print(grinderRunTime2 / 10.0);  // ** FRS 19.2.2020 - Set by encoder.
    lcd.print(F(" Sec "));

    // For use with Newhaven Display
    //oled.cursorMove(1, 1);
    //oled.print(runTime2Display); // ** FRS 19.2.2020 - Set by encoder.
    //oled.cursorMove(2, 1);
    //oled.print(F("TIME:  "));
    //oled.print(grinderRunTime2 / 10.0);  // ** FRS 19.2.2020 - Set by encoder.
    //oled.print(F(" Sec "));
  */

  // Uncomment when using u8g2 / SSD1306 / SH1106
  u8g2.firstPage();
  do {
    u8g2.setFont(u8g2_font_ncenR12_tr);
    u8g2.setCursor(0, 12);
    u8g2.print(runTime2Display);
    u8g2.drawLine(0, 20, 128, 20);  // start{x, y}, finish{x, y}
    clockIcon();
    u8g2.setCursor(30, 50);
    u8g2.setFont(u8g2_font_timR18_tr);
    u8g2.print(grinderRunTime2 / 10.0); // ** FRS 19.2.2020 - Set by encoder.
    u8g2.print(F(" Sec "));
    u8g2.drawLine(0, 62, 128, 62); // start{x, y}, finish{x, y}
  } while ( u8g2.nextPage() );

/*
  // Uncomment when using Digole Display
  delay(82); // !! Important: Refresh delay (82ms) for Digole Display. 
  mydisp.setFont(201);
  mydisp.setTextPosAbs(0, 12);
  mydisp.print(runTime2Display);
  mydisp.drawLine(0, 20, 128, 20); // start{x, y}, finish{x, y}
  clockIcon();
  mydisp.setTextPosAbs(30, 50);
  mydisp.setFont(200);
  mydisp.print(grinderRunTime2 / 10.0);       // ** FRS 19.2.2020 - Set by encoder.
  
  //Required for Digole Display: Adds or remove proceeding space and clear the end character.
  if (grinderRunTime2 / 10.0 <= 9.99) {
    mydisp.print(F(" Sec  "));
  }
  if (grinderRunTime2 / 10.0 > 9.99) {
    mydisp.print(F(" Sec "));
  }
    mydisp.drawLine(0, 62, 128, 62); // start{x, y}, finish{x, y}
    
  */
}

/*------------- Display Dose 2 Time Program on Screen ---------------------------*/
void presetTwoSelect()  {
  /*
    lcd.setCursor(0, 0);
    lcd.print(F("PROG <> PRESET 2"));
    lcd.setCursor(0, 1);
    lcd.print(F("TIME:  "));
    lcd.print(presetTwoVal / 10.0);
    lcd.print(F(" Sec "));

    // For use with Newhaven Display
    oled.cursorMove(1, 1);
    oled.print(F("PROG <> PRESET 2"));
    oled.cursorMove(2, 1);
    oled.print(F("TIME:  "));
    oled.print(presetTwoVal / 10.0);
    oled.print(F(" Sec "));
  */
  
  // Uncomment when using u8g2 / SSD1306 / SH1106
  u8g2.firstPage();
  do {
    u8g2.setFont(u8g2_font_ncenR12_tr);
    u8g2.setCursor(0, 12);
    u8g2.print(F("Prog <> Preset 2"));
    u8g2.drawLine(0, 20, 128, 20); // start{x, y}, finish{x, y}
    clockIcon();
    u8g2.setCursor(30, 50);
    u8g2.setFont(u8g2_font_timR18_tr);
    u8g2.print(presetTwoVal / 10.0);
    u8g2.print(F(" Sec "));
    u8g2.drawLine(0, 62, 128, 62); // start{x, y}, finish{x, y}
  } while ( u8g2.nextPage() );

/*
  // Uncomment when using Digole Display
  delay(82); // !! Important: Refresh delay (82ms) for Digole Display. 
  mydisp.setFont(201);
  mydisp.setTextPosAbs(0, 12);
  mydisp.print(F("Prog <> Preset 2"));
  mydisp.drawLine(0, 20, 128, 20); // start{x, y}, finish{x, y}
  clockIcon();
  mydisp.setTextPosAbs(30, 50);
  mydisp.setFont(200);
  mydisp.print(presetTwoVal / 10.0);
  
  //Required for Digole Display: Adds or remove proceeding space and clear the end character.
  if (presetTwoVal / 10.0 <= 9.99) {
    mydisp.print(F(" Sec  "));
  }
  if (presetTwoVal / 10.0 > 9.99) {
    mydisp.print(F(" Sec "));
  }
*/

}

/*
  void print1602_T1L1() {
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print(F("DOSE 1 GRINDING"));
  lcd.setCursor(0, 1);
  lcd.print(F("TIME:  "));
  }

  void print1602_T2L1() {
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print(F("DOSE 2  GRINDING"));
  lcd.setCursor(0, 1);
  lcd.print(F("TIME:  "));
  }

  void print1602_L2() {
  lcd.setCursor(8, 1);
  lcd.print(sec);
  lcd.print(F("."));
  lcd.print(msec);
  if(msec <10){
    lcd.print("0");
  } 
  lcd.print(F(" Sec "));
  }
*/
/* // For use with Newhaven Display
void print1602_T1L1() {
  //oled.clear();
  oled.cursorMove(1, 1);
  oled.print(F("DOSE 1 GRINDING "));
  oled.cursorMove(2, 1);
  oled.print(F("TIME:  "));
}

void print1602_T2L1() {
  //oled.clear();
  oled.cursorMove(1, 1);
  oled.print(F("DOSE 2  GRINDING "));
  oled.cursorMove(2, 1);
  oled.print(F("TIME:  "));
}

void print1602_L2() {
  oled.cursorMove(2, 8);
  oled.print(sec);
  oled.print(F("."));
  oled.print(msec);
  if(msec <10){
    lcd.print("0");
  }
  oled.print(F(" Sec "));
}
*/

void drawRunTimer(String disp) {
  
    // Uncomment when using u8g2 / SSD1306 / SH1106
    u8g2.firstPage();
  do {
    u8g2.setFont(u8g2_font_ncenR12_tr);
    u8g2.setCursor(0, 12);
    u8g2.print(disp);
    u8g2.drawLine(0, 20, 128, 20); // start{x, y}, finish{x, y}
    clockIcon();
    u8g2.setCursor(30, 50);
    u8g2.setFont(u8g2_font_timR18_tr);
    u8g2.print(sec);
    u8g2.print(F("."));
    u8g2.print(msec);
    u8g2.print(F("0"));
    u8g2.print(F(" Sec "));
    u8g2.drawLine(0, 62, 128, 62); // start{x, y}, finish{x, y}
  } while ( u8g2.nextPage() );

/*
  // Uncomment when using Digole Display
  delay(82); // !! Important: Refresh delay (82ms) for Digole Display. 
  mydisp.setFont(201);
  mydisp.setTextPosAbs(0, 12);
  mydisp.print(disp);
  mydisp.drawLine(0, 20, 128, 20); // start{x, y}, finish{x, y}
  clockIcon();
  mydisp.setTextPosAbs(30, 50);
  mydisp.setFont(200);
  mydisp.print(sec);
  mydisp.print(F("."));
  mydisp.print(msec);
  if (msec < 10) {
    mydisp.print("0");
  }
  
  //Required for Digole Display: Adds or remove proceeding space and clear the end character. 
  if (sec <= 9.99) {
    mydisp.print(F(" Sec  "));
  }
  if (sec > 9.99) {
    mydisp.print(F(" Sec "));
  }
  */
}


void drawManualMode() {
  /*
    lcd.clear();
    lcd.setCursor(2, 0);
    lcd.print(F("MANUAL GRIND"));
    lcd.setCursor(0, 1);
    lcd.print(F("----------------"));

    // For use with Newhaven Display
    //oled.cursorMove(1, 1);
    //oled.print(F("  MANUAL GRIND  "));
    //oled.cursorMove(2, 1);
    //oled.print(("----------------"));
  */

  // Uncomment when using u8g2 / SSD1306 / SH1106
  u8g2.firstPage();
  do {
    u8g2.setFont(u8g2_font_ncenR18_tr);
    u8g2.setCursor(5, 25);
    u8g2.print(F("MANUAL"));
    u8g2.drawLine(0, 34, 128, 34); // start{x, y}, finish{x, y}
    u8g2.setCursor(19, 60);
    u8g2.print(F("GRIND"));
  } while ( u8g2.nextPage() );

  /*
  // Uncomment when using Digole Display
  mydisp.setFont(51);
  mydisp.setTextPosAbs(5, 25);
  mydisp.print(F("MANUAL"));
  mydisp.drawLine(0, 34, 128, 34); // start{x, y}, finish{x, y}
  mydisp.setTextPosAbs(20, 60);
  mydisp.print(F("GRIND"));
  */
}

void drawFirmware() {
  /*
    lcd.clear();
    lcd.setCursor(0, 0);
    lcd.print(F("FW Ver: "));
    lcd.setCursor(8, 0);
    lcd.print(fwVersion);
    lcd.setCursor(0, 1);
    lcd.print(F("Date: "));
    lcd.setCursor(6, 1);
    lcd.print(F(fwDate));

    // For use with Newhaven Display
    oled.cursorMove(1, 1);
    oled.print(F("FW Ver: "));
    oled.cursorMove(1, 9);
    oled.print(fwVersion);
    oled.cursorMove(2, 1);
    oled.print(F("Date: "));
    oled.cursorMove(2, 7);
    oled.print(fwDate);
  */

  // Uncomment when using u8g2 / SSD1306 / SH1106
  u8g2.firstPage();
  do {
    u8g2.setFont(u8g2_font_ncenR10_tr);
    u8g2.setCursor(0, 12);
    u8g2.print(F("F/W Ver: "));
    u8g2.print(fwVersion);
    u8g2.setCursor(0, 30);
    u8g2.print(F("Date: "));
    u8g2.print(fwDate);
    u8g2.setFont(u8g2_font_helvR08_tr);
    u8g2.setCursor(0, 55);
    u8g2.print(bc);
  } while ( u8g2.nextPage() );

  /*
  // Uncomment when using Digole Display
  mydisp.setFont(202);
  mydisp.setTextPosAbs(0, 12);
  mydisp.print(F("F/W Ver: "));
  mydisp.print(fwVersion);
  mydisp.setTextPosAbs(0, 30);
  mydisp.print(F("Date: "));
  mydisp.print(fwDate);
  mydisp.setFont(203);
  mydisp.setTextPosAbs(0, 55);
  mydisp.print(bc);
  */
}

/* ---- Start-up Display Function ----
   Feature added FRS 02.04.2020 *
*/
void setStartMsg() {
  /*
    lcd.clear();
    lcd.setCursor(1, 0);
    lcd.print(F("DISPLAY START:"));

    // For use with Newhaven Display
    //oled.clear();
    //oled.cursorMove(1, 2);
    //oled.print(F("DISPLAY START:"));
  */
  if (startMsg == 1) {
    /*
      lcd.setCursor(5, 1);
      lcd.print(F("ENABLED"));

      // For use with Newhaven Display
      //oled.cursorMove(2, 6);
      //oled.print(F("ENABLED"));
    */
    // Uncomment when using u8g2 / SSD1306 / SH1106
    u8g2.firstPage();
    do {
      u8g2.setFont(u8g2_font_ncenR12_tr);
      u8g2.setCursor(0, 12);
      u8g2.print(F("Display Logo:"));
      u8g2.setCursor(25, 40);
      u8g2.print(F("ENABLED"));
    } while ( u8g2.nextPage() );

    /*
    // Uncomment when using Digole Display
    mydisp.setFont(201);
    mydisp.setTextPosAbs(0, 12);
    mydisp.print(F("Display Logo:"));
    mydisp.setTextPosAbs(25, 40);
    mydisp.print(F("ENABLED"));
    */

  } else if (startMsg == 0) {
    /*
      lcd.setCursor(4, 1);
      lcd.print(F("DISABLED"));
      
      // For use with Newhaven Display
      //oled.cursorMove(2, 6);
      //oled.print(F("ENABLED"));
    */

    // Uncomment when using u8g2 / SSD1306 / SH1106
    u8g2.firstPage();
    do {
      u8g2.setFont(u8g2_font_ncenR12_tr);
      u8g2.setCursor(0, 12);
      u8g2.print(F("Display Logo:"));
      u8g2.setCursor(25, 40);
      u8g2.print(F("DISABLED"));
    } while ( u8g2.nextPage() );

    /*
    // Uncomment when using Digole Display  
    mydisp.setFont(201);
    mydisp.setTextPosAbs(0, 12);
    mydisp.print(F("Display Logo:"));
    mydisp.setTextPosAbs(25, 40);
    mydisp.print(F("DISABLED"));
    */
  }
  delay(2000);
  SaveStartMsgState();
  /*
    lcd.setCursor(1, 0);
    lcd.print(F("SETTING  SAVED"));
    lcd.setCursor(2, 0);
    lcd.print(F("----------------"));
    
    // For use with Newhaven Display
    //oled.clear();
    //oled.cursorMove(1, 2);
    //oled.print(F("SETTING  SAVED"));
    //oled.cursorMove(2, 1);
    //oled.print(F("----------------"));
  */

  // Uncomment when using u8g2 / SSD1306 / SH1106
  u8g2.firstPage();
  do {
    u8g2.setFont(u8g2_font_ncenR12_tr);
    u8g2.setCursor(10, 30);
    u8g2.print(F("Setting Saved"));
    u8g2.drawLine(0, 40, 128, 40); // start{x, y}, finish{x, y}
  } while ( u8g2.nextPage() );

  /*
  // Uncomment when using Digole Display
  mydisp.clearScreen();
  mydisp.setFont(201);
  mydisp.setTextPosAbs(10, 30);
  mydisp.print(F("Setting Saved"));
  mydisp.drawLine(0, 40, 128, 40); // start{x, y}, finish{x, y}
  */

  delay(1500);
  //mydisp.clearScreen(); // Clear Digole Display
  refreshDisplay();
}
