/******************************************************************************
 *
 *                Microchip Memory Disk Drive File System
 *
 ******************************************************************************
 * FileName:        HardwareProfile.h
 * Dependencies:    None
 * Processor:       PIC18/PIC24/dsPIC30/dsPIC33/PIC32
 * Compiler:        C18/C30/C32
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the Company) for its PICmicro Microcontroller is intended and
 * supplied to you, the Companys customer, for use solely and
 * exclusively on Microchip PICmicro Microcontroller products. The
 * software is owned by the Company and/or its supplier, and is
 * protected under applicable copyright laws. All rights are reserved.
 * Any use in violation of the foregoing restrictions may subject the
 * user to criminal sanctions under applicable laws, as well as to
 * civil liability for the breach of the terms and conditions of this
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN AS IS CONDITION. NO WARRANTIES,
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
*****************************************************************************/


#ifndef _HARDWAREPROFILE_H_
#define _HARDWAREPROFILE_H_

#include "../Tracker.h"
// Define your clock speed here
#define GetSystemClock()            (CLOCKFREQ)
#define GetPeripheralClock()        (BUSFREQ)
#define GetInstructionClock()       (GetSystemClock())
    
// Description: Macro used to enable the SD-SPI physical layer (SD-SPI.c and .h)
//#define USE_SD_INTERFACE_WITH_SPI


/* SD Card definitions: Change these to fit your application when using
   an SD-card-based physical layer                                   */

// Registers for the SPI module you want to use
//#define MDD_USE_SPI_1
//#define MDD_USE_SPI_2
#define USE_SD_INTERFACE_WITH_SPI

//SPI Configuration
//#define SPI_START_CFG_1     (PRI_PRESCAL_64_1 | SEC_PRESCAL_8_1 | MASTER_ENABLE_ON | SPI_CKE_ON | SPI_SMP_ON)
#define SPI_START_CFG_1     (SPI_OPEN_MSTEN | SPI_OPEN_CKE_REV | SPI_OPEN_MODE8 | SPI_OPEN_ON)
#define SPI_START_CFG_2     (BUSFREQ/400000)

        // Define the SPI frequency
#define SPI_FREQUENCY			(2000000)

// Description: SD-SPI Chip Select Output bit
#define SD_CS               LATBbits.LATB2
// Description: SD-SPI Chip Select TRIS bit
#define SD_CS_TRIS          TRISBbits.TRISB2

// Description: SD-SPI Card Detect Input bit
#define SD_CD               PORTBbits.RB13                           // same as Write Protect Check Input bit
// Description: SD-SPI Card Detect TRIS bit
#define SD_CD_TRIS          TRISBbits.TRISB13

// Description: SD-SPI Write Protect Check Input bit
#define SD_WE               PORTBbits.RB3
// Description: SD-SPI Write Protect Check TRIS bit
#define SD_WE_TRIS          TRISBbits.TRISB3

// Description: The main SPI control register
#define SPICON1             SPI2CON
// Description: The SPI status register
#define SPISTAT             SPI2STAT
// Description: The SPI Buffer
#define SPIBUF              SPI2BUF
// Description: The receive buffer full bit in the SPI status register
#define SPISTAT_RBF         SPI2STATbits.SPIRBF
// Description: The bitwise define for the SPI control register (i.e. _____bits)
#define SPICON1bits         SPI2CONbits
// Description: The bitwise define for the SPI status register (i.e. _____bits)
#define SPISTATbits         SPI2STATbits
// Description: The enable bit for the SPI module
#define SPIENABLE           SPI2CONbits.ON
// Description: The definition for the SPI baud rate generator register (PIC32)
#define SPIBRG		    SPI2BRG

// Tris pins for SCK/SDI/SDO lines

// Description: The TRIS bit for the SCK pin
#define SPICLOCK            TRISBbits.TRISB15
// Description: The TRIS bit for the SDI pin
#define SPIIN               TRISAbits.TRISA4
// Description: The TRIS bit for the SDO pin
#define SPIOUT              TRISBbits.TRISB5

//SPI library functions

#define putcSPI(spichar)     SpiChnPutC(SPI_CHANNEL2, spichar)	//SPI library functions
#define getcSPI()            SpiChnGetC(SPI_CHANNEL2)
#define OpenSPI(config1, config2)   SpiChnOpen(SPI_CHANNEL2, config1, config2)

#endif

