' Flexible Interface Card for PCs
' Silicon Chip, July 1997
' Listing 1 (test code)

10 CLS: KEY OFF: DEFINT A, B, C
20 PORTA = &H378				'&H378 = LPT1, &H278 = LPT2
30 PORTB = PORTA + 1: PORTC = PORTB + 1		'define port addresses
40 OUT PORTA,0: OUT PORTC,10			'turn all relays off, take C0 high 
50 OUT PORTC,11: OUT PORTC,10			'select card one, C0 low then high
60 FOR A = 0 TO 7				'relays are coded 1, 2, 4, 8, 16, 32, 64, 128
70 OUT PORTA,2^A				'select relay 1 to 8 in turn
80 OUT PORTC,11: OUT PORTC,10			'select card one, strobe high then low
90 B$ = RIGHT$(TIME$,2): WHILE RIGHT$(TIME$,2) = B$: WEND 'wait 
one second
100 NEXT A

110 OUT PORTA,0: OUT PORTC,11			'turn all relays off
120 OUT PORTB,120: OUT PORTC,5			'take input lines high
130 FOR A = 1 to 200: NEXT			'delay for IC4c increase value if 
necessary
140 LIN = 0: B = INP(PORTB): C = INP(PORTC)	'read port input 
values
150 IF (B AND 128) THEN BIN = B - 135 ELSE BIN = B + 121 'comple
ment bit 8
160 CIN = C AND 14 'mask high bits and C0
170 IF (C AND 2) = 0 THEN CIN = CIN + 2 ELSE CIN = CIN - 2 'co
mplement bit 2
180 IF (C AND 8) = 0 THEN CIN = CIN + 8 ELSE CIN = CIN - 8 'co
mplement bit 8
190 CIN = INT (CIN/2): TIN = 255 - (BIN + CIN)
200 FOR A = 0 TO 7: IF TIN/2^A = 1 THEN LIN = A + 1 'find low 
line
210 NEXT
220 LOCATE 24,20: PRINT "Line";LIN;		'print it
230 GOTO 140					'loop
