1 GOTO 10
2 GOSUB 1890: LPRINT TAB(45);" Printed on ";TODAY$; "@";TIME$
3 LLIST
4 END
5 SAVE "C:\BAS\SCREG",A 'Save file on C drive
6 SAVE "A:\BAS\SCREG",A 'Save file on A drive
7 SAVE "B:\BAS\SCREG",A 'Save file on B drive
8 END
10 REM Software for SC Computer Controlled Power Supply.
11 REM run 2 will print listing on printer
12 REM run 5 will save program to drive C
13 REM run 6 will save program to drive A. Run 7 will save to B
20 GOSUB 1000 'Initialise
30 GOSUB 2000 'Write screen heading
40 GOSUB 5000 'Get previous saved values from file
50 GOSUB 6000 'Write old settings to screen with option to change
60 GOSUB 7000 'Write selected data to screen
70 GOSUB 8000 'Output data to power supply
75 'MAIN PROGRAM LOOP 80 - 160 starts here. Monitor power supply & keyboard
80 K$ = INKEY$
90 WHILE K$ = "": K$ = INKEY$ 'While no key is pressed
100 GOSUB 9000 'Read data from PSU
110 GOSUB 7000 'Write data to screen
120 WEND 'A key has been pressed
130 GOSUB 10000 'Service keyboard
140 GOSUB 6360 'Update preset values
150 GOSUB 8000 'Write new values to power supply
160 GOTO 80 'Loop again
900 GOSUB 5100 'Save power supply settings
999 CLS: SYSTEM
1000 '***********************
1010 'Initialisation routine.
1020 '***********************
1030 KEY OFF: CLS: DEFINT A-C,O,T: DEFSTR D,E,K,U 
1050 ESC = CHR$(27): ENTER = CHR$(13): KSP = CHR$(32) 'Spacebar
1070 KUA = CHR$(0) + CHR$(72): KDA = CHR$(0) + CHR$(80) 'up & down arrows
1100 KHOME = CHR$(0) + CHR$(71): KEND = CHR$(0) + CHR$(79) 'home & end
1150 DEF FNCENTRE$(M$) = SPACE$((79 - LEN(M$))/2) + M$ 'centre text
1160 DEF FNCEOL$ = STRING$(79 - POS(Q)," ") 'clear to end of line
1170 DEF FNYN = INSTR((" YyNn") + ENTER + ESC,INKEY$)
1175 '0 or 1, no key, 2 or 3 - Y, 4 or 5 - N, 6 - enter, 7 - escape
1235 'add your additional initialisation routines here.
1240 SCREEN 9: COLOR 14,11: CLS
1250 KPL = CHR$(43): KMI = CHR$(45) 'plus & minus keys
1260 DOB = CHR$(219) '8 X 14 block
1300 '************************
1310 'Setup Control Addresses.
1320 '************************
1330 ODA1 = 9  'PORTC address for output to D-A #1
1340 ODA2 = 15 'PORTC address for output to D-A #2
1350 ODA3 = 13 'PORTC address for output to D-A #3
1360 AD0 = 11  'PORTC address for input from A-D #0 ie earth
1370 AD1 = 3   'PORTC address for input from A-D #1
1380 AD2 = 1   'PORTC address for input from A-D #2
1390 AD3 = 7   'PORTC address for input from A-D #3
1400 AD4 = 5 'Port address fot input from A-D #4
1401 'VP1 = 1: VP2 = 1: VP3 = 1: VP4 = 1: VP5 = 1 'pos correction
1402 'VN1 = 1: VN2 = 1: VN3 = 1: VN4 = 1: VN5 = 1 'neg correction
1403 VI1 = 1: VI2 = 1: VI3 = 1: VI4 = 1: VI5 = 1 'current
1410 V1OLD = 10: V2OLD = 10: V3OLD = 10 'Any initial value
1420 VP1 = 1: VP2 = 1: VP3 = 1.013: VP4 = 1.009 'pos correction
1430 VN1 = 1: VN2 = 1: VN3 = 1.0075: VN4 = 1.009 'neg correction
1440 'VI1 = 1.015: VI2 = 1.015: VI3 = 1.015: VI4 = 1.015: VI5 = 1.015 'current
1880 '**********************
1890 TODAY$ = MID$(DATE$,4,2) + "-" + LEFT$(DATE$,2) + "-" + RIGHT$(DATE$,2)
1899 RETURN
2000 '****************
2010 'Write to screen.
2020 '****************
2030 COLOR 4,11: X = 100: Y = 25: PSET (X,Y) 'write SC to screen
2040 DRAW "u12;h12;l48;g12;d24;f12;r32;d24;l24;u12;l24;d12;f12;r48"
2050 PSET (X,Y): DRAW "l24;u12;l24;d24;r32;f12;d24;g12"
2060 PAINT (X-20,Y-5) 'draw & fill S
2070 PSET (X+90,Y)
2080 DRAW "u12;h12;l48;g12;d60;f12;r48;e12;u12;l24;d12;l24;u60;r24;d12;r24"
2090 PAINT (X+80,Y-5) 'draw & fill C
2100 COLOR 14,11
2110 LOCATE 3,35: PRINT "Silicon Chip";
2120 LOCATE 5,35: PRINT "Regulated Power Supply Controller";
2199 RETURN
3000 '******************************
3010 'Port Input Conversion Routine.
3020 '******************************
3023 'To convert any data input to parallel ports B & C to all HIGH true
3026 'as PORTB bit 7 and PORTC bits 0,1 and 3 are LOW true
3030 A = INP(PORTC): B = INP(PORTB)
3040 BIN = - (B > 127) * (B - 135) - (B < 128) * (B + 120) 'complement bit 7
3050 AIN = (A AND 14) 'mask off high bits
3060 IF (A AND 2) = 0 THEN AIN = AIN + 2 ELSE AIN = AIN - 2 'complement bit 1
3070 IF (A AND 8) = 0 THEN AIN = AIN + 8 ELSE AIN = AIN - 8 'complement bit 3
3080 AIN = AIN / 2 'move the value one place to right, strobe is not data
3090 TIN = BIN + AIN 'total converted input
3099 RETURN
4000 '********************************************************************
4010 '4030 - 4920 draw large block digits from 0 to 9 at the location R,C.
4020 '********************************************************************
4030 'digit 0
4040 LOCATE R,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4050 FOR AA = 1 TO 4: LOCATE CSRLIN,C: PRINT DOB;: LOCATE CSRLIN,C+4:                PRINT DOB: NEXT
4060 LOCATE CSRLIN,C: FOR AA = 1 TO 5: PRINT DOB;: NEXT
4099 RETURN
4120 'digit 1
4130 LOCATE R,C+1: PRINT DOB;DOB
4140 FOR AA = 1 TO 3: LOCATE CSRLIN,C+1: PRINT DOB;DOB: NEXT
4150 LOCATE CSRLIN,C + 1: PRINT DOB;DOB;
4199 RETURN
4220 'digit 2
4230 LOCATE R,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT
4240 LOCATE CSRLIN,C+3: PRINT DOB
4250 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT
4260 LOCATE CSRLIN,C: PRINT DOB
4270 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4299 RETURN
4320 'digit 3
4330 LOCATE R,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT
4340 LOCATE CSRLIN,C+3: PRINT DOB
4350 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT
4360 LOCATE CSRLIN,C+3: PRINT DOB
4370 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4399 RETURN
4420 'digit 4
4430 LOCATE R,C: PRINT DOB;DOB: LOCATE CSRLIN,C: PRINT DOB;DOB
4440 LOCATE CSRLIN,C: PRINT DOB;DOB;SPC(2);DOB
4450 LOCATE CSRLIN,C: FOR AA = 1 TO 6: PRINT DOB;: NEXT: PRINT
4460 LOCATE CSRLIN,C+4: PRINT DOB;
4499 RETURN
4520 'digit 5
4530 LOCATE R,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT
4540 LOCATE CSRLIN,C: PRINT DOB
4550 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT
4560 LOCATE CSRLIN,C+3: PRINT DOB
4570 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4599 RETURN
4620 'digit 6
4630 LOCATE R,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT
4640 LOCATE CSRLIN,C: PRINT DOB
4650 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT
4660 LOCATE CSRLIN,C: PRINT DOB; SPC(2);DOB
4670 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4699 RETURN
4720 'digit 7
4730 LOCATE R,C: FOR AA = 1 TO 5: PRINT DOB;: NEXT: PRINT
4740 FOR AA = 1 TO 3: LOCATE CSRLIN,C+3: PRINT DOB;DOB: NEXT
4780 LOCATE CSRLIN,C+3: PRINT DOB;DOB;
4799 RETURN
4820 'digit 8
4830 LOCATE R,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4840 FOR AA = 1 TO 2: LOCATE CSRLIN,C: PRINT DOB;: LOCATE CSRLIN,C+4:                PRINT DOB: NEXT
4850 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4860 FOR AA = 1 TO 2: LOCATE CSRLIN,C: PRINT DOB;: LOCATE CSRLIN,C+4:                PRINT DOB: NEXT
4870 LOCATE CSRLIN,C: FOR AA = 1 TO 5: PRINT DOB;: NEXT
4899 RETURN
4920 'digit 9
4930 LOCATE R,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4940 FOR AA = 1 TO 2: LOCATE CSRLIN,C: PRINT DOB;: LOCATE CSRLIN,C+4:                PRINT DOB: NEXT
4950 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4960 FOR AA = 1 TO 2: LOCATE CSRLIN,C+4: PRINT DOB: NEXT
4970 LOCATE CSRLIN,C: FOR AA = 1 TO 5: PRINT DOB;: NEXT
4999 RETURN
5000 '**************************************
5010 'Use stored settings or enter new ones.
5020 '**************************************
5025 'Read the previous saved values for voltage, current and printer port
5030 OPEN "SCREGPSU.PSU" FOR INPUT AS 1 'open the file
5040 INPUT #1, S1, S2 ,S3, PP: CLOSE 1 'read the old values
5050 IF PP = 1 THEN PORTA = &H378 ELSE IF PP = 2 THEN PORTA = &H278
5060 PORTB = PORTA + 1: PORTC = PORTA + 2 'assign the correct port
5070 IF S3 = S1 THEN TRACK = 1 'make supplies track if they did previously
5099 RETURN
5100 '************************************
5110 'Save current settings for next time.
5120 '************************************
5130 OPEN "SCREGPSU.PSU" FOR OUTPUT AS 1 'open the file
5140 WRITE# 1, S1, S2, S3, PP: CLOSE 1 'save the current values
5199 RETURN
6000 '************************************
6010 'Display meter panel & stored values.
6020 '************************************
6030 PSET (40,97) 'locate at x, y
6040 DRAW "r216;d95;l216;u95;bd95;d18;r216;u18"
6050 LOCATE 8,8: PRINT "POSITIVE OUTPUT VOLTAGE"
6060 LOCATE 15,14: PRINT "Eset ";: PRINT USING "##.#";S1
6070 PSET (340,97) 'locate at x, y
6080 DRAW "r216;d95;l216;u95;bd95;d18;r216;u18"
6090 LOCATE 8,51: PRINT "OUTPUT CURRENT"
6100 LOCATE 15,52: PRINT "Limit ";: PRINT USING "#.##";S2
6110 PSET (40,210)
6120 DRAW "d95;R216;u95;BL216;bd95;d18;r216;u18"
6130 LOCATE 16,8: PRINT "NEGATIVE OUTPUT VOLTAGE"
6140 LOCATE 23,14: PRINT "Eset -";: PRINT USING "##.#";S3
6150 LOCATE 17,48: PRINT "Printer Port LPT";MID$(STR$(PP),2,1);":"
6160 LOCATE 25,1
6170 PRINT FNCENTRE$("Press ENTER for these values - SPACEBAR to change");
6180 K = INPUT$(1): IF K = ENTER THEN 6360
6190 LOCATE 25,1: PRINT FNCEOL$;
6200 LOCATE 10,8: INPUT; "New voltage";S1$
6210 IF S1$ = "" THEN 6220 ELSE S1 = VAL(S1$)
6220 LOCATE 19,8: INPUT; "New voltage";S3$
6230 IF S3$ = "" THEN 6240 ELSE S3 = VAL(S3$)
6240 LOCATE 10,48: INPUT; "New limit";S2$
6250 IF S2$ = "" THEN 6260 ELSE S2 = VAL(S2$)
6260 LOCATE 17,64: INPUT PP$: IF PP$ <> "" THEN PP = VAL(PP$)
6270 LOCATE 17,48: PRINT FNCEOL$;
6280 LOCATE 17,48: PRINT "Printer Port LPT";MID$(STR$(PP),2,1);":"
6290 IF PP = 1 THEN PORTA = &H378 ELSE IF PP = 2 THEN PORTA = &H278
6300 PORTB = PORTA + 1: PORTC = PORTA + 2
6310 LOCATE 25,1
6320 PRINT FNCENTRE$("Press ENTER for these values - SPACEBAR to change");
6330 LOCATE 10,8: PRINT STRING$(20,32)
6340 LOCATE 19,8: PRINT STRING$(20,32)
6350 LOCATE 10,48: PRINT STRING$(20,32)
6360 LOCATE 15,14: PRINT STRING$(15,32): LOCATE 15,14: PRINT "Eset ";:               PRINT USING "##.#";S1
6370 LOCATE 15,52: PRINT STRING$(15,32): LOCATE 15,52: PRINT "Limit ";:              PRINT USING "#.##";S2
6380 LOCATE 23,14: PRINT STRING$(16,32): LOCATE 23,14: PRINT "Eset -";:              PRINT USING "##.#";S3
6390 LOCATE 25,1: PRINT FNCEOL$;
6400 LOCATE 19,40: PRINT "Use Plus/Minus keys to adjust +volts"
6410 LOCATE 20,40: PRINT "Press E or V to set +volts"
6420 LOCATE 21,40: PRINT "Press N to set -volts"
6430 LOCATE 22,40: PRINT "Press I or A to set current limit"
6440 LOCATE 23,40: PRINT "Press T for -V to track +V"
6450 LOCATE 25,1: PRINT FNCENTRE$("Press ESC or END to exit program.");
6499 RETURN
7000 '************************
7010 'Display selected values.
7020 '************************
7030 'write positive voltage required
7040 R = 9: C = 8 'set the cursor position
7050 IF V1 = V1OLD THEN 7150 ELSE GOSUB 7900 'if identical don't update value
7060 IF V1 + .06 < S1 THEN COLOR 4,11 'change color if out of specification
7070 V1$ = LEFT$(STR$(V1),5) 'change V1 to a string so it can be dissected
7080 FOR A = 2 TO LEN(V1$): DIG$ = MID$(V1$,A,1) 'digit by digit
7090 IF DIG$ = "." THEN LOCATE 13,C: PRINT DOB;DOB: C = C - 2: GOTO 7120
7100 AMT = VAL(DIG$) 'then write it to the screen using a large digit
7110 ON AMT+1 GOSUB 4030,4130,4230,4330,4430,4530,4630,4730,4830,4930
7120 C = C + 7 'allow interdigit space
7130 NEXT
7140 V1OLD = V1: COLOR 14,11 'restore yellow writing for next display
7150 'write current required
7160 C = 45 'set cursor position
7170 IF V2 = V2OLD THEN 7270 ELSE GOSUB 7900 'if identical don't update value
7180 IF V2 > = S2 THEN COLOR 4,11 'change color if out of specification
7190 V2$ =LEFT$(STR$(V2),5) 'change V2 to a string so it can be dissected
7200 FOR A = 2 TO LEN(V2$): DIG$ = MID$(V2$,A,1) 'digit by digit
7210 IF DIG$ = "." THEN LOCATE 13,C: PRINT DOB;DOB: C = C - 2: GOTO 7240
7220 AMT = VAL(DIG$) 'write it to screen, using large digit
7230 ON AMT+1 GOSUB 4030,4130,4230,4330,4430,4530,4630,4730,4830,4930
7240 C = C + 7 'allow interdigit space
7250 NEXT
7260 V2OLD = V2: COLOR 14,11 'restore standard color for digit
7270 'write negative voltage required 
7280 R = 17: C = 8 'set cursor position
7290 IF V3 = V3OLD THEN 7399 ELSE GOSUB 7900 'if identical don't update value
7300 IF V3 + .06 < S3 THEN COLOR 4,11 'change color if out of spec
7310 V3$ = LEFT$(STR$(V3),5) 'change V3 to a string so it can be dissected
7320 FOR A = 2 TO LEN(V3$): DIG$ = MID$(V3$,A,1) 'digit by digit
7330 IF DIG$ = "." THEN LOCATE 21,C: PRINT DOB;DOB: C = C - 2: GOTO 7360
7340 AMT = VAL(DIG$) 'write large digit to screen
7350 ON AMT+1 GOSUB 4030,4130,4230,4330,4430,4530,4630,4730,4830,4930
7360 C = C + 7 'allow interdigit spcace
7370 NEXT
7380 V3OLD = V3: COLOR 14,11 'restore standard color for digit
7399 RETURN
7900 '*****************************
7910 'Erase old power supply value.
7920 '*****************************
7930 LOCATE R,C: PRINT STRING$(25,32) '25 spaces
7940 FOR A = 1 TO 4: LOCATE CSRLIN,C: PRINT STRING$(25,32): NEXT
7999 RETURN
8000 '****************************
8010 'Output data to power supply.
8020 '****************************
8030 OUT PORTA,CINT(S1*10) 'send the positive output voltage
8040 OUT PORTC,ODA1 'select positive rail address - strobe goes low
8050 OUT PORTC,ODA1-1 'take strobe high - latch address
8060 OUT PORTC,AD0 'select ground address - strobe goes low
8070 OUT PORTC,AD0-1 'take strobe high - latch address
8080 OUT PORTA,CINT(S2*100) 'send current limit value
8090 OUT PORTC,ODA2 'select current limit address - strobe goes low
8100 OUT PORTC,ODA2-1 'take strobe high - latch address
8110 OUT PORTC,AD0 'select ground address - strobe goes low
8120 OUT PORTC,AD0-1 'take strobe high - latch address
8130 OUT PORTA,CINT(S3*10) 'send negative output voltage
8140 OUT PORTC,ODA3 'select negative rail address - strobe H/L
8150 OUT PORTC,ODA3-1 'strobe high - latch address
8160 OUT PORTB,120: OUT PORTC,4 'set all port bits high
8199 RETURN
8440 'VI1 = 1.015: VI2 = 1.015: VI3 = 1.015: VI4 = 1.015: VI5 = 1.015 'current
9000 '****************************
9010 'Read data from power supply.
9020 '****************************
9030 OUT PORTC,AD0-1 'X7 on HC4051 selected, strobe high
9040 OUT PORTC,AD0 'take strobe low, after IC5 RC delay CS will go low
9050 OUT PORTB,120: OUT PORTC,5 'set all port lines high, strobe low
9060 FOR A = 1 TO 1000: NEXT 'wait a short time
9070 GOSUB 3000 'read the A/D converter output
9080 IN0 = TIN 'which is the voltage on X7 (ie ground)
9090 OUT PORTC,AD1-1 'strobe line goes from low to high taking A/D off bus
9100 OUT PORTC,AD1 'strobe goes low
9110 OUT PORTB,120: OUT PORTC,5 'set all port lines high, strobe low
9120 FOR A = 1 TO 1000: NEXT
9130 GOSUB 3000: IN1 = TIN: VADJ = INT(IN1/64) 'read positive voltage
9135 VPT = -((VADJ=0) * VP1 + (VADJ=1)* VP2 + (VADJ=2) * VP3 +(VADJ=3) * VP4          + (VADJ=4) * VP5)
9140 'VPT = -((VADJ=0) * VP1 + (VADJ=1)* VP2 + (VADJ=2) * VP3 +(VADJ=3) * VP4          + (VADJ=4) * VP5)
9150 V1 = CINT(IN1 * VPT)/10 'make correction
9160 OUT PORTC,AD2-1 'IN2
9170 OUT PORTC,AD2
9180 OUT PORTB,120: OUT PORTC,5 'set all port lines high, strobe low
9190 FOR A = 1 TO 1000: NEXT
9200 GOSUB 3000: IN2 = TIN: VADJ = INT(IN2/125) 'read positive current
9205 'VIT = -((VADJ=0) * VI1 + (VADJ=1) * VI2 + (VADJ=2) * VI3 + (VADJ=3) * VI4        + (VADJ=4) * VI5)
9210 VIT = -((VADJ=0) * VI1 + (VADJ=1) * VI2 + (VADJ=2) * VI3 + (VADJ=3) * VI4        + (VADJ=4) * VI5)
9220 V2 = CINT(IN2 * VIT)/100 'make correction
9230 OUT PORTC,AD3-1 'IN3
9240 OUT PORTC,AD3
9250 OUT PORTB,120: OUT PORTC,5 'set all port lines high, strobe low
9260 FOR A = 1 TO 1000: NEXT
9270 GOSUB 3000: IN3 = TIN: VADJ = INT(IN3/64) 'read negative voltage
9275 VNT = -((VADJ=0) * VN1 + (VADJ=1) * VN2 + (VADJ=2) * VN3 + (VADJ=3) * VN4        + (VADJ=4) * VN5)
9280 'VNT = -((VADJ=0) * VN1 + (VADJ=1) * VN2 + (VADJ=2) * VN3 + (VADJ=3) * VN4        + (VADJ=4) * VN5)
9290 V3 = CINT(IN3 * VNT)/10 'make correction
9300 OUT PORTC,AD4-1 'IN4
9310 OUT PORTC,AD4
9320 OUT PORTB,120: OUT PORTC,5 'set all port lines high, strobe low
9330 FOR A = 1 TO 1000: NEXT
9340 GOSUB 3000 'read +12V supply
9350 IN4 = TIN: V4 = CINT(IN4)/10 'enter correction factor if needed
9360 OUT PORTB,120: OUT PORTC,4 'take all port lines high
9399 RETURN
10000 '***********************
10010 'Keyboard Input Handler.
10020 '***********************
10021 'if the PLUS key or UP arrow key is pressed increase + volts
10022 'if the MINUS key or DOWN arrow key is pressed decrease + volts
10023 'if the E or V key is pressed accept the following input for voltage
10024 'if the N or n key is pressed accept the following input for - volts
10025 'if the T or t key is pressed the - will track + until - set via keyboard
10026 'if the A or I key is pressed accept the following input for current limit
10027 'the ESCAPE or END key will save the current settings & exit the program
10030 'no other keys will be recognised
10040 IF K = KUA OR K = KGPL THEN S1 = S1 + .1: IF S1 > 25.5 THEN S1 = 25.5
10050 IF K = KDA OR K = KGMI THEN S1 = S1 - .1: IF S1 < 0 THEN S1 = 0
10060 IF K = "E" OR K = "e" OR K = "V" OR K = "v" THEN GOSUB 10200
10070 IF K = "N" OR K = "n" THEN GOSUB 10400
10080 IF K = "T" OR K = "t" THEN S3 = S1: TRACK = 1
10090 IF K = "A" OR K = "a" OR K = "I" OR K = "i" THEN GOSUB 10300
10100 IF K = ESC OR K = KEND THEN RETURN 900
10110 IF TRACK THEN S3 = S1
10120 V1OLD = 0: V2OLD = 0: V3OLD = 0 'Ensure new values are written to screen
10199 RETURN
10200 '****************************************
10210 'Accept a value for the positive voltage.
10220 '****************************************
10230 LOCATE 25,1: PRINT FNCEOL$;
10240 LOCATE 25,28: INPUT;"What positive voltage ";S1$
10250 IF S1$ = "" THEN 10299
10260 IF VAL(S1$) > 25.5 THEN BEEP: GOTO 10230
10270 S1 = VAL(S1$)
10280 IF S1 < 0 THEN S1 = 0
10299 RETURN 10110
10300 '*******************************
10310 'Accept a value for the current.
10320 '*******************************
10330 LOCATE 25,1: PRINT FNCEOL$;
10340 LOCATE 25,28: INPUT;"What current limit ";S2$
10350 IF S2$ = "" THEN 10399
10360 IF VAL(S2$) > 2.551 THEN BEEP: GOTO 10330
10370 S2 = VAL(S2$)
10380 IF S2 < 0 THEN S2 = 0
10399 RETURN 10120
10400 '***************************************
10410 'Accept a value for the negative voltage.
10420 '****************************************
10430 LOCATE 25,1: PRINT FNCEOL$;
10440 LOCATE 25,28: INPUT;"What negative voltage ";S3$
10450 IF S3$ = "" THEN 10499
10460 IF VAL(S3$) > 25.5 THEN BEEP: GOTO 10430
10470 S3 = VAL(S3$)
10480 IF S3 < 0 THEN S3 = 0
10490 TRACK = 0
10499 RETURN 10120
