'  ******** Spacewriter program, using printer port ********
'
' This program encodes the Spacewriter with a sequence of data to display
' up to ten characters on a 7 row LED array (making a word or words) when
' waved from left to right in space. Each character uses 5 column positions.
'
' You can program four separate blocks of memory for four messages.
'
GOTO 1 ' skip delay
'**********************************************************************
'delay routine adds time to clock
2000 FOR D = 0 TO 1
NEXT D
RETURN
'**********************************************************************
1 DIM D(189)   'space for 5x7 LED matrix data for alphabet and space
J = 0 'initialise J. Represents number of characters to be programmmed
'
CLS  ' blank the screen
'
PORT.A = &H378 ' change this address for different printer port location
PORT.C = &H37A ' change this address for different printer port location
'
OUT PORT.A, &H0 ' Set all data lines (D0 to D7) low. Memory is in write mode when D0 is low.
' note that PORT.C -D0 and -D1 lines are inverted
OUT PORT.C, &H0 ' Preset counter (-D0) to first memory location and clock input high (-D1)
GOSUB 2000  'delay
OUT PORT.C, &H1 ' Release preset (-D0) by taking low
'
COLOR 12, 1
PRINT " "
CLS
'
PRINT "        --------- SILICON CHIP SPACEWRITER PROGRAM ----------"
PRINT "        *****************************************************"
PRINT '
COLOR 15, 1
PRINT "1/..... SELECT MEMORY BLOCK WITH THE TWO PUSH BUTTON SWITCHES"
PRINT
COLOR 10, 1
PRINT "        *****************************************************"
PRINT "        *   BOTH  SWITCHES  OPEN  SELECTS MEMORY BLOCK 1    * "
PRINT "        *   UPPER SWITCH  PRESSED SELECTS MEMORY BLOCK 2    * "
PRINT "        *   LOWER SWITCH  PRESSED SELECTS MEMORY BLOCK 3    * "
PRINT "        *   BOTH SWITCHES PRESSED SELECTS MEMORY BLOCK 4    * "
PRINT "        ***************************************************** "

PRINT " "
COLOR 15, 1
'
PRINT "2/..... TYPE IN THE WORD OR STATEMENT"
COLOR 11, 1
PRINT "        Spacebar will insert a space. Up to 10 characters of"
PRINT "        the Alphabet, including spacebar are allowed. "
PRINT "         "
PRINT " "
PRINT " "
'
'***********************************************************************
'
'instructions plus move cursor to overwrite (----------)
'
COLOR 15, 1
Y = CSRLIN'find current cursor line position
X = POS(0)'find current cursor column position
COLOR 30, 1
PRINT "        ---------- "
PRINT
COLOR 15, 1
PRINT "3/..... PRESS THE ENTER KEY"
PRINT "        (if less than 10 characters entered)"
2 LOCATE Y, X + 8 'restore cursor position
'
COLOR 12, 1
'
'***********************************************************************
' keyboard entry
'
B$ = ""'null string to clear B
22 A$ = INPUT$(1)'get next keyboard statement entered
IF A$ = CHR$(13) THEN GOTO 3 'character 13 is return key
PRINT A$; 'echo typed character
B$ = B$ + A$
IF LEN(B$) = 10 THEN GOTO 3 'if string is 10
GOTO 22
'
'entered 10 characters
3 A$ = "" 'null string to clear A
IF LEFT$(B$, 1) < "[" THEN GOTO 4 'check if entered character is upper case, ie Z is next below [, A is above @
FOR A = 1 TO LEN(B$) 'for total of characters entered
A$ = A$ + CHR$(ASC(MID$(B$, A)) - 32)'convert to upper case by subtracting decimal 32
NEXT 'next character
B$ = A$ 'convert back to B$
LOCATE Y, X + 8 'type over old entry if lower case
PRINT B$ 'reprint characters in upper case
GOTO 43 'skip a print line
'
'all upper case (now)
'also check for space entered first
'
4 PRINT
43 IF LEFT$(B$, 1) <> CHR$(32) THEN GOTO 44 'cannot start with a space
'space entered first
COLOR 29, 1
LOCATE Y, X'type over existing text
PRINT "        SORRY! SPACEBAR CANNOT BE USED FIRST. "
COLOR 15, 1
PRINT
PRINT "3/..... PRESS ANY KEY TO RETURN TO PROGRAM"
PRINT "                                              " 'block out previous line
X$ = INPUT$(1)
GOTO 1 'spacebar pressed first so go to start of program
'
'all upper case characters and no space first
44 PRINT
COLOR 10, 1
PRINT
PRINT
PRINT
PRINT "        Characters entered=", LEN(B$) 'count characters
'
'**************************************************************************
FOR R = 1 TO 4 'load first four memory locations with lows
OUT PORT.C, &H3 'clock low
GOSUB 2000
OUT PORT.C, &H1 'clock high and next memory location
GOSUB 2000
NEXT R
'
'Check which keys were pressed
K = 1
9 A$ = MID$(B$, K, 1)    'read each character in turn
'
IF A$ = "A" THEN GOTO 10 ' Is key pressed an "A"?
IF A$ = "B" THEN GOTO 20 ' Is key pressed a  "B"?
IF A$ = "C" THEN GOTO 30 ' Is key pressed a  "C"?
IF A$ = "D" THEN GOTO 40 ' Is key pressed a  "D"?
IF A$ = "E" THEN GOTO 50 ' Is key pressed an "E"?
IF A$ = "F" THEN GOTO 60 ' Is key pressed an "F"?
IF A$ = "G" THEN GOTO 70 ' Is key pressed a  "G"?
IF A$ = "H" THEN GOTO 80 ' Is key pressed an "H"?
IF A$ = "I" THEN GOTO 90 ' Is key pressed an "I"?
IF A$ = "J" THEN GOTO 100 'Is key pressed a  "J"?
IF A$ = "K" THEN GOTO 110 'Is key pressed a  "K"?
IF A$ = "L" THEN GOTO 120 'Is key pressed an "L"?
IF A$ = "M" THEN GOTO 130 'Is key pressed an "M"?
IF A$ = "N" THEN GOTO 140 'Is key pressed an "N"?
IF A$ = "O" THEN GOTO 150 'Is key pressed an "O"?
IF A$ = "P" THEN GOTO 160 'Is key pressed a  "P"?
IF A$ = "Q" THEN GOTO 170 'Is key pressed a  "Q"?
IF A$ = "R" THEN GOTO 180 'Is key pressed an "R"?
IF A$ = "S" THEN GOTO 190 'Is key pressed an "S"?
IF A$ = "T" THEN GOTO 200 'Is key pressed a  "T"?
IF A$ = "U" THEN GOTO 210 'Is key pressed a  "U"?
IF A$ = "V" THEN GOTO 220 'Is key pressed a  "V"?
IF A$ = "W" THEN GOTO 230 'Is key pressed a  "W"?
IF A$ = "X" THEN GOTO 240 'Is key pressed an "X"?
IF A$ = "Y" THEN GOTO 250 'Is key pressed a  "Y"?
IF A$ = "Z" THEN GOTO 260 'Is key pressed a  "Z"?
GOTO 270 ' space
'
'None of above keys pressed so add a space
'
'
' ***********************************************************************
300 J = J + 1 'return here after each character is programmed into memory
IF J = 10 THEN GOTO 400 'J is the character limit. Stop at 10
K = K + 1 'K points to next character in string statement
GOTO 9 'read next character
' ***********************************************************************
'
' routine to clock 7x5 matrix into memory 6th location = space
'
1000 FOR C = 1 TO 6
READ D(C)
M = D(C)
OUT PORT.A, M
OUT PORT.C, &H3 'clock low
GOSUB 2000
OUT PORT.C, &H1 'clock high and next memory location
GOSUB 2000
NEXT C
GOTO 300 'check character count
'
' ***********************************************************************
'
' end of programming
'
400 COLOR 29, 1
'
PRINT
PRINT "        Memory block programmed"   'memory full
COLOR 15, 1
PRINT
PRINT "4/..... DO YOU WANT TO PROGRAM ANOTHER MEMORY BLOCK? Yes or No."
OUT PORT.A, &H1  'turn off write line and all other lines off
X$ = INPUT$(1)
IF X$ = "Y" THEN GOTO 1'check for Y, go to start of program
IF X$ = "y" THEN GOTO 1'check for y, go to start of program
END 'program ends here
'
'***********************************************************************
' address for each character 5x7 matrix data
'
10 RESTORE 510 'start of data table for an "A"
GOTO 1000
20 RESTORE 520 '                            B
GOTO 1000
30 RESTORE 530 '                            C
GOTO 1000
40 RESTORE 540 '                            D
GOTO 1000
50 RESTORE 550 '                            E
GOTO 1000
60 RESTORE 560 '                            F
GOTO 1000
70 RESTORE 570 '                            G
GOTO 1000
80 RESTORE 580 '                            H
GOTO 1000
90 RESTORE 590 '                            I
GOTO 1000
100 RESTORE 600'                            J
GOTO 1000
110 RESTORE 610'start of data table for a   K
GOTO 1000
120 RESTORE 620'                            L
GOTO 1000
130 RESTORE 630'                            M
GOTO 1000
140 RESTORE 640'                            N
GOTO 1000
150 RESTORE 650'                            O
GOTO 1000
160 RESTORE 660'                            P
GOTO 1000
170 RESTORE 670'                            Q
GOTO 1000
180 RESTORE 680'                            R
GOTO 1000
190 RESTORE 690'                            S
GOTO 1000
200 RESTORE 700'                            T
GOTO 1000
210 RESTORE 710'                            U
GOTO 1000
220 RESTORE 720'                            V
GOTO 1000
230 RESTORE 730'                            W
GOTO 1000
240 RESTORE 740'                            X
GOTO 1000
250 RESTORE 750'                            Y
GOTO 1000
260 RESTORE 760'start of data table for a   Z
GOTO 1000
270 RESTORE 770' space
GOTO 1000
'
' *********************************************************************
'start of data table to produce an upper case character in a 5x7 matrix
'
510 DATA &H00,&H7E,&H90,&H90,&H90,&H7E,00   ' A (5 column x 7 row LED character)
520 DATA &H00,&HFE,&H92,&H92,&H92,&H6C,00   ' B
530 DATA &H00,&H7C,&H82,&H82,&H82,&H44,00   ' C
540 DATA &H00,&HFE,&H82,&H82,&H44,&H38,00   ' D
550 DATA &H00,&HFE,&H92,&H92,&H92,&H82,00   ' E
560 DATA &H00,&HFE,&H90,&H90,&H90,&H80,00   ' F
570 DATA &H00,&H7C,&H82,&H92,&H92,&H4C,00   ' G
580 DATA &H00,&HFE,&H10,&H10,&H10,&HFE,00   ' H
590 DATA &H00,&H00,&H82,&HFE,&H82,&H00,00   ' I
600 DATA &H00,&H08,&H04,&H02,&H02,&HFC,00   ' J
610 DATA &H00,&HFE,&H10,&H28,&H44,&H82,00   ' K (5 column x 7 row LED character)
620 DATA &H00,&HFE,&H02,&H02,&H02,&H02,00   ' L
630 DATA &H00,&HFE,&H40,&H30,&H40,&HFE,00   ' M
640 DATA &H00,&HFE,&H20,&H10,&H08,&HFE,00   ' N
650 DATA &H00,&H7C,&H82,&H82,&H82,&H7C,00   ' O
660 DATA &H00,&HFE,&H90,&H90,&H60,&H00,00   ' P
670 DATA &H00,&H7C,&H82,&H8A,&H86,&H7C,00   ' Q
680 DATA &H00,&HFE,&H90,&H98,&H64,&H02,00   ' R
690 DATA &H00,&H64,&H92,&H92,&H92,&H4C,00   ' S
700 DATA &H00,&H80,&H80,&HFE,&H80,&H80,00   ' T
710 DATA &H00,&HFC,&H02,&H02,&H02,&HFC,00   ' U
720 DATA &H00,&HE0,&H18,&H06,&H18,&HE0,00   ' V
730 DATA &H00,&HFC,&H02,&H1C,&H02,&HFC,00   ' W
740 DATA &H00,&HC6,&H28,&H10,&H28,&HC6,00   ' X
750 DATA &H00,&HE0,&H10,&H0E,&H10,&HE0,00   ' Y
760 DATA &H00,&H86,&H8A,&H92,&HA2,&HC2,00   ' Z (5 column x 7 row LED character)
770 DATA &H00,&H00,&H00,&H00,&H00,&H00,00   ' space code



