5  REM BUFFDRVS.BAS  #1  R.W.  25/04/97
10 REM Code for Buffered Stepper Driver PCB. Silicon Chip Dec. 1997 P60
11 'Steps motor 255 steps forward direction or 127 steps in bi-directional mode
12 'Subroutine 3000 test to see if a single card is running using J8
13 'prints a message, then loops to line 30
20 GOSUB 1000 'Initialise
30 GOSUB 4000 'Get direction & number of steps
40 GOSUB 2000 'Load number of steps and output to card
50 GOSUB 3000 'Test J8 to see if a single card is running
60 GOTO 30
999 CLS:SYSTEM
1000 '***************
1010 'Initialisation.
1020 '***************
1025 KEY OFF 'Note STEP is a reserved word, use STEPS
1030 STEPS = &H378 'PORT A - &H378 for LPT1 - &H278 for LPT2
1040 CARDIN = STEPS + 1 'PORT B
1050 CARD# = STEPS + 2 'PORT C
1060 DEF FNCEOL$ = STRING$(78 - POS(Q)," ") 'clear to end of line
1070 ONE = 10: TWO = 8: THREE = 14: FOUR = 12 'output code
1080 FIVE = 2: SIX = 0: SEVEN = 6: EIGHT = 4 'for cards 1 to 8
1090 HI = 120: REV = 12 'OUT PORT B,HI sets all lines high, rev = 1 revolution
1100 ' format is OUT STEPS,NUMBER+F: OUT CARD#,(NUMBER) for FORWARD
1110 ' format is OUT STEPS,NUMBER+R: OUT CARD#,(NUMBER) 'for REVERSE
1120 ' or OUT STEPS,NUMBER: OUT CARD#,(NUMBER) 'for FORWARD
1130 ' OUT CARD#,(NUMBER) + 1 'To take strobe line low
1140 ' Maximum number of steps is 255 forward if no reverse direction
1150 ' or 127 steps if forward and reverse option selected
1160 ' one step is 30 degrees so 12 steps to the revolution
1170 ' so maximum number of revs is 10 in bi-directional mode
1180 ' Format to read from a card is OUT CARD#,(NUMBER) 'select the card
1190 ' OUT CARDIN,hi 'all PORT B address lines high
1200 ' Then a delay for RC to charge
1210 ' B(NO) = INP(CARDIN) 'read input & store data in array
1999 RETURN
2000 '********************
2010 'Output data to card.
2020 '********************
2030 OUT STEPS, FORWARD + R 'set # of steps and direction
2040 OUT CARD#,ONE 'select card & load No of steps
2050 OUT CARD#,ONE + 1 'take strobe line low
2060 OUT STEPS,R 'hold direction line high or low
2999 RETURN
3000 '******************
3010 'Look at jumper J8.
3020 '******************
3030 OUT CARDIN,HI 'set PORT B lines high
3040 B = INP(CARDIN) 'read selected card's bus (PORT B)
3050 IF B = 127 THEN LOCATE 25,25: PRINT "Card busy.";
3060 WHILE INP(CARDIN) = 127: WEND 'wait for motor to stop
3070 LOCATE 25,1: PRINT FNCEOL$;: LOCATE 25,15
3080 PRINT "Card not busy. Press spacebar to continue.";
3090 OUT STEPS,0 'set direction line low
3100 OUT CARD#,ONE + 1 'reset strobe
3110 K$ = INPUT$(1)
3999 RETURN
4000 '****************************
4010 'Get forward & reverse steps.
4020 '****************************
4030 CLS
4040 LOCATE 5,15: PRINT "Silicon Chip stepper motor software."
4050 LOCATE 7,15: PRINT "Buffered Stepper Driver demonstration."
4060 LOCATE 9,12: PRINT "This demo for Bi-directional stepping using J8.";
4070 LOCATE 11,15: PRINT "Press F to step Forward or B to step Backwards ";
4080 R$ = INPUT$(1): PRINT R$
4090 IF R$ = "B" OR R$ = "b" THEN R = 128 ELSE R = 0
4100 LOCATE 13,15: PRINT "How many steps. Maximum is 127.";
4110 INPUT;FORWARD
4120 IF FORWARD > 127 THEN FORWARD = 127
4130 IF FORWARD = 0 THEN RETURN 999
4999 RETURN
