5 REM 2FS1W.BAS  R.W.  #1  28/04/97
10 REM Code for 2 stepper motor PCB. Silicon Chip, Sept. 1997, P80
11 REM Steps both motors forward or bacwards in full steps, one winding sequence
20 GOSUB 1000 'Initialise
30 GOSUB 6000 'Get forward & reverse steps
40 GOSUB 2000 'Both motors clockwise then de-energise motor coils
50 GOSUB 3000 'Pause
60 GOSUB 4000 'Both anti-clock then de-energise motor coils
70 GOTO 30
999 CLS: SYSTEM
1000 '***************
1010 'Initialisation.
1020 '***************
1030 KEY OFF 'Note!!! STEP is a reserved word. Use STEPS
1040 STEPS = &H378  'PORT A - &H378 for LPT1 - &H278 for LPT2
1050 CARD# = STEPS + 2
1060 ONE = 10: TWO = 8: THREE = 14: FOUR = 12 'output codes
1070 FIVE = 2: SIX = 0: SEVEN = 6: EIGHT = 4 'for cards 1 to 8
1080 DATA 17, 68, 34, 136
1090 DATA 136, 34, 68, 17
1100 FOR A = 1 TO 4: READ ROTCW(A): L = L+1: NEXT 'read data for clock rotation
1110 FOR A = 1 TO 4: READ ROTCCW(A):L = L+1:NEXT 'read data for anti-clock rotn
1120 OUT STEPS,136: OUT CARD#,ONE 'step motor to known location
1130 GOSUB 5000 'make sure motor coils are de-energised
1999 RETURN
2000 '****************
2010 'Motor clockwise.
2020 '****************
2030 FOR A = 1 TO FORWARD 'step forward # steps of 30 degrees
2040 FOR B = 1 TO 4
2050 OUT STEPS,ROTCW(B) 'do four steps of 7.5 degrees
2060 OUT CARD#,ONE 'select the card
2070 OUT CARD#,ONE + 1 'strobe low
2080 FOR C = 1 TO L*45: NEXT 'delay allows motor to step
2090 NEXT
2100 NEXT
2110 GOSUB 5000 'de-energise motor coils
2999 RETURN
3000 '*************************************
3010 'Pause between clockwise & anti-clock.
3020 '*************************************
3030 T = TIMER: WHILE TIMER < T + 1: WEND
3999 RETURN
4000 '*********************
4010 'Motor anti-clockwise.
4020 '*********************
4030 FOR A = 1 TO REVERSE 'rotate anti-clock for # steps
4040 FOR B = 1 TO 4
4050 OUT STEPS,ROTCCW(B) '4 steps of 7.5 degrees
4060 OUT CARD#,ONE 'select card
4070 OUT CARD#,ONE + 1 'strobe low
4080 FOR C = 1 TO 350: NEXT 'delay allows motor to step
4090 NEXT
4100 NEXT
4110 GOSUB 5000 'de-energise motor coils
4999 RETURN
5000 '************************
5010 'De-energise motor coils.
5020 '************************
5030 OUT STEPS,0 'de-energise motor coils
5040 OUT CARD#,ONE 'select card
5050 OUT CARD#,ONE + 1 'strobe low
5999 RETURN
6000 '****************************
6010 'Get forward & reverse steps.
6020 '****************************
6030 CLS
6040 LOCATE 5,15: PRINT "Silicon Chip stepper motor software."
6050 LOCATE 7,15: PRINT "2 Motor full step 1 winding demonstration."
6060 LOCATE 25,20: PRINT "To quit enter zero for both values.";
6070 LOCATE 9,15: PRINT "How many steps FORWARD ";
6080 INPUT;FORWARD
6090 LOCATE 11,15: PRINT "How many steps BACKWARDS ";
6100 INPUT;REVERSE
6110 IF FORWARD + REVERSE = 0 THEN RETURN 999
6999 RETURN
