5 REM BUFFDRVM.BAS  #1  R.W.  25/4/97
10 REM Code for Buffered stepper motor PCB. Silicon Chip Dec. 1997 P60
11 REM Steps one motor forward up to 21 revs or bi-directional up to 10 revs
12 'subroutine 3000 tests for multiple cards using jumpers J4 to J7
13 'prints a message, then loops to line 30
20 GOSUB 1000 'Initialise
30 GOSUB 4000 'Get number of steps and direction
40 GOSUB 2000 'Load number of steps and output to card
50 GOSUB 3000 'Test J4 to J7 to see if all cards empty
60 GOTO 30
999 CLS: SYSTEM
1000 '***************
1010 'Initialisation.
1020 '***************
1025 KEY OFF 'Note STEP is a reserved word, use STEPS
1030 STEPS = &H378 'PORT A - &H378 for LPT1 - &H278 for LPT2
1040 CARDIN = STEPS + 1 'PORT B
1050 CARD# = STEPS + 2 'PORT C
1060 DEF FNCEOL$ = STRING$(79 - POS(Q)," ") 'Clear to end of line
1070 ONE = 10: TWO = 8: THREE = 14: FOUR = 12 'output code
1080 FIVE = 2: SIX = 0: SEVEN = 6: EIGHT = 4 'for cards 1 to 8
1090 HI = 120 'OUT PORT B,HI sets all lines high
1100 ' format is OUT STEPS,NUMBER+F: OUT CARD#,(NUMBER) for FORWARD
1110 ' format is OUT STEPS,NUMBER+128: OUT CARD#,(NUMBER) 'for REVERSE
1120 ' or OUT STEPS,NUMBER: OUT CARD#,(NUMBER) 'for FORWARD
1130 ' OUT CARD#,(NUMBER) + 1 'To take strobe line low
1140 ' Maximum number of steps is 255 forward if no reverse direction
1150 ' or 127 steps if forward and reverse option selected
1160 ' one step is 30 degrees so 12 steps to the revolution
1170 ' so maximum number of revs is 10 in bi-directional mode
1180 ' Format to read from a card is OUT CARD#,(NUMBER) 'select the card
1190 ' OUT CARDIN,hi 'all PORT B address lines high
1200 ' Then a delay for RC to charge
1210 ' B(NO) = INP(CARDIN) 'read input & store data in array
1999 RETURN
2000 '********************
2010 'Output data to card.
2020 '********************
2025 OUT CARD#,EIGHT 'select card 8 or any unused card
2030 OUT STEPS, FORWARD + R 'set # of steps & direction
2040 OUT CARD#,ONE 'select card & load No of steps
2050 OUT CARD#,ONE + 1 'reset strobe
2060 OUT STEPS,R 'take all inputs low, leave direction line high
2999 RETURN
3000 '*****************
3010 'Read card buffer.
3020 '*****************
3030 OUT CARD#,ONE 'select ANY card
3040 OUT CARDIN,HI 'set PORT B lines high
3050 B = 127 - INP(CARDIN) 'read PORT B LINES
3060 IF B AND -128 THEN J7$ = "J7 busy "
3070 IF B AND 64 THEN J6$ = "J6 busy "
3080 IF B AND 32 THEN J5$ = "J5 busy "
3090 IF B AND 16 THEN J4$ = "J4 busy "
3100 LOCATE 25,25: PRINT J7$ + J6$ + J5$ + J4$;
3110 WHILE B > < 0: B = 127 - INP(CARDIN): WEND
3115 OUT STEPS,0 'take direction line low
3120 OUT CARD#,ONE + 1 'reset strobe
3130 LOCATE 25,1: PRINT FNCEOL$;: LOCATE 25,10
3140 PRINT "All motors stopped.";
3150 PRINT " Press spacebar to continue.";
3160 K$ = INPUT$(1)
3999 RETURN
4000 '****************************
4010 'Get forward & reverse steps.
4020 '****************************
4030 CLS
4040 LOCATE 5,15: PRINT "Silicon Chip stepper motor software."
4050 LOCATE 7,15: PRINT "Buffered stepper card demonstration."
4060 LOCATE 9,12: PRINT "This demo for Bi-directional stepping using J4-J7.";
4070 LOCATE 11,15: PRINT "What direction F-Forward, B-Backwards? ";
4080 R$ = INPUT$(1): PRINT R$
4090 IF R$ = "B" OR R$ = "b" THEN R = 128 ELSE R = 0
4100 LOCATE 13,15: PRINT "How many steps. Maximum is 127";
4110 INPUT;FORWARD: IF FORWARD > 127 THEN FORWARD = 127
4120 IF FORWARD = 0 THEN 999
4999 RETURN
