5 REM 1HS2W.BAS #1 R.W. 23/05/97
10 REM Code for 1 stepper motor PCB. Silicon Chip aug. 1997 P54
11 REM Steps motor forward or backwards in half step sequence
20 GOSUB 1000 'Initialise
30 GOSUB 6000 'Ask for forward & reverse steps
40 GOSUB 2000 'Motor clockwise then de-energise motor coils
50 GOSUB 3000 'Pause
60 GOSUB 4000 'Motor anti-clock then de-energise motor coils
70 GOTO 30
999 CLS: SYSTEM
1000 '***************
1010 'Initialisation.
1020 '***************
1030 KEY OFF: CLS 'Note!!! STEP is a reserved word. Use STEPS
1040 STEPS = &H378  'PORT A - &H378 for LPT1 - &H278 for LPT2
1050 CARD# = STEPS + 2 'PORTC
1060 ONE = 10: TWO = 8: THREE = 14: FOUR = 12 'output codes
1070 FIVE = 2: SIX = 0: SEVEN = 6: EIGHT = 4 'for cards 1 to 8
1080 DATA 9, 153, 144, 150, 6, 102, 96, 105
1090 DATA 96, 102, 6, 150, 144, 153, 9, 105
1100 FOR A = 1 TO 8: READ ROTCW(A): NEXT 'read data for clockwise rotation
1110 FOR A = 1 TO 8: READ ROTCCW(A): NEXT 'read data for anti-clock rotation
1120 OUT STEPS,105: OUT CARD#,ONE 'step motor to known location
1130 OUT CARD#,ONE + 1
1140 GOSUB 5000 'make sure motor coils are de-energised
1150 DELAY = 350
1999 RETURN
2000 '***************
2010 'Motors forward.
2020 '***************
2030 FOR A = 1 TO FORWARD 'go forward # of steps of 30 degrees
2040 FOR B = 1 TO 8
2050 OUT STEPS,ROTCW(B) 'do one cycle of 4 X 7.5 degree steps
2060 OUT CARD#,ONE 'select the card
2070 OUT CARD#,ONE + 1 'strobe low
2080 FOR C = 1 TO DELAY: NEXT 'delay to allow motor time to step
2090 NEXT
2100 NEXT
2110 GOSUB 5000 'de-energise motor coils
2999 RETURN
3000 '**********************************
3010 'Pause between forward and reverse.
3020 '**********************************
3030 T = TIMER: WHILE TIMER < T + 1: WEND
3999 RETURN
4000 '*********************
4010 'Motors anticlockwise.
4020 '*********************
4030 FOR A = 1 TO REVERSE 'rotate anticlock for # of steps
4040 FOR B = 1 TO 8
4050 OUT STEPS,ROTCCW(B) 'one cycle of 4 x 7.5 degree steps
4060 OUT CARD#,ONE 'select card
4070 OUT CARD#,ONE + 1 'strobe low
4080 FOR C = 1 TO DELAY: NEXT 'delay allows motor to step
4090 NEXT
4100 NEXT
4110 GOSUB 5000 'de-energise motor coils
4999 RETURN
5000 '************************
5010 'De-energise motor coils.
5020 '************************
5030 OUT STEPS,0 'de-energise motor coils
5040 OUT CARD#,ONE 'select card
5050 OUT CARD#,ONE + 1 'tahe strobe low
5999 RETURN
6000 '****************************
6010 'Get forward & reverse steps.
6020 '****************************
6030 CLS
6040 LOCATE 5,15: PRINT "Silicon Chip stepper motor software."
6050 LOCATE 7,15: PRINT "1 Motor half step demonstration."
6060 LOCATE 25,20: PRINT "To quit enter zero for both values.";
6070 LOCATE 9,15: PRINT "How many steps FORWARD ";
6080 INPUT;FORWARD
6090 LOCATE 11,15: PRINT "How many steps BACKWARDS ";
6100 INPUT;REVERSE
6110 IF FORWARD + REVERSE = 0 THEN RETURN 999
6999 RETURN
