'TVPATT3.BAS RUN AFTER TVPATT2.BAS

DIM D(10500) '(210 x 50)  "101-150 line screen information"
CLS 'clear the screen
COLOR 15, 1
FOR A = 0 TO 50
PRINT 'fill screen with colour first
NEXT A
PORT.C = &H37A 'outputs
PORT.B = &H379 'inputs
PORT.A = &H378 'data outputs
LOCATE 5, 1
PRINT "                 **************************************"
PRINT "                              SILICON CHIP"
PRINT "                 ---TV PATTERN GENERATOR ROM PROGRAM---"
PRINT "                 **************************************"
PRINT
COLOR 12, 1
PRINT
PRINT "                    TVPATT3.BAS PROGRAM IN PROGRESS"
PRINT
PRINT "              TVPATT4, TVPATT5, TVPATT6 & TVPATT7 TO RUN YET"
COLOR 28, 1
LOCATE 13, 61
PRINT "*"
LOCATE 13, 14
PRINT "*"

'**********************************************************
' read data send to port.a,
' apply program pulse and then increment counter
'

FOR C = 1 TO 10500
READ D(C) ' data for screen pattern and sync
M = D(C)
OUT PORT.A, M 'apply to memory
GOSUB 2000
OUT PORT.C, &H7 'trigger program pulse
OUT PORT.C, &H5 'trigger off
1000 E = INP(PORT.B) 'check if program pulse timer off yet
F = &HEF OR E 'single out D4
IF F = &HEF GOTO 1000 'timer still going
OUT PORT.C, &H1 'clock signal to increment counter
OUT PORT.C, &H5 'clock signal off
COLOR 15, 1
LOCATE 15, 15
PRINT "PROGRAMMED       LOCATIONS OF 10500"
LOCATE 15, 25
PRINT C;
NEXT C
CHAIN "c:\basic\TVPATT4.BAS"
2000 FOR I = 1 TO 20 'delay loop
NEXT I
RETURN

'**********************************************************


'TVPATT3.BAS has lines 101 to 150 of data

'          1                                                         13        15                                                           27                            33   34                            40   41                       46                                 53   54   55             58   59  60                        65                      70   71   72                  76   77                            83   84   85                  89                            95   96   97         99  100  101                 105           108   109                 113                                    121                  125                                          134            137                          143        145 146             149                                          158  159       161                 165                           171       173                                                    184  185       187                                          196  197                                                              210

101 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
102 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
103 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
104 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
105 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
106 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
107 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
108 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
109 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
110 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
111 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7

'          1                                                         13        15                                                           27                            33   34                            40   41                       46                                 53   54   55             58   59  60                        65                      70   71   72                  76   77                            83   84   85                  89                            95   96   97         99  100  101                 105           108   109                 113                                    121                  125                                          134            137                          143        145 146             149                                          158  159       161                 165                           171       173                                                    184  185       187                                          196  197                                                              210

112 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H80,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H80,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H91,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H91,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&HC3,&HC3,&HC3,&HC3,&HC0,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC0,&HC2,&HC2,&HC2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD1,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HA1,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA0,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HB2,&HB2,&HB2,&HB2,&HB0,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB1,&HB3,&HB3,&HB3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE1,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HF0,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF0,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2
113 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
114 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
115 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
116 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
117 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
118 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
119 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
120 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
121 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
122 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
123 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
124 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
125 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
126 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
127 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
128 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
129 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
130 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
131 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
132 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
133 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
134 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
135 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
136 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
137 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
138 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
139 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
'          1                                                         13        15                                                           27                            33   34                            40   41                       46                                 53   54   55             58   59  60                        65                      70   71   72                  76   77                            83   84   85                  89                            95   96   97         99  100  101                 105           108   109                 113                                    121                  125                                          134            137                          143        145 146             149                                          158  159       161                 165                           171       173                                                    184  185       187                                          196  197                                                              210

140 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H80,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H80,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H91,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H91,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&HC3,&HC3,&HC3,&HC3,&HC0,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC0,&HC2,&HC2,&HC2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD1,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HA1,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA0,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HB2,&HB2,&HB2,&HB2,&HB0,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB1,&HB3,&HB3,&HB3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE1,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HF0,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF0,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2
141 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
142 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
143 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
144 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
145 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
146 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
147 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
148 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
149 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
150 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6

