'TV PATTERN GENERATOR PROGRAM TO PROGRAM A 512K ROM WITH PATTERN CODES
'VIA THE PARALLEL PRINTER PORT
'THERE ARE 7 SEPARATE PROGRAMS TO ALLOW SPACE FOR THE DATA (64K MAX PER FILE)
'THIS IS PRESENTED IN A LINE BY LINE FORMAT WITH COLUMN NUMBERING
'TO ALLOW AN EASIER MEANS TO EDIT THE DATA COMPARED TO A SEQUENTIAL
'DATA FILE
'TVPATT1.BAS HAS DATA FOR LINES 1-50
'TVPATT2.BAS HAS DATA FOR LINES 51-100
'TVPATT3.BAS HAS DATA FOR LINES 101-150
'TVPATT4.BAS HAS DATA FOR LINES 151-200
'TVPATT5.BAS HAS DATA FOR LINES 201-250
'TVPATT6.BAS HAS DATA FOR LINES 251-300
'TVPATT7.BAS HAS DATA FOR LINES 301-312
'
'DATA OUTPUTS HAVE THE FOLLOWING CODING
'D0 HAS CHECKERBOARD
'D1 HAS DOT
'D2 HAS CROSSHATCH & CIRCLE
'D3 HAS RASTOR
'D4 BLUE FOR COLOUR BAR
'D5 GREEN FOR COLOUR BAR
'D6 RED FOR COLOUR BAR
'D7 COMPOSITE SYNC
'
'PARALLEL PORT LINES USED ARE:
'-D1 PORT C PROGRAM PULSE TIMER (MOMENTARY LOW TO TRIGGER TIMER) NORMALLY HIGH
'-D2 PORT C COUNTER CLOCK (HIGH TO CLOCK) NORMALLY LOW
' D4 PORT B MONITORS TIMER OUTPUT (LOW IF TIMER ON) HIGH IF OFF
'
'MEMORY IS 512K BITS OR 64K BYTES (8-BIT BYTE)
'EACH MEMORY LOCATION IS CLOCKED AT A 3.2768MHz RATE OR EVERY 305.17578ns
'MEMORY SPACE IS DIVIDED UP AS 210 WIDE BY 312 LINES TOTALLING 65520
'THE MEMORY IS RESET AT THE END OF THE 312TH LINE WITH &H00
'FRAME RATE BECOMES 305.17578ns x 65520 =  50.01Hz
'LINE RATE IS 305.17578ns x 210 = 15603.8Hz OR 0.14% TOO SLOW FROM 15625Hz
'HORIZONTAL SYNC PULSES @ 4.7us REQUIRE 15 MEMORY SPACES
'VERTICAL SYNC PULSES @ 7 LINES OR 448us

'HORIZONTAL BLANKING OF 12us BEGINNING AT THE START OF THE H SYNC
'IS REQUIRED ON THE PATTERN OUTPUTS EQUALLING 40 MEMORY SPACES

'THE PATTERNS GENERATED ARE FOR BOTH FIELDS 1 AND 2 AND TO SIMPLY IT,
'LINE NUMBERING IS 1-312 FOR ONE FIELD ONLY. NO ODD AND EVEN FIELDS
'SINCE THE SECOND FIELD IS ALSO THE SAME AS 1-312

'NOTE THAT THE SYNC PULSE IS A "0"
'THE PATTERN SIGNAL IS A "0" FOR ON "1" FOR OFF
'BECAUSE THE DATA OUTPUTS FROM THE MEMORY ARE INVERTED
'
'****************START OF PROGRAM********************************

DIM D(10500) '(210 x 50)  "1-50 line screen information"
CLS 'clear the screen
COLOR 15, 1
FOR A = 0 TO 50
PRINT 'fill screen with colour first
NEXT A
PORT.C = &H37A 'outputs
PORT.B = &H379 'inputs
PORT.A = &H378 'data outputs
OUT PORT.C, &H4 '-D1,D2 high, "initial conditions"
OUT PORT.A, &HFF'load all highs into data lines
LOCATE 5, 1
PRINT "                 **************************************"
PRINT "                              SILICON CHIP"
PRINT "                 ---TV PATTERN GENERATOR ROM PROGRAM---"
PRINT "                 **************************************"
PRINT
COLOR 12, 1
PRINT "                 MAKE SURE THAT THE TV PATTERN GENERATOR"
PRINT "             IS SET WITH THE FOUR CONNECTIONS FOR PROGRAMMING"
PRINT "                    AND APPLY POWER TO THE CIRCUIT"
COLOR 29, 1
PRINT
PRINT
INPUT "                   PRESS RETURN KEY TO BEGIN PROGRAM", A
CLS
COLOR 15, 1
LOCATE 5, 1
PRINT
PRINT "                 **************************************"
PRINT "                              SILICON CHIP"
PRINT "                 ---TV PATTERN GENERATOR ROM PROGRAM---"
PRINT "                 **************************************"
PRINT
COLOR 12, 1
PRINT "                    TVPATT1.BAS PROGRAM IN PROGRESS"
PRINT
PRINT "         TVPATT2, TVPATT3, TVPATT4, TVPATT5, TVPATT6 & TVPATT7.BAS TO RUN YET"
COLOR 28, 1
LOCATE 13, 78
PRINT "*"
LOCATE 13, 9
PRINT "*"

'**********************************************************
' read data send to port.a,
' apply program pulse and then increment counter
'

FOR C = 1 TO 10500
READ D(C) ' data for screen pattern and sync
M = D(C)
OUT PORT.A, M 'apply to memory
GOSUB 2000
OUT PORT.C, &H7 'trigger program pulse
OUT PORT.C, &H5 'trigger off
1000 E = INP(PORT.B) 'check if program pulse timer off yet
F = &HEF OR E 'single out D4
IF F = &HEF GOTO 1000 'timer still going
OUT PORT.C, &H1 'clock signal to increment counter
OUT PORT.C, &H5 'clock signal off
COLOR 15, 1
LOCATE 15, 15
PRINT "PROGRAMMED       LOCATIONS OF 10500"
LOCATE 15, 25
PRINT C;
NEXT C
CHAIN "c:\basic\TVPATT2.BAS"
2000 FOR I = 1 TO 20 'delay loop
NEXT I
RETURN
'**********************************************************
'field sync runs from lines 311 to 5
'data lines represent the lines in the frame from 6-310
'313 line is the final 16 addresses to fill memory --THE RESET SIGNAL
'data is 210 memory addresses wide minus the 40 blanking addresses
'TVPATT1.BAS has the first 50 lines of data

'lines 1-5 are field sync
'          1                                                         13        15                                                           27                            33   34                            40   41                       46                                 53   54   55             58   59  60                        65                      70   71   72                  76   77                            83   84   85                  89                            95   96   97         99  100  101                 105           108   109                 113                                    121                  125                                          134            137                          143        145 146             149                                          158  159       161                 165                           171       173                                                    184  185       187                                          196  197                                                              210

1 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F
2 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F
3 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F
4 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F
5 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F

'data lines following includes line sync to position 15 up to line 23 has blanking data only
'          1                                                         13        15                                                           27                            33   34                            40   41                       46                                 53   54   55             58   59  60                        65                      70   71   72                  76   77                            83   84   85                  89                            95   96   97         99  100  101                 105           108   109                 113                                    121                  125                                          134            137                          143        145 146             149                                          158  159       161                 165                           171       173                                                    184  185       187                                          196  197                                                              210
6 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
7 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
8 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
9 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
10 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
11 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
12 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
13 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
14 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
15 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
16 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
17 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
18 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
19 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
20 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
21 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
22 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
23 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF
' beginning of screen data
'          1                                                         13        15                                                           27                            33   34                            40   41                       46                                 53   54   55             58   59  60                        65                      70   71   72                  76   77                            83   84   85                  89                            95   96   97         99  100  101                 105           108   109                 113                                    121                  125                                          134            137                          143        145 146             149                                          158  159       161                 165                           171       173                                                    184  185       187                                          196  197                                                              210

24 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
25 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
26 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
27 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
28 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
29 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6

'          1                                                         13        15                                                           27                            33   34                            40   41                       46                                 53   54   55             58   59  60                        65                      70   71   72                  76   77                            83   84   85                  89                            95   96   97         99  100  101                 105           108   109                 113                                    121                  125                                          134            137                          143        145 146             149                                          158  159       161                 165                           171       173                                                    184  185       187                                          196  197                                                              210

30 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H80,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H80,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H91,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H91,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&HC3,&HC3,&HC3,&HC3,&HC0,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC0,&HC2,&HC2,&HC2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD1,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HA1,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA0,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HB2,&HB2,&HB2,&HB2,&HB0,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB1,&HB3,&HB3,&HB3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE1,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HF0,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF0,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2
31 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
32 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
33 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
34 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
35 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
36 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
37 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
38 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
39 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
40 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
41 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
42 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
43 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
44 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
45 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
46 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
47 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
48 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
49 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
50 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6










             
              
              
              
              
              
              
              
  

