'TVPATT4.BAS RUN AFTER TVPATT3.BAS

DIM D(10500) '(210 x 50)  "151-200 line screen information"
CLS 'clear the screen
COLOR 15, 1
FOR A = 0 TO 50
PRINT 'fill screen with colour first
NEXT A
PORT.C = &H37A 'outputs
PORT.B = &H379 'inputs
PORT.A = &H378 'data outputs
LOCATE 5, 1
PRINT "                 **************************************"
PRINT "                              SILICON CHIP"
PRINT "                 ---TV PATTERN GENERATOR ROM PROGRAM---"
PRINT "                 **************************************"
PRINT
COLOR 12, 1
PRINT
PRINT "                    TVPATT4.BAS PROGRAM IN PROGRESS"
PRINT
PRINT "              TVPATT5, TVPATT6 & TVPATT7.BAS TO RUN YET"
COLOR 28, 1
LOCATE 13, 56
PRINT "*"
LOCATE 13, 14
PRINT "*"

'**********************************************************
' read data send to port.a,
' apply program pulse and then increment counter
'

FOR C = 1 TO 10500
READ D(C) ' data for screen pattern and sync
M = D(C)
OUT PORT.A, M 'apply to memory
GOSUB 2000
OUT PORT.C, &H7 'trigger program pulse
OUT PORT.C, &H5 'trigger off
1000 E = INP(PORT.B) 'check if program pulse timer off yet
F = &HEF OR E 'single out D4
IF F = &HEF GOTO 1000 'timer still going
OUT PORT.C, &H1 'clock signal to increment counter
OUT PORT.C, &H5 'clock signal off
COLOR 15, 1
LOCATE 15, 15
PRINT "PROGRAMMED       LOCATIONS OF 10500"
LOCATE 15, 25
PRINT C;
NEXT C
CHAIN "c:\basic\TVPATT5.BAS"
2000 FOR I = 1 TO 20 'delay loop
NEXT I
RETURN

'**********************************************************




'TVPATT4.BAS has lines 151 TO 200 of data

'          1                                                         13        15                                                           27                            33   34                            40   41                       46                                 53   54   55             58   59  60                        65                      70   71   72                  76   77                            83   84   85                  89                            95   96   97         99  100  101                 105           108   109                 113                                    121                  125                                          134            137                          143        145 146             149                                          158  159       161                 165                           171       173                                                    184  185       187                                          196  197                                                              210

151 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
152 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
153 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
154 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
155 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
156 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
157 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
158 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
159 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
160 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
161 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
162 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
163 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
164 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
165 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
166 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6

'          1                                                         13        15                                                           27                            33   34                            40   41                       46                                 53   54   55             58   59  60                        65                      70   71   72                  76   77                            83   84   85                  89                            95   96   97         99  100  101                 105           108   109                 113                                    121                  125                                          134            137                          143        145 146             149                                          158  159       161                 165                           171       173                                                    184  185       187                                          196  197                                                              210

167 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H81,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H81,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H90,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H90,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&HC2,&HC2,&HC2,&HC2,&HC1,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC1,&HC3,&HC3,&HC3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD0,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HA0,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA1,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HB3,&HB3,&HB3,&HB3,&HB1,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB0,&HB2,&HB2,&HB2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE0,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HF1,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF1,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3

168 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
169 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
170 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
171 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
172 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
173 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
174 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
175 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
176 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
177 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
178 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
179 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
180 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
181 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
182 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
183 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
184 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
185 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
186 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
187 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
188 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
189 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
190 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
191 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
192 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
193 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
194 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7

'          1                                                         13        15                                                           27                            33   34                            40   41                       46                                 53   54   55             58   59  60                        65                      70   71   72                  76   77                            83   84   85                  89                            95   96   97         99  100  101                 105           108   109                 113                                    121                  125                                          134            137                          143        145 146             149                                          158  159       161                 165                           171       173                                                    184  185       187                                          196  197                                                              210

195 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H81,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H81,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H90,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H90,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&HC2,&HC2,&HC2,&HC2,&HC1,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC1,&HC3,&HC3,&HC3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD0,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HA0,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA1,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HB3,&HB3,&HB3,&HB3,&HB1,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB0,&HB2,&HB2,&HB2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE0,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HF1,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF1,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3

196 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
197 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
198 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
199 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
200 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7

