'TVPATT2.BAS RUN AFTER TVPATT1.BAS

DIM D(10500) '(210 x 50)  "51-100 line screen information"
CLS 'clear the screen
COLOR 15, 1
FOR A = 0 TO 50
PRINT 'fill screen with colour first
NEXT A
PORT.C = &H37A 'outputs
PORT.B = &H379 'inputs
PORT.A = &H378 'data outputs
LOCATE 5, 1
PRINT "                 **************************************"
PRINT "                              SILICON CHIP"
PRINT "                 ---TV PATTERN GENERATOR ROM PROGRAM---"
PRINT "                 **************************************"
PRINT
COLOR 12, 1
PRINT
PRINT "                    TVPATT2.BAS PROGRAM IN PROGRESS"
PRINT
PRINT "              TVPATT3, TVPATT4, TVPATT5, TVPATT6 & TVPATT7.BAS TO RUN YET"
COLOR 28, 1
LOCATE 13, 74
PRINT "*"
LOCATE 13, 14
PRINT "*"

'**********************************************************
' read data send to port.a,
' apply program pulse and then increment counter
'

FOR C = 1 TO 10500
READ D(C) ' data for screen pattern and sync
M = D(C)
OUT PORT.A, M 'apply to memory
GOSUB 2000
OUT PORT.C, &H7 'trigger program pulse
OUT PORT.C, &H5 'trigger off
1000 E = INP(PORT.B) 'check if program pulse timer off yet
F = &HEF OR E 'single out D4
IF F = &HEF GOTO 1000 'timer still going
OUT PORT.C, &H1 'clock signal to increment counter
OUT PORT.C, &H5 'clock signal off
COLOR 15, 1
LOCATE 15, 15
PRINT "PROGRAMMED       LOCATIONS OF 10500"
LOCATE 15, 25
PRINT C;
NEXT C
CHAIN "c:\basic\TVPATT3.BAS"
2000 FOR I = 1 TO 20 'delay loop
NEXT I
RETURN

'**********************************************************




'TVPATT2.BAS has lines 51 TO 100 of data

'          1                                                         13        15                                                           27                            33   34                            40   41                       46                                 53   54   55             58   59  60                        65                      70   71   72                  76   77                            83   84   85                  89                            95   96   97         99  100  101                 105           108   109                 113                                    121                  125                                          134            137                          143        145 146             149                                          158  159       161                 165                           171       173                                                    184  185       187                                          196  197                                                              210

51 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
52 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
53 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD3,&HD3,&HD3,&HD3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
54 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
55 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA3,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
56 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA3,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
'          1                                                         13        15                                                           27                            33   34                            40   41                       46                                 53   54   55             58   59  60                        65                      70   71   72                  76   77                            83   84   85                  89                            95   96   97         99  100  101                 105           108   109                 113                                    121                  125                                          134            137                          143        145 146             149                                          158  159       161                 165                           171       173                                                    184  185       187                                          196  197                                                              210

57 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H81,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H81,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H90,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H90,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&HC2,&HC2,&HC2,&HC2,&HC1,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC1,&HC3,&HC3,&HC3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD0,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HA0,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA1,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HB3,&HB3,&HB3,&HB3,&HB1,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB0,&HB2,&HB2,&HB2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE0,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HF1,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF1,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3


58 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD3,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA3,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
59 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD3,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA3,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
60 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD3,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA3,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
61 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA3,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
62 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA3,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
63 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB3,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
64 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB3,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
65 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC3,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB3,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
66 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC3,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB3,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
67 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
68 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
69 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
70 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
71 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
72 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
73 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
74 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
75 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
76 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
77 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
78 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
79 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
80 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
81 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
82 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
83 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
84 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
'          1                                                         13        15                                                           27                            33   34                            40   41                       46                                 53   54   55             58   59  60                        65                      70   71   72                  76   77                            83   84   85                  89                            95   96   97         99  100  101                 105           108   109                 113                                    121                  125                                          134            137                          143        145 146             149                                          158  159       161                 165                           171       173                                                    184  185       187                                          196  197                                                              210

85 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H81,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H81,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H83,&H90,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&H90,&H92,&H92,&H92,&H92,&H92,&H92,&H92,&HC2,&HC2,&HC2,&HC2,&HC1,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC3,&HC1,&HC3,&HC3,&HC3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD0,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HA0,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA1,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HB3,&HB3,&HB3,&HB3,&HB1,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB3,&HB0,&HB2,&HB2,&HB2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE0,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HE2,&HF1,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF1,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3,&HF3

86 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
87 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
88 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
89 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC2,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
90 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC2,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB2,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
91 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC2,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB2,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
92 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC2,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB2,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
93 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC2,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB2,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
94 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC2,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB2,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
95 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC2,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
96 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC2,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
97 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC2,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
98 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC2,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
99 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC2,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
100 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7




