'TVPATT5.BAS RUN AFTER TVPATT4.BAS

DIM D(10500) '(210 x 50)  "201-250 line screen information"
CLS 'clear the screen
COLOR 15, 1
FOR A = 0 TO 50
PRINT 'fill screen with colour first
NEXT A
PORT.C = &H37A 'outputs
PORT.B = &H379 'inputs
PORT.A = &H378 'data outputs
LOCATE 5, 1
PRINT "                 **************************************"
PRINT "                              SILICON CHIP"
PRINT "                 ---TV PATTERN GENERATOR ROM PROGRAM---"
PRINT "                 **************************************"
PRINT
COLOR 12, 1
PRINT
PRINT "                    TVPATT5.BAS PROGRAM IN PROGRESS"
PRINT
PRINT "              TVPATT6.BAS & TVPATT7.BAS TO RUN YET"
COLOR 28, 1
LOCATE 13, 51
PRINT "*"
LOCATE 13, 14
PRINT "*"

'**********************************************************
' read data send to port.a,
' apply program pulse and then increment counter
'

FOR C = 1 TO 10500
READ D(C) ' data for screen pattern and sync
M = D(C)
OUT PORT.A, M 'apply to memory
GOSUB 2000
OUT PORT.C, &H7 'trigger program pulse
OUT PORT.C, &H5 'trigger off
1000 E = INP(PORT.B) 'check if program pulse timer off yet
F = &HEF OR E 'single out D4
IF F = &HEF GOTO 1000 'timer still going
OUT PORT.C, &H1 'clock signal to increment counter
OUT PORT.C, &H5 'clock signal off
COLOR 15, 1
LOCATE 15, 15
PRINT "PROGRAMMED       LOCATIONS OF 10500"
LOCATE 15, 25
PRINT C;
NEXT C
CHAIN "c:\basic\TVPATT6.BAS"
2000 FOR I = 1 TO 20 'delay loop
NEXT I
RETURN

'**********************************************************


'TVPATT5.BAS has lines 201 to 250 of data
'          1                                                         13        15                                                           27                            33   34                            40   41                       46                                 53   54   55             58   59  60                        65                      70   71   72                  76   77                            83   84   85                  89                            95   96   97         99  100  101                 105           108   109                 113                                    121                  125                                          134            137                          143        145 146             149                                          158  159       161                 165                           171       173                                                    184  185       187                                          196  197                                                              210


201 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
202 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
203 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
204 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
205 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
206 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
207 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
208 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
209 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
210 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
211 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
212 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
213 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
214 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H92,&H96,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
215 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
216 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
217 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
218 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
219 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H92,&H96,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
220 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7
221 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H83,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H87,&H92,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&H92,&H96,&H96,&H96,&HC6,&HC6,&HC6,&HC6,&HC3,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC7,&HC3,&HC7,&HC7,&HC7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD2,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HB7,&HB7,&HB7,&HB7,&HB3,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB7,&HB2,&HB6,&HB6,&HB6,&HE6,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE2,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HE6,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF3,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7,&HF7

'          1                                                         13        15                                                           27                            33   34                            40   41                       46                                 53   54   55             58   59  60                        65                      70   71   72                  76   77                            83   84   85                  89                            95   96   97         99  100  101                 105           108   109                 113                                    121                  125                                          134            137                          143        145 146             149                                          158  159       161                 165                           171       173                                                    184  185       187                                          196  197                                                              210

222 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H80,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H80,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H91,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H91,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&HC3,&HC3,&HC3,&HC3,&HC0,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC0,&HC2,&HC2,&HC2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD1,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HA1,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA0,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HB2,&HB2,&HB2,&HB2,&HB0,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB1,&HB3,&HB3,&HB3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE1,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HF0,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF0,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2

223 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
224 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
225 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
226 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
227 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
228 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
229 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
230 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
231 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
232 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
233 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
234 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
235 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC3,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
236 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC3,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
237 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC3,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
238 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC3,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
239 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC3,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
240 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC3,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
241 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC3,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB3,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
242 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC3,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB3,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
243 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC3,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB3,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
244 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC3,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB3,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
245 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC3,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB3,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
246 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
247 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
248 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6
249 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H82,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H86,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&H93,&H97,&H97,&H97,&H97,&H97,&H97,&H97,&HC7,&HC7,&HC7,&HC7,&HC2,&HC2,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC6,&HC2,&HC6,&HC6,&HC6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD6,&HD3,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HD7,&HA3,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA7,&HA2,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HA6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB6,&HB2,&HB3,&HB7,&HB7,&HB7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE3,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HE7,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF2,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6,&HF6

'          1                                                         13        15                                                           27                            33   34                            40   41                       46                                 53   54   55             58   59  60                        65                      70   71   72                  76   77                            83   84   85                  89                            95   96   97         99  100  101                 105           108   109                 113                                    121                  125                                          134            137                          143        145 146             149                                          158  159       161                 165                           171       173                                                    184  185       187                                          196  197                                                              210

250 DATA &H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&H7F,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&HFF,&H80,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H80,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H82,&H91,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&H91,&H93,&H93,&H93,&H93,&H93,&H93,&H93,&HC3,&HC3,&HC3,&HC3,&HC0,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC2,&HC0,&HC2,&HC2,&HC2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD2,&HD1,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HD3,&HA1,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA3,&HA0,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HA2,&HB2,&HB2,&HB2,&HB2,&HB0,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB2,&HB1,&HB3,&HB3,&HB3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE1,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HE3,&HF0,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF0,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2,&HF2

