1 GOTO 10
5 SAVE "C:\bas\raffle",A 'Save file on C drive in ASCII format
6 SAVE "A:\bas\raffle",A 'Save file on A drive
7 SAVE "B:\bas\raffle",A 'Save file on B drive
10 REM This program draws a raffle & shows the result
11 'in large numerals in the top area of the screen
12 'When the next prize is drawn the previous draw
13 'is recorded in the lower area of the screen
14 'Lowest & highest number & number of prizes to draw 
15 'as well as draw from high to low or low to high
16 'can be selected.
17 REM run 5 will save program to drive C
18 REM run 6 will save program to drive A
19 REM run 7 will save program to drive B
20 GOSUB 1000 'Initialise
30 GOSUB 5000 'Write heading
40 GOSUB 2000 'Generate a random number
50 GOSUB 6000 'Save draw to hard disk
999 CLS: SYSTEM
1000 '***********************
1010 'Initialisation routine.
1020 '***********************
1030 KEY OFF: SCREEN 9: CLS: DEFINT A-C,R,N: DEFSTR D,E,K,U
1035 'A to C,R & N integers, D,E,K,U Are strings, rest single precision
1040 ESC = CHR$(27): ENTER = CHR$(13): KSP = CHR$(32) 'Spacebar
1140 DEF FNCENTRE$(M$) = SPACE$((79 - LEN(M$))/2) + M$ 'Centre text
1150 DEF FNCEOL$ = STRING$(79 - POS(Q)," ")
1170 ULT = CHR$(218): DLT = CHR$(201): URT = CHR$(191): DRT = CHR$(187)
1175 'Single & Double Left & Right top corners
1180 ULB = CHR$(192): DLB = CHR$(200): URB = CHR$(217): DRB = CHR$(188)
1185 'Single & Double Left & Right bottom corners
1190 UH = CHR$(196): DH = CHR$(205): UV = CHR$(179): DV = CHR$(186)
1195 'Single & Double Horizontal & vertical lines
1350 NOTOSTART = 100: NOTOFIN = 5000
1360 NOTODRAW = 10: NOSEQ = 0 'Low to Hi, 1 = Hi to low
1370 DIM DRAWN$(NOTODRAW)
1380 RL = 10: CL = 35: C1 = 10 'Row & column for large digits
1390 RP = 17: CP = 3 'Row & column for prize listings
1400 RR = RP 'Row reference for view print in sub 7000
1410 DOB = CHR$(219) '8 x 14 block
1420 SLOW = 3000 'Delay for poker machine routine. Smaller for slow machines
1999 RETURN
2000 '*************************
2010 'Generate a random number.
2020 '*************************
2030 RANDOMIZE TIMER
2040 LOCATE 25,1: PRINT FNCENTRE$("Press SPACEBAR for First draw");
2050 K = INPUT$(1): IF K < > KSP THEN 2050
2060 FOR A = 1 TO NOTODRAW
2070 X = INT(RND * (NOTOFIN - NOTOSTART)) + NOTOSTART 'Generate a number
2080 FOR B = 1 TO A 'Check to see if this is the same as the first number drawn
2090 IF VAL(DRAWN$(B)) = X THEN 2070 'if so generate a new number
2100 NEXT B 'otherwise check the rest
2110 DRAWN$(A) = STR$(X) 'If not previously drawn add it to the list
2120 LOCATE 25,1: PRINT FNCEOL$;
2130 GOSUB 3000 'Do poker machine style draw
2140 GOSUB 7000 'Move number to display area
2150 IF A = NOTODRAW THEN 2190 'All numbers drawn
2160 LOCATE 25,1: PRINT FNCENTRE$("Press SPACEBAR for next draw");
2170 K = INPUT$(1): IF K < > KSP THEN 2170
2180 NEXT A 'Then generate the next number
2190 LOCATE 25,1: PRINT FNCENTRE$("Press SPACEBAR to save this draw");
2200 K = INPUT$(1): IF K < > KSP THEN 2200
2999 RETURN
3000 '*************************
3010 'Poker machine style draw.
3020 '*************************
3030 R = RL: C = CL 'Restore original row & column values
3040 FOR B = 2 TO LEN(DRAWN$(A))
3050 LOCATE R + 2,10: IF NOSEQ THEN PRINT A; ELSE PRINT NOTODRAW + 1 - A;
3060 LOCATE R+2,POS(X)-1
3070 IF NOSEQ THEN IF A = 1 THEN PRINT "st"; ELSE IF A = 2 THEN PRINT "nd";
3080 IF NOSEQ THEN IF A = 3 THEN PRINT "rd"; ELSE IF A > 3 THEN PRINT "th";
3090 IF NOSEQ = 0 THEN IF A = NOTODRAW THEN PRINT "st"; ELSE IF A = NOTODRAW-1          THEN PRINT "nd";
3100 IF NOSEQ = 0 THEN IF A = NOTODRAW-2 THEN PRINT "rd"; ELSE IF A < NOTODRAW-2        THEN PRINT "th";
3110 PRINT " Prize ";
3120 GOSUB 4030: GOSUB 3330 'Print a 0
3130 GOSUB 4130: GOSUB 3330 'Print a 1
3140 GOSUB 4230: GOSUB 3330 'Print a 2
3150 GOSUB 4330: GOSUB 3330 'Print a 3
3160 GOSUB 4430: GOSUB 3330 'Print a 4
3170 GOSUB 4530: GOSUB 3330 'Print a 5
3180 GOSUB 4630: GOSUB 3330 'Print a 6
3190 GOSUB 4730: GOSUB 3330 'Print a 7
3200 GOSUB 4830: GOSUB 3330 'Print an 8
3210 GOSUB 4930: GOSUB 3330 'Print a 9, then print first digit of random number
3220 CC = VAL(MID$(DRAWN$(A),B,1))
3230 ON CC + 1 GOSUB 4030,4130,4230,4330,4430,4530,4630,4730,4830,4930
3240 C = C + 7 'Add a space between digits
3250 NEXT 'Then print the next digit
3299 RETURN 'Go back to SUB 2000 at line 2140
3300 '************************************************
3310 'Delay routine to allow numbers to appear slowly.
3320 '************************************************
3330 FOR AA = 1 TO SLOW: NEXT: FOR AA = 1 TO SLOW: NEXT
3340 FOR BB = 0 TO 4: LOCATE R + BB,C: PRINT STRING$(7," ")
3350 NEXT BB
3399 RETURN
4000 '********************************************************************
4010 '4030 - 4920 draw large block digits from 0 to 9 at the location R,C.
4020 '********************************************************************
4030 'digit 0
4040 LOCATE R,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4050 FOR AA = 1 TO 4: LOCATE CSRLIN,C: PRINT DOB;: LOCATE CSRLIN,C+4:                PRINT DOB: NEXT
4060 LOCATE CSRLIN,C: FOR AA = 1 TO 5: PRINT DOB;: NEXT
4099 RETURN
4120 'digit 1
4130 LOCATE R,C+1: PRINT DOB;DOB
4140 FOR AA = 1 TO 3: LOCATE CSRLIN,C+1: PRINT DOB;DOB: NEXT
4150 LOCATE CSRLIN,C + 1: PRINT DOB;DOB;
4199 RETURN
4220 'digit 2
4230 LOCATE R,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT
4240 LOCATE CSRLIN,C+3: PRINT DOB
4250 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT
4260 LOCATE CSRLIN,C: PRINT DOB
4270 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4299 RETURN
4320 'digit 3
4330 LOCATE R,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT
4340 LOCATE CSRLIN,C+3: PRINT DOB
4350 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT
4360 LOCATE CSRLIN,C+3: PRINT DOB
4370 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4399 RETURN
4420 'digit 4
4430 LOCATE R,C: PRINT DOB;DOB: LOCATE CSRLIN,C: PRINT DOB;DOB
4440 LOCATE CSRLIN,C: PRINT DOB;DOB;SPC(2);DOB
4450 LOCATE CSRLIN,C: FOR AA = 1 TO 6: PRINT DOB;: NEXT: PRINT
4460 LOCATE CSRLIN,C+4: PRINT DOB;
4499 RETURN
4520 'digit 5
4530 LOCATE R,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT
4540 LOCATE CSRLIN,C: PRINT DOB
4550 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT
4560 LOCATE CSRLIN,C+3: PRINT DOB
4570 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4599 RETURN
4620 'digit 6
4630 LOCATE R,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT
4640 LOCATE CSRLIN,C: PRINT DOB
4650 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT: PRINT
4660 LOCATE CSRLIN,C: PRINT DOB; SPC(2);DOB
4670 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4699 RETURN
4720 'digit 7
4730 LOCATE R,C: FOR AA = 1 TO 5: PRINT DOB;: NEXT: PRINT
4740 FOR AA = 1 TO 3: LOCATE CSRLIN,C+3: PRINT DOB;DOB: NEXT
4780 LOCATE CSRLIN,C+3: PRINT DOB;DOB;
4799 RETURN
4820 'digit 8
4830 LOCATE R,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4840 FOR AA = 1 TO 2: LOCATE CSRLIN,C: PRINT DOB;: LOCATE CSRLIN,C+4:                PRINT DOB: NEXT
4850 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4860 FOR AA = 1 TO 2: LOCATE CSRLIN,C: PRINT DOB;: LOCATE CSRLIN,C+4:                PRINT DOB: NEXT
4870 LOCATE CSRLIN,C: FOR AA = 1 TO 5: PRINT DOB;: NEXT
4899 RETURN
4920 'digit 9
4930 LOCATE R,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4940 FOR AA = 1 TO 2: LOCATE CSRLIN,C: PRINT DOB;: LOCATE CSRLIN,C+4:                PRINT DOB: NEXT
4950 LOCATE CSRLIN,C: FOR AA = 1 TO 4: PRINT DOB;: NEXT
4960 FOR AA = 1 TO 2: LOCATE CSRLIN,C+4: PRINT DOB: NEXT
4970 LOCATE CSRLIN,C: FOR AA = 1 TO 5: PRINT DOB;: NEXT
4999 RETURN
5000 '****************
5010 'Write to screen.
5020 '****************
5030 COLOR 4,11: X = 100: Y = 25: PSET (X,Y) 'Write SC to screen
5040 DRAW "u12;h12;l48;g12;d24;f12;r32;d24;l24;u12;l24;d12;f12;r48"
5050 PSET (X,Y): DRAW "l24;u12;l24;d24;r32;f12;d24;g12"
5060 PAINT (X-20,Y-5) 'draw & fill S
5070 PSET (X+90,Y)
5080 DRAW "u12;h12;l48;g12;d60;f12;r48;e12;u12;l24;d12;l24;u60;r24;d12;r24"
5090 PAINT (X+80,Y-5) 'draw & fill C
5100 COLOR 14,11
5110 LOCATE 3,35: PRINT "Silicon Chip";
5120 LOCATE 5,35: PRINT "Computerised Chook Raffle Drawer";
5130 LOCATE 16,1: PRINT DLT;
5140 FOR J = 2 TO 79: PRINT DH;: NEXT: PRINT DRT;
5150 FOR J = 2 TO 8: PRINT DV;TAB(80);DV;: NEXT
5160 PRINT DLB;: FOR J = 2 TO 79: PRINT DH;: NEXT: PRINT DRB;
5199 RETURN
6000 '******************
6010 'Save draw to disk.
6020 '******************
6030 D$ = MID$(DATE$,4,2) + LEFT$(DATE$,2) 'Date
6040 T$ = LEFT$(TIME$,2) + MID$(TIME$,4,2) 'Time
6050 FILE$ = D$ + T$ + ".DRW" 'Name file as date + time & add filetype
6060 OPEN FILE$ FOR OUTPUT AS #1
6070 WRITE# 1, NOSEQ 'Write Hi to low or low to high sequence
6080 FOR A = 1 TO NOTODRAW
6090 WRITE# 1, DRAWN$(A) 'Save the numbers
6100 NEXT A
6110 CLOSE 1
6999 RETURN
7000 '************************************
7010 'Write draw & number to display area.
7020 '************************************
7030 PRIZE$ = ""
7040 FOR CS = 1 TO 4: PRIZE$ = PRIZE$ + CHR$(SCREEN(R+2,CS+10)): NEXT
7050 VIEW PRINT RR TO 23
7060 LOCATE RP,CP: PRINT PRIZE$;" Prize";X; 'Space results by 20 then goto next
7070 CP = CP + 20: IF CP > 65 THEN CP = 3: RP = RP + 1 'line after four entries
7080 VIEW PRINT
7999 RETURN 'Go back to SUB 2000 at line 2150
