'Program for Complex Timer - Silicon Chip January 1999 
'by Bob Nicol, MicroZed Computers
'DEBUG statements are used in this program. They show on your PC screen the first time 
'you load the program and NOT when program is run again.
'DEBUG statements should be disabled with an apostrophe, and the program loaded to the 
'Stamp again when you have finished editing and checking the program to suit you needs
'pin assignments and settings, plus some startup fiddles:
'PIN 0 output to pin 7 of ULN2003 to drive relay on pin 10
LOW 0					'Make sure pin 0 is low
LOW 1					'PIN 1 Not used set low
LOW 2					'PIN 2 Not used set low
LOW 3					'PIN 3 Not used set low
LOW 4					'PIN 4 Not used set low
INPUT 5         					'sets pin 5 as an input to accept LDR level
'PIN 6 output to pin 4 of ULN2003 to drive LED on pin 11of ULN
HIGH 6          					'turn LED on
PAUSE 1000      				'leave LED on for 1 second
LOW 6           					'Then turn LED off and make sure pin 6 is low
'PIN 7 output to piezo sounder
SOUND 7,(100,200)				'make a noise on start up 
'Variables
'B2 accumulates number of times LDR (PIN 5) is low
'B3 accumulates number of times LDR (PIN 5) is high
'B4 accumulates count for reset B2
'W4 accumulates darkness events
'B5 Flags ACTION already done
WAITING_FOR_CHANGE:    			'This program module keeps looking at LDR
					'and initiates action when LDR is dark
					'long enough to be a valid condition
DEBUG "PIN 5 IS ",#PIN5,CR			 'shows if LDR on pin 5 is in dark(0) or light(1)
DEBUG "LDR HAS SEEN  DARK ",#B2," TIMES",CR   'shows on PC screen DARK / LIGHT
DEBUG "LDR HAS SEEN LIGHT ",#B3," TIMES",CR'counts in B2(DARK) & B3(LIGHT)
	PAUSE 1000            			'wait one second
	IF PIN5 = 0 THEN INCREMENT_D	'goto increment_D to add 1 to B2
	IF PIN5 = 1 THEN INCREMENT_L    		'goto increment_L to 1 to B3
	B4 = B4 + 1                     			'add 1 to B4
DEBUG "LDR has been looked at ",#B4," times",CR,CR
	PAUSE 1000                     			'wait one second
	IF B4 > 5 THEN DECREMENT     		'B2 hasn't increased, go to DECREMENT
					'to reset B2, B3 & B4
GOTO WAITING_FOR_CHANGE         			'keep going around this loop
INCREMENT_D:	              			'LDR has seen darkness
DEBUG "INCREMENT DARK B2 ",CR,CR       		'PC screen shows we are in increment
	B2 = B2 +1            				'B2 gets one more added to it
	IF B5 = 1 THEN HOLDOFF	      	'intercept Action, already done
	IF B2 > 10 THEN ACTION   		'LDR has seen at least 10 Dark signals

	GOTO WAITING_FOR_CHANGE 		'get back to looking at LDR signal
INCREMENT_L:				'LDR has seen light
DEBUG "INCREMENT LIGHT B3",CR,CR
	B3 = B3 +1				'B3 gets one more added to it
	IF B3 > 10 THEN RESET_B5       		'seen enough light to make change
	GOTO DECREMENT			'reset dark and light variables 
DECREMENT: 				'there has been no valid darkness  
DEBUG  "DECREMENT",CR     			'show on PC screen decrease happened
DEBUG "RESETING LDR STATUS",CR,CR 
	B2 = 0        				'set darkness count to zero
	B4 = 0     				'set false counts to zero
GOTO WAITING_FOR_CHANGE  			'go back to looking at LDR signal
ACTION:     					'Darkness criteria met, do something about it
SOUND 7,(60,100,80,100,100,100,120,100) 		'audible warning of action
DEBUG "ACTION, RELAY ON, LED ON",CR,CR  	'show on PC screen we are doing it
HIGH 0                                 					'turn relay on via ULN2003
HIGH 6                   					'turn LED on via ULN2003
PAUSE 2000      				'stay that way for 2 seconds
LOW  0       					'turn relay off
LOW  6       					'turn LED off
B2 = 0          					'reset B2
W4 = W4+1     				'keep count of times turned on
B5 = 1
DEBUG "Darkness has occured ",#W4," times",CR 	'show on PC screen count of events
GOTO WAITING_FOR_CHANGE    			'go back to looking at LDR signal
HOLDOFF:					'this is a loop to stop action already taken
DEBUG " HOLD OFF  UNTIL LIGHT SEEN"		'show on PC screen
B2 = 0					'reset B2
GOTO WAITING_FOR_CHANGE			'go back to keep looking at LDR
RESET_B5:				'Stop HOLDOFF cycling
DEBUG CR,CR," R E S E T   B5 & B3",CR,CR 		'Show on PC screen
	B5 = 0				'when B5 is 1 HOLDOFF is used
	B3 = 0				'reset light counts
GOTO WAITING_FOR_CHANGE			'go back and keep looking at LDR

